/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ldap.GSERValue;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.nds.BackLinkFacade;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

final class TaggedNameStrategy
extends ListStrategy {
    private int encoding;

    public TaggedNameStrategy(int encoding) {
        this.encoding = encoding;
    }

    public ValueComponent createValueComponent() {
        ValueList list = this.encoding == 1 ? new ValueList(LDAPSyntax.SYN_TAGGED_NAME) : new ValueList(LDAPSyntax.SYN_NVDS_TAGGED_NAME);
        list.initList(LDAPSyntax.SYN_DN.createValueComponent());
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueComponent createValueComponent(Object paramObj) throws ComponentCreationException {
        Long remoteId = null;
        String objectName = null;
        ValueList list = this.encoding == 1 ? new ValueList(LDAPSyntax.SYN_TAGGED_NAME) : new ValueList(LDAPSyntax.SYN_NVDS_TAGGED_NAME);
        if (paramObj instanceof Vector) {
            Vector compList = (Vector)paramObj;
            if (compList.size() != 2) {
                throw new ComponentCreationException();
            }
            Vector vector = compList;
            synchronized (vector) {
                Enumeration e = compList.elements();
                while (e.hasMoreElements()) {
                    Object comp = e.nextElement();
                    if (comp instanceof Long) {
                        remoteId = (Long)comp;
                        continue;
                    }
                    if (!(comp instanceof String)) continue;
                    objectName = (String)comp;
                }
            }
        } else if (paramObj instanceof String) {
            String str = (String)paramObj;
            if (str.charAt(0) == '{') {
                GSERValue gval = new GSERValue(str);
                remoteId = new Long((String)gval.get("type"));
                objectName = (String)gval.get("dn");
            } else {
                StringTokenizer st = new StringTokenizer(str, "#");
                if (st.countTokens() != 2) {
                    throw new ComponentCreationException();
                }
                remoteId = new Long(st.nextToken());
                objectName = st.nextToken();
            }
        } else {
            throw new ComponentCreationException();
        }
        list.initList(LDAPSyntax.SYN_DN.createValueComponent(objectName));
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent(remoteId));
        return list;
    }

    public Object createFacade(ValueComponent comp) throws IncompatibleComponentException {
        return new BackLinkFacade((ValueList)comp);
    }

    public String toString(ValueComponent vc) {
        if (vc instanceof ValueList) {
            ValueList list = (ValueList)vc;
            if (this.encoding == 2) {
                String dn = list.getElementAt(0).toString().replaceAll("\"", "\"\"");
                return "{ type " + list.getElementAt(1) + ", dn \"" + dn + "\" }";
            }
            return list.getElementAt(1).toString() + "#" + list.getElementAt(0).toString();
        }
        return vc.toString();
    }
}

