/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ldap.GSERValue;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.nds.EmailAddressFacade;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

final class TaggedStringStrategy
extends ListStrategy {
    private int encoding;

    public TaggedStringStrategy(int encoding) {
        this.encoding = encoding;
    }

    public ValueComponent createValueComponent() {
        ValueList list = this.encoding == 1 ? new ValueList(LDAPSyntax.SYN_TAGGED_STRING) : new ValueList(LDAPSyntax.SYN_NVDS_TAGGED_STRING);
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent());
        list.initList(LDAPSyntax.SYN_DIRECTORY_STRING.createValueComponent());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueComponent createValueComponent(Object paramObj) throws ComponentCreationException {
        Long type = null;
        String address = null;
        ValueList list = this.encoding == 1 ? new ValueList(LDAPSyntax.SYN_TAGGED_STRING) : new ValueList(LDAPSyntax.SYN_NVDS_TAGGED_STRING);
        if (paramObj instanceof Vector) {
            Vector compList = (Vector)paramObj;
            if (compList.size() != 2) {
                throw new ComponentCreationException();
            }
            Vector vector = compList;
            synchronized (vector) {
                Enumeration e = compList.elements();
                while (e.hasMoreElements()) {
                    Object comp = e.nextElement();
                    if (comp instanceof Long) {
                        type = (Long)comp;
                        continue;
                    }
                    if (!(comp instanceof String)) continue;
                    address = (String)comp;
                }
            }
        } else if (paramObj instanceof String) {
            String str = (String)paramObj;
            if (str.charAt(0) == '{') {
                GSERValue gval = new GSERValue(str);
                type = new Long((String)gval.get("type"));
                address = (String)gval.get("value");
            } else {
                StringTokenizer st = new StringTokenizer((String)paramObj, "#");
                if (st.countTokens() != 2) {
                    throw new ComponentCreationException();
                }
                type = new Long(st.nextToken());
                address = st.nextToken();
            }
        } else {
            throw new ComponentCreationException();
        }
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent(type));
        list.initList(LDAPSyntax.SYN_DIRECTORY_STRING.createValueComponent(address));
        return list;
    }

    public Object createFacade(ValueComponent comp) throws IncompatibleComponentException {
        return new EmailAddressFacade((ValueList)comp);
    }

    public String toString(ValueComponent vc) {
        if (vc instanceof ValueList) {
            ValueList list = (ValueList)vc;
            if (this.encoding == 2) {
                String value = list.getElementAt(1).toString().replaceAll("\"", "\"\"");
                return "{ type " + list.getElementAt(0) + ", value \"" + value + "\" }";
            }
            return list.getElementAt(0).toString() + "#" + list.getElementAt(1).toString();
        }
        return vc.toString();
    }
}

