/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.DateValue;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ldap.GSERValue;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.nds.TimeStampFacade;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

final class TimeStampStrategy
extends ListStrategy {
    TimeStampStrategy() {
    }

    public ValueComponent createValueComponent() {
        ValueList list = new ValueList(LDAPSyntax.SYN_NDS_TIMESTAMP);
        Long secs = new Long(new Date().getTime() / 1000L);
        try {
            list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent(secs));
        }
        catch (Exception e) {
            list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent());
        }
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent());
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent());
        return list;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ValueComponent createValueComponent(Object paramObj) throws ComponentCreationException {
        void var2_10;
        Object var2_2 = null;
        Number replica = null;
        Number event = null;
        ValueList list = new ValueList(LDAPSyntax.SYN_NDS_TIMESTAMP);
        if (paramObj instanceof Vector) {
            Vector compList = (Vector)paramObj;
            if (compList.size() == 3) {
                Enumeration e = compList.elements();
                while (e.hasMoreElements()) {
                    void var2_3;
                    Object comp = e.nextElement();
                    if (!(comp instanceof Number)) continue;
                    if (var2_3 == null) {
                        Number number = (Number)comp;
                        continue;
                    }
                    if (replica == null) {
                        replica = (Number)comp;
                        continue;
                    }
                    event = (Number)comp;
                    break;
                }
            } else {
                if (compList.size() != 4) throw new ComponentCreationException();
                Long l = new Long(DateValue.generalizedTimeToMs((String)compList.get(0)) / 1000L);
                replica = new Integer(0);
                event = (Integer)compList.get(3);
            }
        } else {
            if (!(paramObj instanceof String)) throw new ComponentCreationException();
            String str = (String)paramObj;
            if (str.charAt(0) == '{') {
                GSERValue gval = new GSERValue(str);
                Long l = new Long(DateValue.generalizedTimeToMs((String)gval.get("time")) / 1000L);
                replica = new Integer(0);
                event = new Integer((String)gval.get("changeCount"));
            } else {
                StringTokenizer st = new StringTokenizer((String)paramObj, "#");
                if (st.countTokens() != 3) {
                    throw new ComponentCreationException();
                }
                Long l = new Long(st.nextToken());
                replica = new Integer(st.nextToken());
                event = new Integer(st.nextToken());
            }
        }
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent(var2_10));
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent(replica));
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent(event));
        return list;
    }

    public Object createFacade(ValueComponent comp) throws IncompatibleComponentException {
        return new TimeStampFacade((ValueList)comp);
    }

    public String toString(ValueComponent vc) {
        if (vc instanceof ValueList) {
            ValueList list = (ValueList)vc;
            return list.getElementAt(0).toString() + "#" + list.getElementAt(1).toString() + "#" + list.getElementAt(2).toString();
        }
        return vc.toString();
    }
}

