/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap.jndi;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.SimpleSPIException;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.OEComparator;
import com.novell.admin.ns.ldap.jndi.LDAPNamespaceImpl;
import com.novell.application.console.snapin.CountableObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.ResultModifier;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public final class ChildObjectEntryEnumerationImpl
implements ObjectEntryEnumeration,
CountableObjectEntryEnumeration {
    private boolean subtree = false;
    private boolean returnContainersOnly;
    private Vector childResultVector;
    private Enumeration childOEEnum;
    private ObjectEntry parentEntry;
    private DirContext ctx;
    private LDAPNamespaceImpl namespace;
    private NamingEnumeration results;
    private static final int MAX_ITEMS_TO_RETURN = 7000;
    private int internalCountReliability = 5;
    private int internalCrackedCount = 0;
    private SimpleSPIException spiException = new SimpleSPIException("com.novell.admin.ns.NSResourceBundle");

    public ChildObjectEntryEnumerationImpl(ObjectEntry parent, ResultModifier modifier, boolean returnContainersOnly) throws SPIException {
        String filter = "(objectClass=*)";
        this.parentEntry = parent;
        this.returnContainersOnly = returnContainersOnly;
        this.namespace = (LDAPNamespaceImpl)parent.getObjectType().getNamespace();
        this.ctx = (DirContext)this.namespace.getContext();
        if (modifier != null) {
            this.subtree = modifier.isSubContainerSearch();
            filter = modifier.getFilterString(this.namespace);
        }
        try {
            boolean DSAControlWasSet = this.namespace.isControlSet("2.16.840.1.113730.3.4.2");
            if (!DSAControlWasSet && modifier != null && modifier.getShowGlue()) {
                this.namespace.setControl("2.16.840.1.113730.3.4.2");
            }
            String toSearch = this.namespace.getFullName(parent);
            int scope = this.subtree ? 2 : 1;
            this.search(toSearch, scope, filter);
            if (!DSAControlWasSet && modifier != null && modifier.getShowGlue()) {
                this.namespace.clearControl("2.16.840.1.113730.3.4.2");
            }
            this.childResultVector = this.crackEntries(this.results);
            this.internalCrackedCount = this.childResultVector.size();
            this.internalCountReliability = this.internalCrackedCount == 7000 ? 3 : 1;
            if (modifier != null && modifier.getSortByKey() != 0) {
                OEComparator oeComparator = new OEComparator(modifier.getSortByKey(), this.namespace);
                Collections.sort(this.childResultVector, oeComparator);
            }
            if (modifier != null && modifier.getSortOrderKey() == 1) {
                this.reverseVector(this.childResultVector);
            }
            this.childOEEnum = this.childResultVector.elements();
        }
        catch (Exception x) {
            throw this.resolveSPIException(x);
        }
    }

    private void search(String base, int scope, String filter) throws NamingException {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(scope);
        controls.setCountLimit(7000L);
        controls.setReturningAttributes(new String[]{"structuralObjectClass", "objectClass", "dseObjectClass"});
        this.results = this.ctx.search(base, filter, controls);
    }

    public int getCount() {
        return this.internalCrackedCount;
    }

    public int getCountReliability() {
        return this.internalCountReliability;
    }

    public boolean hasMoreElements() {
        return this.childOEEnum.hasMoreElements();
    }

    public Object nextElement() {
        return this.childOEEnum.nextElement();
    }

    public ObjectEntry next() {
        return (ObjectEntry)this.childOEEnum.nextElement();
    }

    private Vector crackEntries(Enumeration entryEnum) {
        Vector<ObjectEntry> vec = new Vector<ObjectEntry>();
        while (entryEnum.hasMoreElements()) {
            SearchResult entry = (SearchResult)entryEnum.nextElement();
            try {
                ObjectEntry oe = this.crackLDAPEntry(entry);
                ObjectType ot = oe.getObjectType();
                if (this.returnContainersOnly && !ot.isContainer()) continue;
                vec.add(oe);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return vec;
    }

    ObjectEntry crackLDAPEntry(SearchResult entry) {
        String childName = null;
        try {
            ClassDefinition classDef;
            ObjectType ot = null;
            int flags = 0;
            String baseClass = "";
            Attributes attrs = entry.getAttributes();
            Attribute attr = attrs.get("structuralObjectClass");
            if (attr == null) {
                attr = attrs.get("objectClass");
            }
            if (attr != null) {
                baseClass = (String)attr.get(0);
            }
            if ((attr = attrs.get("dseObjectClass")) != null) {
                NamingEnumeration<?> ne = attr.getAll();
                while (ne.hasMore()) {
                    String str = ((String)ne.next()).toLowerCase();
                    if (!str.equals("gluedse") && !str.equals("subrdse") && !str.equals("suprdse") && !str.equals("immsuprdse") && !str.equals("xrdse")) continue;
                    flags |= 0x20;
                }
            }
            childName = entry.getName();
            if (baseClass.equalsIgnoreCase("Alias")) {
                String targetDN;
                flags |= 1;
                String parentDN = this.namespace.getFullName(this.parentEntry);
                String childFullName = childName;
                childFullName = childFullName.length() == 0 || parentDN.length() == 0 ? childName + parentDN : childName + "," + parentDN;
                attrs = this.ctx.getAttributes(childFullName, new String[]{"aliasedObjectName"});
                if (attrs != null && (attr = attrs.get("aliasedObjectName")) != null && (targetDN = (String)attr.get()) != null) {
                    attrs = this.ctx.getAttributes(targetDN, new String[]{"structuralObjectClass", "objectClass"});
                    attr = attrs.get("structuralObjectClass");
                    if (attr == null) {
                        attr = attrs.get("objectClass");
                    }
                    if (attr != null) {
                        baseClass = (String)attr.get(0);
                    }
                }
            }
            if ((ot = this.namespace.getObjectType(this.parentEntry, baseClass)) == null) {
                baseClass = "any";
                ot = this.namespace.getObjectType(this.parentEntry, baseClass);
            }
            if ((classDef = this.namespace.getSchemaDefinition(this.parentEntry).getClassDefinition(baseClass)).isContainer()) {
                flags = (flags & 1) != 0 ? (flags |= 8) : (flags |= 4);
            }
            return new ObjectEntry(childName, ot, this.parentEntry, flags, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private SPIException resolveSPIException(Exception x) {
        SPIException exception = null;
        if (x instanceof NamingException) {
            exception = this.spiException.newException(x);
        } else if (x instanceof SPIException) {
            exception = (SPIException)x;
        }
        if (exception == null) {
            exception = this.spiException.newException(x);
        }
        return exception;
    }

    private void reverseVector(Vector vec) {
        int len = vec.size();
        for (int i = 0; i < len / 2; ++i) {
            Object tmp = vec.elementAt(i);
            vec.setElementAt(vec.elementAt(len - 1 - i), i);
            vec.setElementAt(tmp, len - 1 - i);
        }
    }
}

