/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap.jndi;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.SchemaCacheManager;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ldap.ContentRule;
import com.novell.admin.ns.ldap.LDAPAttributeDefinition;
import com.novell.admin.ns.ldap.LDAPAttributeFlags;
import com.novell.admin.ns.ldap.LDAPClassDefinition;
import com.novell.admin.ns.ldap.LDAPClassFlags;
import com.novell.admin.ns.ldap.LDAPSchemaDefinition;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.ldap.LDAPschema;
import com.novell.admin.ns.ldap.NameForm;
import com.novell.admin.ns.ldap.StructureRules;
import com.novell.admin.ns.ldap.jndi.LDAPNamespaceImpl;
import com.novell.application.console.snapin.Debug;
import com.novell.application.console.snapin.ObjectType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;

public class LDAPSchemaImpl
implements LDAPschema {
    private DirContext schema;
    private DirContext ctx;
    private LDAPSchemaDefinition schemaDef;
    private LDAPNamespaceImpl namespace;
    private String hostname;
    private HashMap nameFormsMap = new HashMap();
    private HashMap structureRulesMap = new HashMap();
    private HashMap contentRulesMap = new HashMap();
    private String subschemaName = null;
    private String[] aclScopes = null;
    private static final int GET_ATTR_DEF1 = 1;
    private static final int ATTRIBUTE_SET_ADD = 2;
    private static final int ATTRIBUTE_SET_MODIFY = 3;
    private static final int BAD_ATTR_GET1 = 4;
    private static final int BAD_ATTR_GET2 = 5;
    private static final int GET_ATTR_DEF2 = 6;
    private static final int NO_SYNTAX = 7;
    private static final int BAD_ATTR_DEF_GET = 8;
    private static final int GET_CLASS_DEF = 9;

    public LDAPSchemaImpl(LDAPNamespaceImpl ns2, DirContext ctx, String sourceObj, String hostname) throws NamingException {
        this.ctx = ctx;
        this.namespace = ns2;
        this.hostname = hostname;
        if (sourceObj == null) {
            sourceObj = "";
        }
        try {
            Hashtable<?, ?> ht = ctx.getEnvironment();
            String trustee = (String)ht.get("java.naming.security.principal");
            this.subschemaName = (String)SchemaCacheManager.getInstance().getLDAPSchemaAttribute("subSchemaSubEntry", hostname, trustee, ctx, sourceObj).get();
            this.schema = SchemaCacheManager.getInstance().getLDAPSchema(sourceObj, ctx, hostname, this.subschemaName, trustee);
            this.schemaDef = new LDAPSchemaDefinition(this, ns2);
            this.readAttributeDefinitions(null);
            this.readClassDefinitions(null);
            this.readNameAndStructureRules(ctx);
            this.aclScopes = this.parseACLScopes();
            this.schemaDef.generateExpandedDefinitions();
        }
        catch (NamespaceException ne) {
            throw new NamingException(ne.getLocalizedMessage());
        }
    }

    public void refreshSchema() {
        try {
            this.schema = this.ctx.getSchema("");
            this.readAttributeDefinitions(null);
            this.readClassDefinitions(null);
            this.readNameAndStructureRules(this.ctx);
            this.schemaDef.generateExpandedDefinitions();
        }
        catch (NamingException ne) {
            Debug.out("Unable to read schema in refreshSchema: " + ne);
        }
        catch (NamespaceException ne) {
            Debug.out("Unable to read schema in refreshSchema: " + ne);
        }
    }

    public ObjectType getObjectType(String className) throws SPIException {
        return this.schemaDef.getObjectType(className);
    }

    private void readAttributeDefinitions(ArrayList attributeNames) throws NamingException {
        try {
            if (attributeNames == null) {
                this.schemaDef.clearAttributes();
                NamingEnumeration<NameClassPair> ne = this.schema.list("AttributeDefinition");
                while (ne.hasMore()) {
                    this.schemaDef.addAttributeDefinition(this.crackAttributeDefinition(ne.next().getName()));
                }
            } else {
                for (String attrName : attributeNames) {
                    this.schemaDef.addAttributeDefinition(this.crackAttributeDefinition(attrName));
                }
            }
            AttributeDefinition[] attrDefs = this.schemaDef.getAttributeDefinitions();
            for (int i = 0; i < attrDefs.length; ++i) {
                if (attrDefs[i].getSyntax() != null) continue;
                String supOID = ((LDAPAttributeDefinition)attrDefs[i]).getSupOID();
                if (supOID != null) {
                    LDAPAttributeDefinition supAttr = (LDAPAttributeDefinition)this.schemaDef.getAttributeDefinition(supOID);
                    if (supAttr == null) continue;
                    ((LDAPAttributeDefinition)attrDefs[i]).setSyntax(supAttr.getSyntax());
                    continue;
                }
                ((LDAPAttributeDefinition)attrDefs[i]).setSyntax(LDAPSyntax.SYN_UNKNOWN);
            }
        }
        catch (NamespaceException ne) {
            throw new NamingException(ne.getLocalizedMessage());
        }
    }

    private void readClassDefinitions(ArrayList classNames) throws NamingException {
        if (classNames == null) {
            this.schemaDef.clearClasses();
            this.schemaDef.clearObjectTypeCache();
            NamingEnumeration<NameClassPair> ne = this.schema.list("ClassDefinition");
            while (ne.hasMore()) {
                this.schemaDef.addClassDefinition(this.crackClassDefinition(ne.next().getName()));
            }
        } else {
            for (String className : classNames) {
                this.schemaDef.addClassDefinition(this.crackClassDefinition(className));
            }
        }
    }

    private AttributeDefinition crackAttributeDefinition(String attrName) throws NamingException {
        LDAPAttributeDefinition attrDef = null;
        String[] aliasArray = null;
        try {
            String s;
            int i;
            int flags = 0;
            long upperBound = Integer.MAX_VALUE;
            long lowerBound = Integer.MIN_VALUE;
            String syntaxOID = null;
            String supOID = null;
            String equalityOID = null;
            String orderingOID = null;
            String substrOID = null;
            String NDAPName = null;
            DirContext attrSchema = (DirContext)this.schema.lookup("AttributeDefinition/" + attrName);
            Attributes attrs = attrSchema.getAttributes("");
            String attrOID = (String)attrs.get("NUMERICOID").get();
            Attribute attr = attrs.get("SYNTAX");
            if (attr != null && (syntaxOID = (String)attr.get()) != null && (i = syntaxOID.indexOf("{")) > 0) {
                upperBound = Long.parseLong(syntaxOID.substring(i + 1, syntaxOID.length() - 1));
                syntaxOID = syntaxOID.substring(0, i);
                flags |= 2;
            }
            Syntax syntax = LDAPSyntax.getSyntax(syntaxOID);
            attr = attrs.get("X-NDS_LOWER_BOUND");
            if (attr != null) {
                lowerBound = Long.parseLong((String)attr.get());
                flags |= 2;
            }
            if ((attr = attrs.get("X-ELEMENTMIN")) != null) {
                lowerBound = Long.parseLong((String)attr.get());
                flags |= 2;
            }
            if ((attr = attrs.get("X-ELEMENTMAX")) != null) {
                upperBound = Long.parseLong((String)attr.get());
                flags |= 2;
            }
            ArrayList<String> v = new ArrayList<String>(3);
            Attribute aliasAttr = attrs.get("NAME");
            if (aliasAttr != null) {
                NamingEnumeration<?> aliasNE = aliasAttr.getAll();
                while (aliasNE.hasMore()) {
                    String aName = (String)aliasNE.next();
                    if (aName.equals(attrName)) continue;
                    v.add(aName);
                }
                aliasArray = v.toArray(new String[0]);
            }
            if ((attr = attrs.get("SUP")) != null) {
                supOID = (String)attr.get();
            }
            if ((attr = attrs.get("EQUALITY")) != null) {
                equalityOID = (String)attr.get();
            }
            if ((attr = attrs.get("ORDERING")) != null) {
                orderingOID = (String)attr.get();
            }
            if ((attr = attrs.get("SUBSTR")) != null) {
                substrOID = (String)attr.get();
            }
            if ((attr = attrs.get("X-NDS_NAME")) != null) {
                NDAPName = (String)attr.get();
            }
            if ((attr = attrs.get("SINGLE-VALUE")) != null && attr.get().equals("true")) {
                flags |= 1;
            }
            if ((attr = attrs.get("NO-USER-MODIFICATION")) != null && attr.get().equals("true")) {
                flags |= 8;
            }
            if ((attr = attrs.get("X-NDS_READ_FILTERED")) != null && attr.get().equals("1")) {
                flags |= 0x1000;
            }
            if ((attr = attrs.get("USAGE")) != null && ((s = (String)attr.get()).equals("directoryOperation") || s.equals("dSAOperation"))) {
                flags |= 0x1000;
            }
            if ((attr = attrs.get("X-NDS_NONREMOVABLE")) != null && attr.get().equals("1")) {
                flags |= 4;
            }
            if ((attr = attrs.get("X-NDS_HIDDEN")) != null && attr.get().equals("1")) {
                flags |= 0x10;
            }
            if ((attr = attrs.get("X-NDS_NOT_SCHED_SYNC_IMMEDIATE")) != null && attr.get().equals("1")) {
                flags |= 0x40;
            }
            if ((attr = attrs.get("X-NDS_PUBLIC_READ")) != null && attr.get().equals("1")) {
                flags |= 0x80;
            }
            if ((attr = attrs.get("X-NDS_SERVER_READ")) != null && attr.get().equals("1")) {
                flags |= 0x100;
            }
            if ((attr = attrs.get("X-NDS_NAME_VALUE_ACCESS")) != null && attr.get().equals("1")) {
                flags |= 0x200;
            }
            if ((attr = attrs.get("X-NDS_NEVER_SYNC")) != null && attr.get().equals("1")) {
                flags |= 0x400;
            }
            if ((attr = attrs.get("X-NDS_SCHED_SYNC_NEVER")) != null && attr.get().equals("1")) {
                flags |= 0x800;
            }
            if ((attr = attrs.get("X-NDS_FILTERED_REQUIRED")) != null && attr.get().equals("1")) {
                flags |= 0x2000;
            }
            if ((attr = attrs.get("X-NDS_FILTERED_OPERATIONAL")) != null && attr.get().equals("1")) {
                flags |= 0x4000;
            }
            if ((attr = attrs.get("X-NDS_BOTH_MANAGED")) != null && attr.get().equals("1")) {
                flags |= 0x8000;
            }
            if ((attr = attrs.get("X-NDS_ENCRYPTED_SYNC")) != null && attr.get().equals("1")) {
                flags |= 0x10000;
            }
            attrDef = new LDAPAttributeDefinition(attrName, syntax, lowerBound, upperBound, aliasArray, new LDAPAttributeFlags(flags), attrOID, NDAPName, supOID, equalityOID, orderingOID, substrOID);
        }
        catch (NamespaceException e) {
            throw new NamingException(e.getLocalizedMessage());
        }
        return attrDef;
    }

    private ClassDefinition crackClassDefinition(String className) throws NamingException {
        Attribute containmentAttr;
        String nr;
        Attribute nrAttr;
        Attribute aliasAttr;
        LDAPClassDefinition classDef = null;
        ArrayList<Object> v = new ArrayList<Object>();
        String[] aliasArray = null;
        String[] classContainments = null;
        String[] superClasses = null;
        AttributeDefinition[] mandatoryArray = null;
        AttributeDefinition[] namingArray = null;
        AttributeDefinition[] optionalArray = null;
        String NDAPName = null;
        Attributes classSchema = this.schema.getAttributes("ClassDefinition/" + className);
        if (classSchema == null) {
            throw new AdminError(9, this.getClass());
        }
        String oid = null;
        Attribute name = classSchema.get("NUMERICOID");
        if (name != null) {
            oid = (String)name.get();
        }
        if ((aliasAttr = classSchema.get("NAME")) != null) {
            NamingEnumeration<?> aliasNE = aliasAttr.getAll();
            while (aliasNE.hasMore()) {
                String aName = (String)aliasNE.next();
                if (aName.equals(className)) continue;
                v.add(aName);
            }
            aliasArray = v.toArray(new String[0]);
        }
        int flags = 1;
        String abstractc = null;
        Attribute abstractAttr = classSchema.get("ABSTRACT");
        if (abstractAttr != null && (abstractc = (String)abstractAttr.get()) != null && abstractc.equals("true")) {
            flags &= 0xFFFFFFFE;
        }
        String auxiliary = null;
        Attribute auxiliaryAttr = classSchema.get("AUXILIARY");
        if (auxiliaryAttr != null && (auxiliary = (String)auxiliaryAttr.get()) != null && auxiliary.equals("true")) {
            flags &= 0xFFFFFFFE;
            flags |= 2;
        }
        v.clear();
        Attribute mustAttr = classSchema.get("MUST");
        if (mustAttr != null) {
            NamingEnumeration<?> must = mustAttr.getAll();
            while (must.hasMore()) {
                String attrName = (String)must.next();
                try {
                    v.add(this.schemaDef.getAttributeDefinition(attrName));
                }
                catch (NamespaceException namespaceException) {}
            }
            mandatoryArray = v.toArray(new AttributeDefinition[0]);
        }
        v.clear();
        Attribute mayAttr = classSchema.get("MAY");
        if (mayAttr != null) {
            NamingEnumeration<?> may = mayAttr.getAll();
            while (may.hasMore()) {
                String attrName = (String)may.next();
                try {
                    v.add(this.schemaDef.getAttributeDefinition(attrName));
                }
                catch (NamespaceException namespaceException) {}
            }
            optionalArray = v.toArray(new AttributeDefinition[0]);
        }
        v.clear();
        Attribute namingAttr = classSchema.get("X-NDS_NAMING");
        if (namingAttr != null) {
            NamingEnumeration<?> naming = namingAttr.getAll();
            while (naming.hasMore()) {
                String attrName = (String)naming.next();
                try {
                    v.add(this.schemaDef.getAttributeDefinition(attrName));
                }
                catch (NamespaceException namespaceException) {}
            }
            namingArray = v.toArray(new LDAPAttributeDefinition[0]);
        }
        if ((flags & 2) == 0) {
            String container;
            flags |= 4;
            Attribute containerAttr = classSchema.get("X-NDS_NOT_CONTAINER");
            if (containerAttr != null) {
                container = (String)containerAttr.get();
                if (container.equals("1")) {
                    flags &= 0xFFFFFFFB;
                }
            } else {
                containerAttr = classSchema.get("X-LEAFONLY");
                if (containerAttr != null && (container = (String)containerAttr.get()).equals("true")) {
                    flags &= 0xFFFFFFFB;
                }
            }
        }
        if ((nrAttr = classSchema.get("X-NDS_NONREMOVABLE")) != null && (nr = (String)nrAttr.get()).equals("1")) {
            flags |= 8;
        }
        if ((containmentAttr = classSchema.get("X-NDS_CONTAINMENT")) != null) {
            v.clear();
            NamingEnumeration<?> contEnum = containmentAttr.getAll();
            while (contEnum.hasMore()) {
                v.add(contEnum.next());
            }
            classContainments = v.toArray(new String[0]);
        }
        v.clear();
        Attribute supAttr = classSchema.get("SUP");
        if (supAttr != null) {
            NamingEnumeration<?> sup = supAttr.getAll();
            while (sup.hasMore()) {
                v.add(sup.next());
            }
            superClasses = v.toArray(new String[0]);
        }
        if ((name = classSchema.get("X-NDS_NAME")) != null) {
            NDAPName = (String)name.get();
        }
        LDAPClassFlags classFlags = new LDAPClassFlags(flags);
        classDef = new LDAPClassDefinition(className, aliasArray, classFlags, classContainments, superClasses, mandatoryArray, namingArray, optionalArray, oid, NDAPName, this.schemaDef);
        return classDef;
    }

    public ClassDefinition getClassDefinition(String className) throws SPIException {
        LDAPClassDefinition classDef = null;
        try {
            classDef = (LDAPClassDefinition)this.schemaDef.getClassDefinition(className);
        }
        catch (NamespaceException x) {
            return null;
        }
        return classDef;
    }

    public AttributeDefinition getAttributeDefinition(String attrName) throws SPIException {
        try {
            return this.schemaDef.getAttributeDefinition(attrName);
        }
        catch (NamespaceException ex) {
            if (ex.equals(NamespaceException.ATTRIBUTE_NOT_DEFINED)) {
                try {
                    LDAPAttributeDefinition lad = null;
                    lad = new LDAPAttributeDefinition(attrName, (Syntax)LDAPSyntax.SYN_DIRECTORY_STRING, new LDAPAttributeFlags(4104), "OID-Unknown");
                    this.schemaDef.addAttributeDefinition(lad);
                    return lad;
                }
                catch (NamespaceException namespaceException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public SchemaDefinition getSchemaDefinition() throws SPIException {
        return this.schemaDef;
    }

    public void writeAttributeDefinition(AttributeDefinition attributeDef) throws SPIException {
        BasicAttributes attrs = new BasicAttributes(true);
        try {
            String NDAPName;
            LDAPAttributeDefinition attrDef = (LDAPAttributeDefinition)attributeDef;
            LDAPAttributeFlags flags = attrDef.getAttributeFlag();
            attrs.put("NUMERICOID", attrDef.getOID());
            BasicAttribute attr = new BasicAttribute("NAME");
            attr.add(attrDef.getName());
            String[] aliasNames = attrDef.getAliasNames();
            for (int i = 0; i < aliasNames.length; ++i) {
                attr.add(aliasNames[i]);
            }
            attrs.put(attr);
            String syntaxOID = ((LDAPSyntax)attrDef.getSyntax()).getOID();
            if (attrDef.isSized() && attrDef.getUpperBound() != Integer.MAX_VALUE) {
                syntaxOID = syntaxOID + "{" + attrDef.getUpperBound() + "}";
            }
            attrs.put("SYNTAX", syntaxOID);
            if (flags.isFlagSet(1)) {
                attrs.put(new BasicAttribute("SINGLE-VALUE"));
            }
            if (flags.isFlagSet(8)) {
                attrs.put(new BasicAttribute("NO-USER-MODIFICATION"));
            }
            if ((NDAPName = attrDef.getNDAPName()) != null) {
                attrs.put("X-NDS_NAME", NDAPName);
            }
            if (attrDef.isSized() && attrDef.getLowerBound() != Integer.MIN_VALUE) {
                attrs.put("X-NDS_LOWER_BOUND", Long.toString(attrDef.getLowerBound()));
            }
            if (flags.isFlagSet(4)) {
                attrs.put("X-NDS_NONREMOVABLE", "1");
            }
            if (flags.isFlagSet(16)) {
                attrs.put("X-NDS_HIDDEN", "1");
            }
            if (flags.isFlagSet(64)) {
                attrs.put("X-NDS_NOT_SCHED_SYNC_IMMEDIATE", "1");
            }
            if (flags.isFlagSet(128)) {
                attrs.put("X-NDS_PUBLIC_READ", "1");
            }
            if (flags.isFlagSet(256)) {
                attrs.put("X-NDS_SERVER_READ", "1");
            }
            if (flags.isFlagSet(512)) {
                attrs.put("X-NDS_NAME_VALUE_ACCESS", "1");
            }
            if (flags.isFlagSet(1024)) {
                attrs.put("X-NDS_NEVER_SYNC", "1");
            }
            if (flags.isFlagSet(2048)) {
                attrs.put("X-NDS_SCHED_SYNC_NEVER", "1");
            }
            if (flags.isFlagSet(4096)) {
                attrs.put("X-NDS_READ_FILTERED", "1");
            }
            if (flags.isFlagSet(8192)) {
                attrs.put("X-NDS_FILTERED_REQUIRED", "1");
            }
            if (flags.isFlagSet(16384)) {
                attrs.put("X-NDS_FILTERED_OPERATIONAL", "1");
            }
            if (flags.isFlagSet(32768)) {
                attrs.put("X-NDS_BOTH_MANAGED", "1");
            }
            if (flags.isFlagSet(65536)) {
                attrs.put("X-NDS_ENCRYPTED_SYNC", "1");
            }
            this.schema.createSubcontext("AttributeDefinition/" + attrDef.getName(), (Attributes)attrs);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public void deleteAttributeDefinition(AttributeDefinition attributeDef) throws SPIException {
        try {
            this.schema.destroySubcontext("AttributeDefinition/" + attributeDef.getName());
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public void modifyClassDefinition(ClassDefinition classDef) throws SPIException {
        BasicAttributes attrSet = new BasicAttributes();
        try {
            int i;
            String className = classDef.getName();
            ClassDefinition currentClassDef = this.schemaDef.getRawClassDefinition(className);
            AttributeDefinition[] currentOptionalAttributes = currentClassDef.getOptionalAttributes();
            AttributeDefinition[] newOptionalAttributes = classDef.getOptionalAttributes();
            ArrayList<String> currentOptionalAttributesList = new ArrayList<String>();
            for (i = 0; i < currentOptionalAttributes.length; ++i) {
                currentOptionalAttributesList.add(currentOptionalAttributes[i].getName().toLowerCase());
            }
            BasicAttribute attr = new BasicAttribute("MAY");
            for (i = 0; i < newOptionalAttributes.length; ++i) {
                if (currentOptionalAttributesList.contains(newOptionalAttributes[i].getName().toLowerCase())) continue;
                attr.add(newOptionalAttributes[i].getName());
            }
            attrSet.put(attr);
            this.schema.modifyAttributes("ClassDefinition/" + className, 1, (Attributes)attrSet);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeClassDefinition(ClassDefinition classDef) throws SPIException {
        BasicAttributes attrSet = new BasicAttributes(true);
        BasicAttribute attr = null;
        String className = classDef.getName();
        try {
            String NDAPName;
            String[] contAttr;
            AttributeDefinition[] namingAttr;
            AttributeDefinition[] optAttr;
            String oid = ((LDAPClassDefinition)classDef).getOID();
            attrSet.put("NUMERICOID", oid);
            attr = new BasicAttribute("NAME");
            attr.add(className);
            String[] aliasNames = classDef.getAliasNames();
            for (int i = 0; i < aliasNames.length; ++i) {
                attr.add(aliasNames[i]);
            }
            attrSet.put(attr);
            String[] superClasses = classDef.getSuperClasses();
            if (superClasses.length > 0) {
                attr = new BasicAttribute("SUP");
                for (int i = 0; i < superClasses.length; ++i) {
                    attr.add(superClasses[i]);
                }
                attrSet.put(attr);
            }
            attr = classDef.isAuxiliary() ? new BasicAttribute("AUXILIARY") : (classDef.isEffective() ? new BasicAttribute("STRUCTURAL") : new BasicAttribute("ABSTRACT"));
            attrSet.put(attr);
            AttributeDefinition[] mandAttr = classDef.getMandatoryAttributes();
            if (mandAttr.length > 0) {
                attr = new BasicAttribute("MUST");
                for (int i = 0; i < mandAttr.length; ++i) {
                    attr.add(mandAttr[i].getName());
                }
                attrSet.put(attr);
            }
            if ((optAttr = classDef.getOptionalAttributes()).length > 0) {
                attr = new BasicAttribute("MAY");
                for (int i = 0; i < optAttr.length; ++i) {
                    attr.add(optAttr[i].getName());
                }
                attrSet.put(attr);
            }
            if (!classDef.isContainer()) {
                attrSet.put("X-NDS_NOT_CONTAINER", "1");
            }
            if ((namingAttr = classDef.getNamingAttributes()).length > 0) {
                attr = new BasicAttribute("X-NDS_NAMING");
                for (int i = 0; i < namingAttr.length; ++i) {
                    attr.add(namingAttr[i].getName());
                }
                attrSet.put(attr);
            }
            if ((contAttr = classDef.getContainmentClasses()).length > 0) {
                attr = new BasicAttribute("X-NDS_CONTAINMENT");
                for (int i = 0; i < contAttr.length; ++i) {
                    attr.add(contAttr[i]);
                }
                attrSet.put(attr);
            }
            if (classDef.isNonRemovable()) {
                attrSet.put("X-NDS_NONREMOVABLE", "1");
            }
            if (classDef instanceof LDAPClassDefinition && (NDAPName = ((LDAPClassDefinition)classDef).getNDAPName()) != null) {
                attrSet.put("X-NDS_NAME", NDAPName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.schema.createSubcontext("ClassDefinition/" + className, (Attributes)attrSet);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    public void deleteClassDefinition(ClassDefinition classDef) throws SPIException {
        try {
            this.schema.destroySubcontext("ClassDefinition/" + classDef.getName());
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private void readNameAndStructureRules(DirContext ctx) {
        try {
            NameForm nf;
            if (this.subschemaName == null) {
                return;
            }
            Hashtable<?, ?> ht = ctx.getEnvironment();
            String trustee = (String)ht.get("java.naming.security.principal");
            Attributes attrs = SchemaCacheManager.getInstance().getLDAPSchemaAttributes(new String[]{"nameForms", "dITStructureRules", "dITContentRules"}, this.hostname, trustee, ctx, this.subschemaName, this.subschemaName);
            Attribute attr = attrs.get("nameForms");
            if (attr != null) {
                String val;
                NamingEnumeration<?> ne = attr.getAll();
                while (ne.hasMore()) {
                    val = (String)ne.next();
                    nf = new NameForm(val);
                    String name = nf.getName();
                    if (name == null) {
                        name = nf.getOID();
                    }
                    this.nameFormsMap.put(name, nf);
                }
                attr = attrs.get("dITStructureRules");
                if (attr != null) {
                    ne = attr.getAll();
                    while (ne.hasMore()) {
                        val = (String)ne.next();
                        StructureRules sr = new StructureRules(val);
                        String ruleID = sr.getRuleID();
                        this.structureRulesMap.put(ruleID, sr);
                    }
                }
            }
            Iterator it = this.nameFormsMap.values().iterator();
            while (it.hasNext()) {
                try {
                    NameForm nf2 = (NameForm)it.next();
                    ClassDefinition classDef = this.schemaDef.getRawClassDefinition(nf2.getObjectClass());
                    ArrayList attrList = nf2.getMust();
                    if (attrList == null) {
                        attrList = new ArrayList();
                    }
                    attrList.addAll(nf2.getMay());
                    if (attrList == null) continue;
                    for (int i = 0; i < attrList.size(); ++i) {
                        AttributeDefinition attrDef = this.schemaDef.getAttributeDefinition((String)attrList.get(i));
                        classDef.addNamingAttribute(attrDef);
                    }
                }
                catch (Exception nf2) {
                }
            }
            it = this.structureRulesMap.values().iterator();
            while (it.hasNext()) {
                try {
                    StructureRules sr = (StructureRules)it.next();
                    nf = (NameForm)this.nameFormsMap.get(sr.getNameForm());
                    ClassDefinition classDef = this.schemaDef.getRawClassDefinition(nf.getObjectClass());
                    ArrayList supList = sr.getSuperior();
                    if (supList.size() > 0) {
                        for (int i = 0; i < supList.size(); ++i) {
                            StructureRules supSR = (StructureRules)this.structureRulesMap.get(supList.get(i));
                            String className = ((NameForm)this.nameFormsMap.get(supSR.getNameForm())).getObjectClass();
                            classDef.addContainmentClass(className);
                        }
                        continue;
                    }
                    String[] nc = this.namespace.getNamingContexts();
                    String[] ncBase = this.namespace.getNamingContextBaseClass();
                    for (int i = 0; i < nc.length; ++i) {
                        classDef.addContainmentClass(ncBase[i]);
                    }
                }
                catch (Exception sr) {
                }
            }
            if (this.structureRulesMap.size() != 0) {
                HashSet<String> hs = new HashSet<String>(30);
                ClassDefinition[] cd = this.schemaDef.getRawClassDefinitions();
                for (int i = 0; i < cd.length; ++i) {
                    String[] conts = cd[i].getContainmentClasses();
                    if (conts == null) continue;
                    for (int j = 0; j < conts.length; ++j) {
                        hs.add(conts[j].toLowerCase());
                    }
                }
                this.schemaDef.reconfigureContainerClasses(hs);
            }
            if ((attr = attrs.get("dITContentRules")) != null) {
                NamingEnumeration<?> ne = attr.getAll();
                while (ne.hasMore()) {
                    String val = (String)ne.next();
                    ContentRule crule = new ContentRule(val);
                    String name = crule.getName();
                    if (name == null) {
                        name = crule.getOID();
                    }
                    this.contentRulesMap.put(name, crule);
                }
                ClassDefinition[] cdef = this.schemaDef.getRawClassDefinitions();
                for (int i = 0; i < cdef.length; ++i) {
                    cdef[i].initAuxClasses();
                }
                for (ContentRule crule : this.contentRulesMap.values()) {
                    String className = crule.getName();
                    ClassDefinition cd = this.schemaDef.getRawClassDefinition(className);
                    if (cd == null) continue;
                    cd.addValidAuxClasses(crule.getAux());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] getACLScopes() {
        return this.aclScopes;
    }

    private String[] parseACLScopes() {
        try {
            DirContext dctx = (DirContext)this.schema.lookup("SyntaxDefinition/2.16.840.1.113719.1.1.5.1.39");
            Attribute attr = dctx.getAttributes("").get("X-OIDRESTRICTION");
            String[] scopes = new String[attr.size()];
            for (int i = 0; i < scopes.length; ++i) {
                scopes[i] = (String)attr.get(i);
            }
            return scopes;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void modifyAttributeDefinition(AttributeDefinition attributeDef) throws SPIException {
    }
}

