/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap.jndi;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ldap.LDAPControl;
import com.novell.admin.ns.ldap.jndi.LDAPNamespaceImpl;
import com.novell.admin.ns.nds.ObjectACLFacade;
import com.novell.application.console.snapin.ObjectEntry;
import com.sun.jndi.ldap.BerEncoder;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;

public class NVDSPrivs {
    static ValueList[] getNVDSEffectivePrivileges(LDAPNamespaceImpl ns2, ObjectEntry obj, boolean allLegalAttrs, String[] attrs, String[] classes) throws SPIException {
        ValueList[] vc = new ValueList[]{};
        boolean boolMode = false;
        if (attrs == null) {
            attrs = new String[]{};
        }
        if (classes == null) {
            classes = new String[]{};
        }
        try {
            BerEncoder ber = new BerEncoder();
            ber.beginSeq(48);
            if (attrs.length == 0 && classes.length == 0) {
                ber.encodeBoolean(allLegalAttrs, 128);
                boolMode = true;
            } else {
                int i;
                ber.beginSeq(129);
                for (i = 0; i < attrs.length; ++i) {
                    if (attrs[i].equalsIgnoreCase("[All Attributes Rights]")) {
                        ber.encodeString("any", 128, true);
                        continue;
                    }
                    ber.encodeString(attrs[i], 128, true);
                }
                if (classes != null) {
                    for (i = 0; i < classes.length; ++i) {
                        ber.encodeString(classes[i], 129, true);
                    }
                }
                ber.endSeq();
            }
            ber.endSeq();
            byte[] getPrv = ber.getTrimmedBuf();
            LdapContext ctx = (LdapContext)ns2.getContext();
            Control[] ctrl = ctx.getRequestControls();
            Control[] newctrl = new Control[ctrl.length + 1];
            for (int i = 0; i < ctrl.length; ++i) {
                newctrl[i] = ctrl[i];
            }
            newctrl[ctrl.length] = new LDAPControl("2.16.840.1.113719.1.27.101.33", true, getPrv);
            LdapContext newctx = ctx.newInstance(newctrl);
            Attributes effAttrs = newctx.getAttributes(obj.getFullName(), new String[]{"effectivePrivileges"});
            newctx.close();
            Hashtable<?, ?> ht = ctx.getEnvironment();
            String trustee = (String)ht.get("java.naming.security.principal");
            Attribute effprivs = effAttrs.get("effectivePrivileges");
            SchemaDefinition schemaDef = ns2.getSchemaDefinition(obj);
            Syntax syn = schemaDef.getAttributeDefinition("acl").getSyntax();
            if (boolMode && !allLegalAttrs) {
                vc = new ValueList[1];
                try {
                    if (effprivs != null) {
                        for (int i = 0; i < effprivs.size(); ++i) {
                            String rawval = (String)effprivs.get(i);
                            ValueList vtmp = (ValueList)syn.createValueComponent(rawval);
                            ObjectACLFacade fac = (ObjectACLFacade)vtmp.createFacade();
                            if (fac.getNVDSModifier() != 1L) continue;
                            vc[0] = vtmp;
                            return vc;
                        }
                    }
                }
                catch (Exception i) {
                    // empty catch block
                }
                vc[0] = ObjectACLFacade.createValueList(0L, 1L, trustee, null, "baseObject", null, null, syn);
                return vc;
            }
            if (boolMode) {
                if (effprivs == null) {
                    return new ValueList[0];
                }
                int num = effprivs.size();
                ArrayList<ValueList> alist = new ArrayList<ValueList>(num);
                for (int i = 0; i < num; ++i) {
                    ValueList vtmp = (ValueList)syn.createValueComponent(effprivs.get(i));
                    ObjectACLFacade fac = (ObjectACLFacade)vtmp.createFacade();
                    if (fac.getNVDSModifier() != 0L) continue;
                    alist.add(vtmp);
                }
                return alist.toArray(new ValueList[0]);
            }
            if (effprivs == null) {
                return new ValueList[0];
            }
            int num = effprivs.size();
            ArrayList<ValueList> alist = new ArrayList<ValueList>(num);
            block9: for (int i = 0; i < num; ++i) {
                String className;
                String attrName;
                boolean found = false;
                ValueList vtmp = (ValueList)syn.createValueComponent(effprivs.get(i));
                ObjectACLFacade fac = (ObjectACLFacade)vtmp.createFacade();
                if (fac.getNVDSModifier() != 0L || (attrName = fac.getNVDSAttributeName()) == null) continue;
                for (int j = 0; j < attrs.length; ++j) {
                    if (!attrName.equalsIgnoreCase(attrs[j])) continue;
                    alist.add(vtmp);
                    found = true;
                    break;
                }
                if (found || (className = fac.getNVDSClassName()) == null) continue;
                for (int j = 0; j < classes.length; ++j) {
                    if (!className.equalsIgnoreCase(classes[j])) continue;
                    alist.add(vtmp);
                    continue block9;
                }
            }
            return alist.toArray(new ValueList[0]);
        }
        catch (Exception e) {
            throw ns2.resolveSPIException(e, "getNVDSEffectivePrivileges");
        }
    }
}

