/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.HexStrategy;
import com.novell.admin.ns.HexValue;
import com.novell.admin.ns.NSUtil;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSSyntax;

final class Integer64Strategy
extends HexStrategy {
    Integer64Strategy() {
    }

    public boolean canCreateValue(Object obj) {
        return obj instanceof byte[] || obj instanceof String;
    }

    public ValueComponent createValueComponent() {
        return new HexValue(this.getSyntax(), new byte[1]);
    }

    public ValueComponent createValueComponent(Object obj) throws ComponentCreationException {
        if (obj instanceof byte[]) {
            HexValue hexValue = new HexValue(this.getSyntax(), (byte[])obj);
            hexValue.setInteger64(true);
            return hexValue;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            byte[] f = NSUtil.hexStringToByteArray(str);
            return new HexValue(this.getSyntax(), f);
        }
        throw new ComponentCreationException();
    }

    public Syntax getSyntax() {
        return NDSSyntax.SYN_INTEGER_64;
    }
}

