/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.ns.MODObject;
import com.novell.admin.ns.MultiObjModificationCallBack;
import com.novell.admin.ns.MultiObjModificationNamespace;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NSObjectCache;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.ObjectACLFacade;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryCollection;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import java.util.Enumeration;
import java.util.Vector;

public final class MultiObjModificationNamespaceImpl
implements MultiObjModificationNamespace {
    private NDSNamespace namespace;
    private NSObjectCache nsObjectLookupTable;

    public MultiObjModificationNamespaceImpl(NDSNamespace namespace, NSObjectCache nsObjectLookupTable) {
        this.namespace = namespace;
        this.nsObjectLookupTable = nsObjectLookupTable;
    }

    public void updateMultipleObjects(ObjectEntryCollection collection, MODObject referenceObj, MultiObjModificationCallBack callBack) {
        String[] addedAttributes = referenceObj.getAddedAttributes();
        String[] modifiedAttributes = referenceObj.getModifiedAttributes();
        String[] deletedAttributes = referenceObj.getDeletedAttributes();
        ObjectEntryEnumeration myenum = collection.elements();
        while (myenum.hasMoreElements()) {
            try {
                ObjectEntry thisOE = (ObjectEntry)myenum.nextElement();
                if (callBack.update(thisOE) == 0) {
                    return;
                }
                NSObject nsObj = this.namespace.getDetails(thisOE);
                this.stuffNSObjectWithAttributeChanges(nsObj, referenceObj, addedAttributes);
                this.stuffNSObjectWithAttributeChanges(nsObj, referenceObj, modifiedAttributes);
                for (int j = 0; j < deletedAttributes.length; ++j) {
                    String attribName = deletedAttributes[j];
                    NDSObjectAttribute attrib = (NDSObjectAttribute)nsObj.getAttribute(attribName);
                    if (attrib == null) continue;
                    nsObj.deleteAttribute(attribName);
                }
                this.namespace.update(nsObj);
            }
            catch (Exception e) {
                if (callBack.handleException(e) != 0) continue;
                return;
            }
        }
    }

    public MODObject getMODDetails(ObjectEntryCollection oeCollection, Object key) {
        ObjectEntry oe = oeCollection.getFirstElement();
        MODObject obj = null;
        obj = (MODObject)this.nsObjectLookupTable.getDetails(key, oe);
        if (obj == null) {
            obj = new MODObject(oe);
            this.nsObjectLookupTable.setDetails(key, obj);
        }
        return obj;
    }

    private void stuffNSObjectWithAttributeChanges(NSObject nsObj, NSObject referenceObj, String[] attributes) throws NamespaceException {
        for (int j = 0; j < attributes.length; ++j) {
            String attribName = attributes[j];
            NDSObjectAttribute attrib = (NDSObjectAttribute)nsObj.getAttribute(attribName);
            NDSObjectAttribute referenceAttrib = (NDSObjectAttribute)referenceObj.getAttribute(attribName);
            if (attrib == null) {
                nsObj.addAttribute(referenceAttrib);
                continue;
            }
            if (nsObj.isNamedBy(attribName)) {
                this.modifyNamingAttrib(nsObj, referenceObj, attribName);
                continue;
            }
            if (attrib.getAttributeDefinition().isSingleValued() || this.behavesLikeSingleValued(attribName)) {
                NDSObjectAttribute attributeToMake = this.getAttributeDifferences(attrib, referenceAttrib);
                Enumeration values = attributeToMake.getValueComponents();
                if (!values.hasMoreElements()) continue;
                attrib.removeAllComponents();
                while (values.hasMoreElements()) {
                    attrib.addComponent((ValueComponent)values.nextElement());
                }
                continue;
            }
            if (attribName.equalsIgnoreCase("ACL")) {
                this.stuffACLValues(nsObj, referenceAttrib);
                continue;
            }
            this.appendValues(nsObj, referenceAttrib);
        }
    }

    private void stuffACLValues(NSObject obj, NDSObjectAttribute aclAttrib) throws NamespaceException {
        NDSObjectAttribute currentAttr = (NDSObjectAttribute)obj.getAttribute(aclAttrib.getName());
        Enumeration currentValueEnum = currentAttr.getValueComponents();
        Enumeration proposedValueEnum = aclAttrib.getValueComponents();
        while (proposedValueEnum.hasMoreElements()) {
            int valueCount;
            boolean valueReplaced = false;
            ValueList pValList = (ValueList)proposedValueEnum.nextElement();
            ObjectACLFacade proposedACLValue = (ObjectACLFacade)pValList.createFacade();
            ObjectACLFacade currentACLValue = null;
            currentValueEnum = currentAttr.getValueComponents();
            while (currentValueEnum.hasMoreElements()) {
                long currentRights;
                long proposedRights;
                ValueList cValList = (ValueList)currentValueEnum.nextElement();
                currentACLValue = (ObjectACLFacade)cValList.createFacade();
                if (!proposedACLValue.getProtectedAttrName().equalsIgnoreCase(currentACLValue.getProtectedAttrName()) || !proposedACLValue.getSubjectName().equalsIgnoreCase(currentACLValue.getSubjectName()) || (proposedRights = proposedACLValue.getPrivileges()) == (currentRights = currentACLValue.getPrivileges())) continue;
                if ((proposedRights & 0x40L) != 0L && (currentRights & 0x40L) != 0L) {
                    currentAttr.replaceComponent(cValList, pValList);
                    valueReplaced = true;
                    continue;
                }
                if ((proposedRights & 0x40L) != 0L || (currentRights & 0x40L) != 0L) continue;
                currentAttr.replaceComponent(cValList, pValList);
                valueReplaced = true;
            }
            if (valueReplaced || currentAttr.contains(pValList) || (valueCount = this.getACLSimilarValueCount(currentAttr, currentACLValue)) >= 2) continue;
            currentAttr.addComponent(pValList);
        }
    }

    private int getACLSimilarValueCount(NDSObjectAttribute attr, ObjectACLFacade aclFacade) {
        int count = 0;
        Enumeration attrValueEnum = attr.getValueComponents();
        while (attrValueEnum.hasMoreElements()) {
            ValueList valList = (ValueList)attrValueEnum.nextElement();
            ObjectACLFacade currentACLValue = (ObjectACLFacade)valList.createFacade();
            if (!currentACLValue.getProtectedAttrName().equalsIgnoreCase(aclFacade.getProtectedAttrName()) || !currentACLValue.getSubjectName().equalsIgnoreCase(aclFacade.getSubjectName())) continue;
            ++count;
        }
        return count;
    }

    private NDSObjectAttribute getAttributeDifferences(NDSObjectAttribute oldAttr, NDSObjectAttribute newAttr) {
        ValueComponent tempValComp;
        Vector<ValueComponent> addedValues = new Vector<ValueComponent>();
        Vector<ValueComponent> deletedValues = new Vector<ValueComponent>();
        Enumeration newValues = newAttr.getValueComponents();
        Enumeration oldValues = oldAttr.getValueComponents();
        NDSObjectAttribute differenceAttribute = null;
        while (newValues.hasMoreElements()) {
            tempValComp = (ValueComponent)newValues.nextElement();
            if (oldAttr.contains(tempValComp)) continue;
            addedValues.addElement(tempValComp);
        }
        Object[] valuesToAdd = new ValueComponent[addedValues.size()];
        addedValues.copyInto(valuesToAdd);
        while (oldValues.hasMoreElements()) {
            tempValComp = (ValueComponent)oldValues.nextElement();
            if (newAttr.contains(tempValComp)) continue;
            deletedValues.addElement(tempValComp);
        }
        Object[] valuesToDelete = new ValueComponent[deletedValues.size()];
        deletedValues.copyInto(valuesToDelete);
        try {
            differenceAttribute = new NDSObjectAttribute(oldAttr.getAttributeDefinition(), (ValueComponent[])valuesToDelete);
            for (int i = 0; i < valuesToDelete.length; ++i) {
                differenceAttribute.removeComponent((ValueComponent)valuesToDelete[i]);
            }
            differenceAttribute.addComponents((ValueComponent[])valuesToAdd);
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        return differenceAttribute;
    }

    private boolean behavesLikeSingleValued(String name) {
        boolean rval = false;
        if (name.equals("Description") || name.equals("Internet EMail Address") || name.equals("SA") || name.equals("S") || name.equals("Postal Office Box") || name.equals("Physical Delivery Office Name") || name.equals("Postal Code") || name.equals("Postal Address")) {
            rval = true;
        }
        return rval;
    }

    private void modifyNamingAttrib(NSObject nsObj, NSObject referenceObj, String attribName) {
        NDSObjectAttribute attrib = (NDSObjectAttribute)nsObj.getAttribute(attribName);
        NDSObjectAttribute referenceAttrib = (NDSObjectAttribute)referenceObj.getAttribute(attribName);
        String referenceName = referenceObj.getObjectEntry().getName();
        Enumeration valueSet = attrib.getValueComponents();
        Vector valueVector = new Vector();
        while (valueSet.hasMoreElements()) {
            valueVector.addElement(valueSet.nextElement());
        }
        Enumeration referenceValueSet = referenceAttrib.getValueComponents();
        while (referenceValueSet.hasMoreElements()) {
            ValueComponent vc = (ValueComponent)referenceValueSet.nextElement();
            if (referenceName.equalsIgnoreCase(vc.toString())) continue;
            try {
                attrib.addComponent(vc);
            }
            catch (NamespaceException namespaceException) {}
        }
    }

    private void appendValues(NSObject obj, NDSObjectAttribute attrib) throws NamespaceException {
        if (!attrib.getAttributeDefinition().isSingleValued()) {
            NDSObjectAttribute thisAttrib = (NDSObjectAttribute)obj.getAttribute(attrib.getName());
            Enumeration values = attrib.getValueComponents();
            while (values.hasMoreElements()) {
                thisAttrib.addComponent((ValueComponent)values.nextElement());
            }
        }
    }
}

