/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.ns.DefaultAttributeDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.nds.NDSAttributeFlags;
import com.novell.admin.ns.nds.NDSNamespaceException;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.NDSSyntax;

public class NDSAttributeDefinition
extends DefaultAttributeDefinition {
    private NDSAttributeFlags attrFlags;
    private byte[] asn1Data;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NDSAttributeDefinition(String attrName, NDSSyntax syntax, NDSAttributeFlags flags, long lBound, long uBound, byte[] asn1) throws NamespaceException {
        super(attrName, syntax, lBound, uBound);
        if (asn1 != null) {
            if (asn1.length != 32) {
                this.asn1Data = new byte[32];
                if (asn1.length > 32) {
                    for (int i = 0; i < 32; ++i) {
                        this.asn1Data[i] = asn1[i];
                    }
                } else {
                    for (int i = 0; i < asn1.length; ++i) {
                        this.asn1Data[i] = asn1[i];
                    }
                    for (int j = 0; j < 32 - asn1.length; ++j) {
                        this.asn1Data[i++] = 0;
                    }
                }
            } else {
                this.asn1Data = asn1;
            }
        } else {
            this.asn1Data = new byte[32];
            for (int i = 0; i < 32; ++i) {
                this.asn1Data[i] = 0;
            }
        }
        this.attrFlags = (NDSAttributeFlags)flags.clone();
        if (this.attrFlags.isFlagSet(2)) {
            if (!syntax.isSizable()) throw NDSNamespaceException.ATTRIBUTE_NOT_SIZEABLE;
            this.sized = true;
            return;
        } else {
            this.sized = false;
        }
    }

    public NDSAttributeDefinition(String attrName, int syntax, int flags, long lBound, long uBound, byte[] asn1) throws NamespaceException {
        this(attrName, (NDSSyntax)NDSSyntax.getSyntax(syntax), new NDSAttributeFlags(flags), lBound, uBound, asn1);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NDSAttributeDefinition) {
            NDSAttributeDefinition other = (NDSAttributeDefinition)obj;
            if (super.equals(obj) && this.attrFlags.equals(other.attrFlags)) {
                return true;
            }
        }
        return false;
    }

    public final boolean isSingleValued() {
        return this.attrFlags.isFlagSet(1);
    }

    public final boolean isHidden() {
        return this.attrFlags.isFlagSet(16);
    }

    public final boolean isReadOnly() {
        return this.attrFlags.isFlagSet(8);
    }

    public final NDSAttributeFlags getAttributeFlag() {
        return (NDSAttributeFlags)this.attrFlags.clone();
    }

    public final byte[] getASN1Data() {
        byte[] data = new byte[this.asn1Data.length];
        System.arraycopy(this.asn1Data, 0, data, 0, data.length);
        return data;
    }

    public void setASN1Data(byte[] modifiedASN1) {
        this.asn1Data = modifiedASN1;
    }

    public ObjectAttribute createAttribute() {
        NDSObjectAttribute attr = new NDSObjectAttribute(this);
        try {
            attr.addComponent(this.getSyntax().createValueComponent());
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        return attr;
    }

    public boolean isAberrant() {
        return this.name.equals("Object Class");
    }

    public boolean isOperational() {
        return (this.attrFlags.getFlags() & 0x1000) != 0;
    }
}

