/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.nds.AttrFlag;

public final class NDSAttributeFlags
implements Cloneable {
    public static final int SINGLE_VALUED = 1;
    public static final int SIZED = 2;
    public static final int NONREMOVABLE = 4;
    public static final int READ_ONLY = 8;
    public static final int HIDDEN = 16;
    public static final int STRING = 32;
    public static final int SYNC_IMMEDIATE = 64;
    public static final int PUBLIC_READ = 128;
    public static final int SERVER_READ = 256;
    public static final int WRITE_MANAGED = 512;
    public static final int PER_REPLICA = 1024;
    public static final int OPERATIONAL = 4096;
    public static final int INTEGER_64 = 262144;
    private static final int CLONE_NOT_SUPPORTED = 1;
    private int flags;
    private static final AttrFlag[] attrFlagTable = new AttrFlag[]{new AttrFlag(16, "Hidden"), new AttrFlag(4, "Non-removable"), new AttrFlag(1024, "Per replica"), new AttrFlag(128, "Public Read"), new AttrFlag(8, "Read-only"), new AttrFlag(256, "Server Read"), new AttrFlag(1, "Single valued"), new AttrFlag(2, "Sized"), new AttrFlag(32, "String"), new AttrFlag(64, "Synchronize"), new AttrFlag(512, "Write managed"), new AttrFlag(4096, "Operational"), new AttrFlag(262144, "Integer_64")};

    public NDSAttributeFlags(int flags) {
        this.flags = flags;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NDSAttributeFlags) {
            NDSAttributeFlags attrFlags = (NDSAttributeFlags)obj;
            return attrFlags.flags == this.flags;
        }
        return false;
    }

    public boolean isFlagSet(int flagId) {
        return 0 != (this.flags & flagId);
    }

    public void setFlag(int flagId) {
        this.flags |= flagId;
    }

    public void clearFlag(int flagId) {
        this.flags &= ~flagId;
    }

    public String[] getStrings(long upper, long lower) {
        int indx;
        int count = 0;
        for (indx = 0; indx < attrFlagTable.length; ++indx) {
            if (0 == (this.flags & NDSAttributeFlags.attrFlagTable[indx].flag)) continue;
            ++count;
        }
        String[] flagStrings = new String[count];
        count = 0;
        for (indx = 0; indx < attrFlagTable.length; ++indx) {
            if (0 == (this.flags & NDSAttributeFlags.attrFlagTable[indx].flag)) continue;
            flagStrings[count++] = 2 == NDSAttributeFlags.attrFlagTable[indx].flag ? new String(NDSAttributeFlags.attrFlagTable[indx].string + " (" + lower + ".." + upper + ")") : NDSAttributeFlags.attrFlagTable[indx].string;
        }
        return flagStrings;
    }

    public Object clone() {
        try {
            return (NDSAttributeFlags)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AdminError(1, this.getClass());
        }
    }
}

