/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.nds.ClassFlag;

public final class NDSClassFlags
implements Cloneable {
    public static final int CONTAINER_CLASS = 1;
    public static final int EFFECTIVE_CLASS = 2;
    public static final int NONREMOVABLE_CLASS = 4;
    public static final int AMBIGUOUS_NAMING = 8;
    public static final int AMBIGUOUS_CONTAINMENT = 16;
    public static final int AUXILIARY_CLASS = 32;
    public static final int AUXILARY_CLASS = 32;
    private static final int CLONE_NOT_SUPPORTED = 1;
    private int flags;
    private static final ClassFlag[] classFlagTable = new ClassFlag[]{new ClassFlag(1, "Container"), new ClassFlag(2, "Effective"), new ClassFlag(4, "Non-removable"), new ClassFlag(8, "Ambiguous Naming"), new ClassFlag(16, "Ambiguous Containment"), new ClassFlag(32, "Auxiliary")};

    public NDSClassFlags(int flags) {
        this.flags = flags;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isFlagSet(int flagId) {
        return 0 != (this.flags & flagId);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NDSClassFlags) {
            NDSClassFlags classFlags = (NDSClassFlags)obj;
            return classFlags.getFlags() == this.getFlags();
        }
        return false;
    }

    public Object clone() {
        try {
            return (NDSClassFlags)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AdminError(1, this.getClass());
        }
    }

    public String[] getStrings() {
        int indx;
        int count = 0;
        for (indx = 0; indx < classFlagTable.length; ++indx) {
            if (0 == (this.flags & NDSClassFlags.classFlagTable[indx].flag)) continue;
            ++count;
        }
        String[] flagStrings = new String[count];
        count = 0;
        for (indx = 0; indx < classFlagTable.length; ++indx) {
            if (0 == (this.flags & NDSClassFlags.classFlagTable[indx].flag)) continue;
            flagStrings[count++] = NDSClassFlags.classFlagTable[indx].string;
        }
        return flagStrings;
    }
}

