/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.ns.nds.NDSReplicaInfo;
import com.novell.admin.ns.nds.NDSReplicaType;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class NDSPartitionInfo {
    private String partitionFDN;
    private String servReadFDN;
    private String masterReplicaFDN;
    private Date lastSuccessfulSync;
    private Date lastAttemptSync;
    private int numReps = 0;
    private int numSubRefs = 0;
    private Vector repInfos;

    public NDSPartitionInfo(String partFDN, String srvReadFDN, String mstrRepFDN, Date lastSucSyncTime, Date lastAttSyncTime, Vector NDSRepInfos) {
        if (partFDN != null && srvReadFDN != null && mstrRepFDN != null && lastSucSyncTime != null && lastAttSyncTime != null && NDSRepInfos != null) {
            this.partitionFDN = partFDN;
            this.servReadFDN = srvReadFDN;
            this.masterReplicaFDN = mstrRepFDN;
            this.lastSuccessfulSync = lastSucSyncTime;
            this.lastAttemptSync = lastAttSyncTime;
            this.repInfos = NDSRepInfos;
            Enumeration e = NDSRepInfos.elements();
            while (e.hasMoreElements()) {
                NDSReplicaType rType = ((NDSReplicaInfo)e.nextElement()).getReplicaType();
                if (rType == NDSReplicaType.SUBREF) {
                    ++this.numSubRefs;
                    continue;
                }
                if (rType != NDSReplicaType.MASTER && rType != NDSReplicaType.RO && rType != NDSReplicaType.RW) continue;
                ++this.numReps;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public String getPartitionFDN() {
        return this.partitionFDN;
    }

    public String getServerReadFDN() {
        return this.servReadFDN;
    }

    public String getMasterReplicaFDN() {
        return this.masterReplicaFDN;
    }

    public int getNumOfReplicas() {
        return this.numReps;
    }

    public int getNumOfSubRefs() {
        return this.numSubRefs;
    }

    public Date getLastSuccessfulSyncTime() {
        return this.lastSuccessfulSync;
    }

    public Date getLastAttemptedSyncTime() {
        return this.lastAttemptSync;
    }

    public Vector getNDSReplicas() {
        return (Vector)this.repInfos.clone();
    }
}

