/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UnexpectedErrorException;
import com.novell.admin.ns.OperationStatus;
import com.novell.admin.ns.PartitionOperationCallBack;
import com.novell.admin.ns.nds.NDSPartitionService;
import com.novell.admin.ns.nds.OperationThreadStatus;
import com.novell.application.console.snapin.ObjectEntry;

public class NDSPartitionOperationStatus
implements OperationStatus {
    private NDSPartitionService partitionService;
    private ObjectEntry partObjEntry;
    private int st = 4;
    private Thread myOperationT;

    public NDSPartitionOperationStatus(ObjectEntry partObjEntry, NDSPartitionService partitionService, Thread operationT) {
        this.partitionService = partitionService;
        this.partObjEntry = partObjEntry;
        this.myOperationT = operationT;
        this.st = 3;
    }

    public void waitForOperation(int length, PartitionOperationCallBack cb) throws SPIException {
        boolean stopOperation = false;
        while (!stopOperation && this.myOperationT.isAlive()) {
            try {
                this.myOperationT.join(length);
                int action = cb.toDo();
                if (action == 0) {
                    this.partitionService.abortPartitionOperation(this.partObjEntry);
                    stopOperation = true;
                    this.st = 2;
                    continue;
                }
                if (action != 2) continue;
                stopOperation = true;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new UnexpectedErrorException();
            }
        }
        if (!this.myOperationT.isAlive()) {
            this.st = 3;
            this.getStatus();
            this.st = 1;
        }
        cb.toDo();
    }

    public void waitForOperation(int length) {
        if (this.myOperationT.isAlive()) {
            try {
                this.myOperationT.join(length);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new UnexpectedErrorException();
            }
        }
    }

    public int getStatus() throws SPIException {
        if (this.st == 3) {
            this.st = ((OperationThreadStatus)((Object)this.myOperationT)).operationStatus();
        }
        return this.st;
    }
}

