/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.HexValue;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.NSUtil;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;
import com.novell.admin.ns.nds.NDSSyntax;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;

public final class NetAddressFacade
extends ValueListFacade {
    public static final int IPX_ADDRESS_TYPE = 0;
    public static final int IP_ADDRESS_TYPE = 1;
    public static final int SDLC_ADDRESS_TYPE = 2;
    public static final int ET_ADDRESS_TYPE = 3;
    public static final int OSI_ADDRESS_TYPE = 4;
    public static final int APPLETALK_ADDRESS_TYPE = 5;
    public static final int UDP_ADDRESS_TYPE = 8;
    public static final int TCP_ADDRESS_TYPE = 9;
    public static final int UDP6_ADDRESS_TYPE = 10;
    public static final int TCP6_ADDRESS_TYPE = 11;
    public static final int URL_ADDRESS_TYPE = 13;
    private static final String IPX_TYPE = "IPX";
    private static final String IP_TYPE = "IP";
    private static final String SDLC_TYPE = "SDLC";
    private static final String ET_TYPE = "Ethernet/Tokenring";
    private static final String OSI_TYPE = "OSI";
    private static final String APPLETALK_TYPE = "Appletalk";
    private static final String UDP_TYPE = "UDP";
    private static final String TCP_TYPE = "TCP";
    private static final String URL_TYPE = "URL";
    private static final String UDP6_TYPE = "UDP6";
    private static final String TCP6_TYPE = "TCP6";
    private static final int ADDRESS_TYPE_INDEX = 0;
    private static final int ADDRESS_INDEX = 1;
    private static final int COMP_CREATE = 1;

    public NetAddressFacade(ValueList comp) throws IncompatibleComponentException {
        super(comp);
    }

    public static ValueList createValueList(long addrType, byte[] addr, Syntax syn) {
        try {
            Vector<Object> list = new Vector<Object>();
            list.addElement(new Long(addrType));
            list.addElement(addr);
            ValueList vc = (ValueList)syn.createValueComponent(list);
            return vc;
        }
        catch (ComponentCreationException e) {
            throw new AdminError(1, "com.novell.admin.ns.nds.NetAddressFacade");
        }
    }

    public static ValueList createValueList(long addrType, byte[] addr) {
        return NetAddressFacade.createValueList(addrType, addr, NDSSyntax.SYN_NET_ADDRESS);
    }

    public long getAddressType() {
        LongValue v = (LongValue)this.valueList.getElementAt(0);
        return v.getValue();
    }

    public byte[] getAddress() {
        HexValue v = (HexValue)this.valueList.getElementAt(1);
        return v.getValue();
    }

    public HexValue getHVAddress() {
        return (HexValue)this.valueList.getElementAt(1);
    }

    public void setAddressType(long type) {
        this.replaceLongValue(type, 0);
    }

    public void setAddress(byte[] addr) {
        this.replaceHexValue(addr, 1);
    }

    public String getAddressString() {
        int type = (int)this.getAddressType();
        switch (type) {
            case 0: {
                return this.ipxString();
            }
            case 1: {
                return this.ipString();
            }
            case 2: 
            case 3: {
                return this.seString();
            }
            case 4: 
            case 5: {
                return this.oaString();
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return this.tuString();
            }
            case 13: {
                return this.urlString();
            }
        }
        return this.valueList.toString();
    }

    private String ipxString() {
        String hexString = NSUtil.toHexString(this.getAddress());
        if (hexString.length() == 24) {
            String compositPlusDelimiters = IPX_TYPE;
            compositPlusDelimiters = compositPlusDelimiters.concat(": ");
            compositPlusDelimiters = compositPlusDelimiters.concat(hexString.substring(0, 8));
            compositPlusDelimiters = compositPlusDelimiters.concat(":");
            compositPlusDelimiters = compositPlusDelimiters.concat(hexString.substring(8, 20));
            compositPlusDelimiters = compositPlusDelimiters.concat(":");
            compositPlusDelimiters = compositPlusDelimiters.concat(hexString.substring(20, 24));
            return compositPlusDelimiters;
        }
        String composit = IPX_TYPE;
        composit = composit.concat(": ");
        composit = composit.concat(hexString);
        return composit;
    }

    private String ipString() {
        byte[] address = this.getAddress();
        if (address.length == 4) {
            int offset = 0;
            String compositPlusDelimiters = IP_TYPE;
            compositPlusDelimiters = compositPlusDelimiters.concat(": ");
            compositPlusDelimiters = compositPlusDelimiters.concat(String.valueOf(NSUtil.byteToDecimal(address[offset++])));
            compositPlusDelimiters = compositPlusDelimiters.concat(".");
            compositPlusDelimiters = compositPlusDelimiters.concat(String.valueOf(NSUtil.byteToDecimal(address[offset++])));
            compositPlusDelimiters = compositPlusDelimiters.concat(".");
            compositPlusDelimiters = compositPlusDelimiters.concat(String.valueOf(NSUtil.byteToDecimal(address[offset++])));
            compositPlusDelimiters = compositPlusDelimiters.concat(".");
            compositPlusDelimiters = compositPlusDelimiters.concat(String.valueOf(NSUtil.byteToDecimal(address[offset])));
            return compositPlusDelimiters;
        }
        if (address.length == 16) {
            byte[] ip6 = null;
            String compositPlusDelimiters = IP_TYPE;
            compositPlusDelimiters = compositPlusDelimiters.concat(": ");
            ip6 = new byte[]{address[0], address[1], address[2], address[3], address[4], address[5], address[6], address[7], address[8], address[9], address[10], address[11], address[12], address[13], address[14], address[15]};
            try {
                compositPlusDelimiters = compositPlusDelimiters.concat("[" + InetAddress.getByAddress(ip6).getHostAddress() + "]");
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            return compositPlusDelimiters;
        }
        String composit = IP_TYPE;
        composit = composit.concat(": ");
        composit = composit.concat(NSUtil.toHexString(this.getAddress()));
        return composit;
    }

    private String seString() {
        String hexString = NSUtil.toHexString(this.getAddress());
        if (hexString.length() == 20) {
            String compositPlusDelimiters = this.getAddressType() == 2L ? SDLC_TYPE : ET_TYPE;
            compositPlusDelimiters = compositPlusDelimiters.concat(": ");
            compositPlusDelimiters = compositPlusDelimiters.concat(hexString.substring(0, 4));
            compositPlusDelimiters = compositPlusDelimiters.concat(":");
            compositPlusDelimiters = compositPlusDelimiters.concat(hexString.substring(4, 10));
            compositPlusDelimiters = compositPlusDelimiters.concat(":");
            compositPlusDelimiters = compositPlusDelimiters.concat(hexString.substring(10, 20));
            return compositPlusDelimiters;
        }
        String composit = this.getAddressType() == 2L ? SDLC_TYPE : ET_TYPE;
        composit = composit.concat(": ");
        composit = composit.concat(hexString);
        return composit;
    }

    private String oaString() {
        String composit = this.getAddressType() == 4L ? OSI_TYPE : APPLETALK_TYPE;
        composit = composit.concat(": ");
        composit = composit.concat(NSUtil.toHexString(this.getAddress()));
        return composit;
    }

    private String urlString() {
        String composit;
        int i;
        int index = 0;
        byte[] address = this.getAddress();
        byte[] temp = new byte[address.length];
        for (i = 0; i < address.length; ++i) {
            if (address[i] == 0) continue;
            temp[index++] = address[i];
        }
        address = new byte[index];
        for (i = 0; i < index; ++i) {
            address[i] = temp[i];
        }
        try {
            composit = new String(address, "Cp1252");
        }
        catch (UnsupportedEncodingException e) {
            composit = URL_TYPE;
            composit = composit.concat(": ");
        }
        return composit;
    }

    private String tuString() {
        byte[] address = this.getAddress();
        if (address.length == 6 || address.length == 4) {
            int offset = 0;
            String compositPlusDelimiters = this.getAddressType() == 8L ? UDP_TYPE : TCP_TYPE;
            compositPlusDelimiters = compositPlusDelimiters.concat(": ");
            if (address.length == 6) {
                ++offset;
            }
            int n = ++offset;
            compositPlusDelimiters = compositPlusDelimiters.concat(String.valueOf(NSUtil.byteToDecimal(address[n])));
            compositPlusDelimiters = compositPlusDelimiters.concat(".");
            int n2 = ++offset;
            compositPlusDelimiters = compositPlusDelimiters.concat(String.valueOf(NSUtil.byteToDecimal(address[n2])));
            compositPlusDelimiters = compositPlusDelimiters.concat(".");
            int n3 = ++offset;
            compositPlusDelimiters = compositPlusDelimiters.concat(String.valueOf(NSUtil.byteToDecimal(address[n3])));
            compositPlusDelimiters = compositPlusDelimiters.concat(".");
            compositPlusDelimiters = compositPlusDelimiters.concat(String.valueOf(NSUtil.byteToDecimal(address[++offset])));
            return compositPlusDelimiters;
        }
        if (address.length == 16 || address.length == 18) {
            byte[] ip6 = null;
            String compositPlusDelimiter = this.getAddressType() == 10L ? UDP6_TYPE : TCP6_TYPE;
            compositPlusDelimiter = compositPlusDelimiter.concat(": ");
            if (address.length == 18) {
                ip6 = new byte[]{address[2], address[3], address[4], address[5], address[6], address[7], address[8], address[9], address[10], address[11], address[12], address[13], address[14], address[15], address[16], address[17]};
            }
            try {
                compositPlusDelimiter = compositPlusDelimiter.concat("[" + InetAddress.getByAddress(ip6).getHostAddress() + "]");
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            return compositPlusDelimiter;
        }
        String composit = this.getAddressType() == 8L ? UDP_TYPE : (this.getAddressType() == 9L ? TCP_TYPE : (this.getAddressType() == 10L ? UDP6_TYPE : TCP6_TYPE));
        composit = composit.concat(": ");
        composit = composit.concat(NSUtil.toHexString(this.getAddress()));
        return composit;
    }
}

