/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.HexValue;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;
import com.novell.admin.ns.nds.NDSSyntax;
import java.util.Vector;

public final class OctetListFacade
extends ValueListFacade {
    private static final int COMP_CREATE = 1;
    private static final int ADD_OCTET_1 = 2;
    private static final int ADD_OCTET_2 = 3;
    private static final int REMOVE_OCTET = 4;

    public OctetListFacade(ValueList comp) throws IncompatibleComponentException {
        super(comp);
    }

    public static ValueList createValueList(byte[][] octets, Syntax syn) {
        Vector<byte[]> octetVector = new Vector<byte[]>();
        for (int i = 0; i < octets.length; ++i) {
            octetVector.addElement(octets[i]);
        }
        try {
            ValueComponent vc = syn.createValueComponent(octetVector);
            return (ValueList)vc;
        }
        catch (ComponentCreationException e) {
            throw new AdminError(1, "com.novell.admin.ns.nds.OctetListFacade");
        }
    }

    public static ValueList createValueList(byte[][] octets) {
        return OctetListFacade.createValueList(octets, NDSSyntax.SYN_OCTET_LIST);
    }

    public byte[][] getOctets() {
        int count = this.valueList.getComponentCount();
        byte[][] octetArray = new byte[count][];
        for (int i = 0; i < count; ++i) {
            HexValue v = (HexValue)this.valueList.getElementAt(i);
            octetArray[i] = v.getValue();
        }
        return octetArray;
    }

    public byte[] getOctet(int index) throws ArrayIndexOutOfBoundsException {
        HexValue v = (HexValue)this.valueList.getElementAt(index);
        return v.getValue();
    }

    public void setOctet(byte[] newOctet, int index) throws ArrayIndexOutOfBoundsException {
        this.replaceHexValue(newOctet, index);
    }

    public void addOctet(byte[] octet) {
        try {
            Syntax syn = this.valueList.getElementAt(0).getSyntax();
            ValueComponent vc = syn.createValueComponent(octet);
            if (!this.valueList.insertComponent(vc)) {
                throw new AdminError(2, this.getClass());
            }
        }
        catch (ComponentCreationException e) {
            throw new AdminError(3, this.getClass());
        }
    }

    public void removeOctet(int index) throws ArrayIndexOutOfBoundsException {
        if (!this.valueList.removeComponentAt(index)) {
            throw new AdminError(4, this.getClass());
        }
    }

    public void replaceOctet(byte[] octet, int index) throws ArrayIndexOutOfBoundsException {
        this.replaceHexValue(octet, index);
    }
}

