/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.NetAddressFacade;
import java.util.Vector;

public final class ReplicaPointerFacade
extends ValueListFacade {
    private static final int COMP_CREATE = 1;
    private static final int SERVER_NAME_INDEX = 0;
    private static final int REPLICA_TYPE_INDEX = 1;
    private static final int REPLICA_NUMBER_INDEX = 2;
    private static final int REPLICA_COUNT_INDEX = 3;
    private static final int HINT_INDEX = 4;

    public ReplicaPointerFacade(ValueList comp) throws IncompatibleComponentException {
        super(comp);
    }

    public static ValueList createValueList(String serverName, int repType, int repNum, int count, NetAddressFacade netAddr, Syntax syn) {
        Vector<Object> list = new Vector<Object>();
        list.addElement(serverName);
        list.addElement(new Integer(repType));
        list.addElement(new Integer(repNum));
        list.addElement(new Integer(count));
        list.addElement(netAddr.getValueList());
        try {
            ValueComponent vc = syn.createValueComponent(list);
            return (ValueList)vc;
        }
        catch (ComponentCreationException ex) {
            throw new AdminError(1, "com.novell.admin.ns.nds.ReplicaPointerFacade");
        }
    }

    public static ValueList createValueList(String serverName, int repType, int repNum, int count, NetAddressFacade netAddr) {
        return ReplicaPointerFacade.createValueList(serverName, repType, repNum, count, netAddr, NDSSyntax.SYN_REPLICA_POINTER);
    }

    public String getServerName() {
        StringValue v = (StringValue)this.valueList.getElementAt(0);
        return v.getValue();
    }

    public long getReplicaType() {
        LongValue v = (LongValue)this.valueList.getElementAt(1);
        return v.getValue();
    }

    public long getReplicaNumber() {
        LongValue v = (LongValue)this.valueList.getElementAt(2);
        return v.getValue();
    }

    public long getReplicaCount() {
        LongValue v = (LongValue)this.valueList.getElementAt(3);
        return v.getValue();
    }

    public NetAddressFacade getNetworkAddressHint() {
        ValueList v = (ValueList)this.valueList.getElementAt(4);
        return (NetAddressFacade)v.createFacade();
    }

    public void setServerName(String name) {
        this.replaceStringValue(name, 0);
    }

    public void setReplicaType(int type) {
        this.replaceLongValue(type, 1);
    }

    public void setReplicaNumber(int number) {
        this.replaceLongValue(number, 2);
    }

    public void setReplicaCount(int count) {
        this.replaceLongValue(count, 3);
    }

    public void setNetworkAddressHint(NetAddressFacade hint) {
        this.replaceValueList(hint.getValueList(), 4);
    }
}

