/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.DateValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSSyntax;

final class TimeStrategy
extends com.novell.admin.ns.TimeStrategy {
    TimeStrategy() {
    }

    public ValueComponent createValueComponent(Object obj) throws ComponentCreationException {
        if (obj instanceof Number) {
            long v = ((Number)obj).longValue();
            return super.createValueComponent(new Long(v * 1000L));
        }
        return super.createValueComponent(obj);
    }

    public Syntax getSyntax() {
        return NDSSyntax.SYN_TIME;
    }

    public boolean isWithinBounds(ValueComponent comp, long lowerBound, long upperBound) {
        if (comp instanceof DateValue) {
            DateValue val = (DateValue)comp;
            long i = val.getMillis() / 1000L;
            return i >= lowerBound && i <= upperBound;
        }
        throw new AdminError(3, this.getClass());
    }
}

