/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds.jclient;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.SimpleSPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.nds.ObjectFlags;
import com.novell.admin.ns.nds.jclient.FloatingCache;
import com.novell.admin.ns.nds.jclient.JClientChildFilterImpl;
import com.novell.admin.ns.nds.jclient.NDSNamespaceImpl;
import com.novell.application.console.snapin.BrowserObjectEntryEnumeration;
import com.novell.application.console.snapin.CountableObjectEntryEnumeration;
import com.novell.application.console.snapin.Debug;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.SnapinException;
import java.util.NoSuchElementException;
import java.util.Vector;
import novell.jclient.JCClassnameValue;
import novell.jclient.JCContext;
import novell.jclient.JCEntryData;
import novell.jclient.JCEntryInfo;
import novell.jclient.JCEntryInfoEmptyFieldException;
import novell.jclient.JCEntryIterator;
import novell.jclient.JCEntryIteratorSortKey;
import novell.jclient.JCException;
import novell.jclient.JCReadFilter;
import novell.jclient.JCSearchExp;
import novell.jclient.JCSearchFilter;
import novell.jclient.JCTimestamp;
import novell.jclient.JCValue;
import novell.jclient.JClient;

public class BrowserObjectEntryEnumerationImpl
implements BrowserObjectEntryEnumeration,
CountableObjectEntryEnumeration {
    protected JCEntryIterator iterator;
    protected boolean needToGetCurrentObject = true;
    protected boolean iteratorAtEnd = true;
    protected ObjectEntry parent;
    protected NDSNamespaceImpl namespace;
    protected boolean subtree;
    protected boolean allowFileSystem = false;
    protected boolean allowFS_Volume = false;
    protected boolean allowFS_NCPServer = false;
    protected int desiredIndex = 0;
    private static final int DEFAULT_BLOCK_SIZE = 20;
    protected int cacheSize = 100;
    private int blockSize = 20;
    protected int entryTwoFifthsSlice = 40;
    protected int entryThreeFifthsSlice = 60;
    private static final int INVALID_PARAMETERS = 1;
    protected FloatingCache childOECache;
    private UniqueSPIException uniqueSPIException = new UniqueSPIException("com.novell.admin.common.exceptions.NSIClientResourceBundle");
    private SimpleSPIException spiException = new SimpleSPIException("com.novell.admin.ns.NSResourceBundle");

    public BrowserObjectEntryEnumerationImpl(ObjectEntry parent, ResultModifier modifier) throws SPIException, JCException {
        this.namespace = (NDSNamespaceImpl)parent.getObjectType().getNamespace();
        this.parent = parent;
        if (modifier != null) {
            this.subtree = modifier.isSubContainerSearch();
            int allowFSFlag = modifier.getAllowFileSystemBrowse();
            if (allowFSFlag != 0) {
                this.allowFileSystem = true;
                this.allowFS_Volume = (allowFSFlag & 1) == 1;
                this.allowFS_NCPServer = (allowFSFlag & 2) == 2;
            }
        } else {
            this.subtree = false;
            this.allowFileSystem = false;
        }
        try {
            JCSearchFilter searchFilter = new JClientChildFilterImpl(modifier, this.namespace, parent).getFilter();
            if (searchFilter == null) {
                int searchLevel;
                long entryInfoFlags = 6156L;
                if (this.subtree) {
                    searchLevel = 2;
                } else {
                    searchLevel = 1;
                    entryInfoFlags |= 0x8000L;
                }
                JCSearchExp searchExpression = new JCSearchExp((JCValue)new JCClassnameValue("", 17, 0L, new JCTimestamp(), "*"));
                searchFilter = new JCSearchFilter((long)searchLevel, 0L, 2L, -1L, entryInfoFlags, 1L, new JCReadFilter(false, null, ""), searchExpression);
            }
            JCContext ctx = null;
            try {
                ctx = this.namespace.getContext(parent, 66);
                JCEntryIteratorSortKey iterSortKey = new JCEntryIteratorSortKey();
                iterSortKey.addKey(17);
                this.iterator = ctx.createIterator(searchFilter, iterSortKey);
            }
            catch (JCException e) {
                throw this.namespace.resolveSPIException((Exception)((Object)e), "");
            }
            finally {
                if (ctx != null) {
                    ctx.free();
                }
            }
            this.childOECache = new FloatingCache(new Object[0], 0, 0);
            this.getNextElementsFromWireAndCache(this.cacheSize, false);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    BrowserObjectEntryEnumerationImpl(BrowserObjectEntryEnumerationImpl bEnumeration) {
        this.iterator = bEnumeration.iterator;
        this.needToGetCurrentObject = bEnumeration.needToGetCurrentObject;
        this.iteratorAtEnd = bEnumeration.iteratorAtEnd;
        this.parent = bEnumeration.parent;
        this.namespace = bEnumeration.namespace;
        this.subtree = bEnumeration.subtree;
        this.desiredIndex = bEnumeration.desiredIndex;
        this.cacheSize = bEnumeration.cacheSize;
        this.blockSize = bEnumeration.blockSize;
        this.entryTwoFifthsSlice = bEnumeration.entryTwoFifthsSlice;
        this.entryThreeFifthsSlice = bEnumeration.entryThreeFifthsSlice;
        this.childOECache = bEnumeration.childOECache;
        this.uniqueSPIException = bEnumeration.uniqueSPIException;
        this.spiException = bEnumeration.spiException;
    }

    public int getCount() throws SnapinException {
        int count = this.parent.getSubordinateCount();
        if (count >= 0) {
            return count;
        }
        JCContext ctx = null;
        try {
            ctx = this.namespace.getContext(this.parent, 66);
            JCEntryInfo entryInfo = JClient.getEntryInfo((JCContext)ctx, (int)8);
            count = entryInfo.getSubordinateCount();
            this.parent.setSubordinateCount(count);
        }
        catch (JCException x) {
            throw this.resolveSPIException((Exception)((Object)x));
        }
        catch (JCEntryInfoEmptyFieldException x) {
            throw this.resolveSPIException((Exception)((Object)x));
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
        return count;
    }

    public int getCountReliability() {
        return 2;
    }

    public boolean hasMoreElements() {
        boolean hasMore = true;
        if (!this.childOECache.isContained(this.desiredIndex)) {
            try {
                if (!this.iteratorAtEnd) {
                    this.iterator.skip((long)this.childOECache.getSize(), 0);
                    this.iteratorAtEnd = true;
                }
                hasMore = this.iteratorHasNext();
            }
            catch (JCException x) {
                hasMore = false;
            }
        }
        return hasMore;
    }

    public Object nextElement() throws NoSuchElementException {
        ObjectEntry[] entries;
        try {
            entries = this.getNextElements(1, false);
        }
        catch (JCException x) {
            throw new NoSuchElementException();
        }
        return entries[0];
    }

    public ObjectEntry next() {
        ObjectEntry[] entries;
        try {
            entries = this.getNextElements(1, false);
        }
        catch (JCException x) {
            return null;
        }
        return entries[0];
    }

    public int moveFirst() throws SnapinException {
        return this.moveTo(0);
    }

    public int moveLast() throws SnapinException {
        return this.moveTo(1000);
    }

    protected int moveTo(int position) throws SnapinException {
        if (position != 0 && position != 1000) {
            throw new AdminError(1, this.getClass());
        }
        try {
            this.iterator.setPosition(position, 0);
            this.needToGetCurrentObject = true;
            this.desiredIndex = 0;
            this.iteratorAtEnd = true;
            this.centerCacheAroundPosition(position);
        }
        catch (JCException x) {
            throw this.resolveSPIException((Exception)((Object)x));
        }
        return position;
    }

    public int moveTo(String target) throws SnapinException {
        try {
            this.iterator.setPosition("CN", target, 0);
            this.needToGetCurrentObject = true;
            this.desiredIndex = 0;
            this.iteratorAtEnd = true;
            this.centerCacheAroundPosition(0);
        }
        catch (JCException x) {
            throw this.resolveSPIException((Exception)((Object)x));
        }
        return 1;
    }

    public ObjectEntry previous() throws SnapinException {
        ObjectEntry[] entries;
        try {
            entries = this.getNextElements(1, true);
        }
        catch (JCException x) {
            return null;
        }
        return entries[0];
    }

    public void refresh() {
        try {
            this.moveFirst();
        }
        catch (SnapinException snapinException) {
            // empty catch block
        }
    }

    public void setBlockSize(int requestedBlockSize) {
        this.blockSize = Math.max(20, requestedBlockSize);
        this.cacheSize = 5 * this.blockSize;
        this.entryTwoFifthsSlice = 2 * this.blockSize;
        this.entryThreeFifthsSlice = 3 * this.blockSize;
    }

    public void close() {
        this.finalize();
    }

    protected void finalize() {
        this.iterator.close();
    }

    int getCacheCount() {
        return this.childOECache.getSize();
    }

    boolean isPositionable() {
        return this.iterator.isPositionable();
    }

    boolean isScalable() {
        return this.iterator.isScalable();
    }

    private void centerCacheAroundPosition(int newPosition) throws JCException {
        this.childOECache.reset(new Object[0], 0, 0);
        if (newPosition == 0) {
            try {
                this.getNextElementsFromWireAndCache(this.cacheSize, false);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.desiredIndex = this.childOECache.getFirstIndex();
        } else {
            try {
                this.iterator.skip((long)(1 - this.cacheSize), 0);
                this.getNextElementsFromWireAndCache(this.cacheSize, false);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.desiredIndex = this.childOECache.getLastIndex();
        }
    }

    protected ObjectEntry[] getNextElements(int numberOfElements, boolean reverse) throws NoSuchElementException, JCException {
        Object[] entries = null;
        Vector<Object> entryVec = new Vector<Object>(numberOfElements);
        if (reverse) {
            int startIndex = this.desiredIndex - numberOfElements;
            FloatingCache.FloatingCacheIterator floatItr = this.childOECache.getObjects(startIndex, numberOfElements);
            while (floatItr.hasMoreElements()) {
                entryVec.addElement(floatItr.nextElement());
            }
            if (floatItr.getCount() < numberOfElements) {
                try {
                    int numberOfEntriesToRead = Math.max(this.entryThreeFifthsSlice, numberOfElements - floatItr.getCount());
                    entries = this.getNextElementsFromWireAndCache(numberOfEntriesToRead, true);
                }
                catch (NoSuchElementException numberOfEntriesToRead) {
                    // empty catch block
                }
            }
            if (entries != null) {
                int numberOfItemsToLoop = Math.min(numberOfElements - floatItr.getCount(), entries.length);
                for (int i = 0; i < numberOfItemsToLoop; ++i) {
                    entryVec.insertElementAt(entries[i], 0);
                }
            }
            this.desiredIndex -= entryVec.size();
        } else {
            int startIndex = this.desiredIndex;
            FloatingCache.FloatingCacheIterator floatItr = this.childOECache.getObjects(startIndex, numberOfElements);
            while (floatItr.hasMoreElements()) {
                entryVec.addElement(floatItr.nextElement());
            }
            if (floatItr.getCount() < numberOfElements) {
                try {
                    int numberOfEntriesToRead = Math.max(this.entryThreeFifthsSlice, numberOfElements - floatItr.getCount());
                    entries = this.getNextElementsFromWireAndCache(numberOfEntriesToRead, false);
                }
                catch (NoSuchElementException numberOfEntriesToRead) {
                    // empty catch block
                }
            }
            if (entries != null) {
                int numberOfItemsToLoop = Math.min(numberOfElements - floatItr.getCount(), entries.length);
                for (int i = 0; i < numberOfItemsToLoop; ++i) {
                    entryVec.addElement(entries[i]);
                }
            }
            this.desiredIndex += entryVec.size();
        }
        entries = new ObjectEntry[entryVec.size()];
        entryVec.copyInto(entries);
        if (entries == null || entries.length == 0) {
            throw new NoSuchElementException();
        }
        return entries;
    }

    protected synchronized ObjectEntry[] getNextElementsFromWireAndCache(int numberOfElements, boolean reverse) throws NoSuchElementException, JCException {
        JCEntryData[] entryArray;
        Object[] entries = null;
        if (reverse) {
            if (this.iteratorAtEnd) {
                this.iterator.skip((long)(0 - this.childOECache.getSize()), 0);
            }
            this.iteratorAtEnd = false;
            entryArray = this.iterator.previous(numberOfElements, 0);
            this.needToGetCurrentObject = true;
        } else {
            if (!this.iteratorAtEnd) {
                this.iterator.skip((long)this.childOECache.getSize(), 0);
            }
            this.iteratorAtEnd = true;
            if (this.needToGetCurrentObject) {
                entryArray = this.iteratorGetNext(numberOfElements);
                this.needToGetCurrentObject = false;
            } else {
                entryArray = this.iterator.next(numberOfElements, 0);
            }
        }
        entries = this.crackTheEntries(entryArray);
        if (entries.length == 0) {
            throw new NoSuchElementException();
        }
        if (reverse) {
            this.childOECache.prepend(entries, 0, 0);
        } else if (this.childOECache.getSize() != 0) {
            this.childOECache.append(entries, 0, 0);
        } else {
            this.childOECache.reset(entries, 0, 0);
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectEntry[] crackTheEntries(JCEntryData[] entryArray) {
        String oldParentDN = "";
        String treeName = this.parent.getRoot().getName();
        ObjectEntry oldParentOE = null;
        ObjectEntry[] entries = new ObjectEntry[entryArray.length];
        for (int i = 0; i < entryArray.length; ++i) {
            ObjectType ot = null;
            try {
                ObjectEntry parentOE;
                String childName = entryArray[i].entryInfo.getEntryRDN().toString();
                String baseClass = entryArray[i].entryInfo.getBaseClass();
                int flags = entryArray[i].entryInfo.getEntryFlags();
                int count = entryArray[i].entryInfo.getSubordinateCount();
                if (this.allowFileSystem) {
                    if (this.allowFS_Volume && baseClass.equalsIgnoreCase("Volume")) {
                        flags |= 4;
                    }
                    if (this.allowFS_NCPServer && baseClass.equalsIgnoreCase("NCP Server")) {
                        flags |= 4;
                    }
                }
                if (this.subtree) {
                    String parentDN = entryArray[i].entryInfo.getParentDN().toString();
                    if (parentDN.equals(oldParentDN)) {
                        parentOE = oldParentOE;
                    } else {
                        parentOE = treeName.charAt(0) == '.' ? this.namespace.getObjectEntry(parentDN + treeName) : this.namespace.getObjectEntry(parentDN + "." + treeName);
                        oldParentOE = parentOE;
                        oldParentDN = parentDN;
                    }
                } else {
                    parentOE = this.parent;
                }
                if (baseClass.equals("Alias")) {
                    String parentDN = this.namespace.getUnrootedName(parentOE);
                    String childString = parentDN.equals("") ? childName : childName + "." + parentDN;
                    JCContext childCtx = null;
                    try {
                        childCtx = this.namespace.getContext(treeName, childString, 66);
                        JCEntryInfo aliasInfo = JClient.getEntryInfo((JCContext)childCtx, (int)131072);
                        baseClass = aliasInfo.getDereferencedBaseClass();
                    }
                    finally {
                        if (childCtx != null) {
                            childCtx.free();
                        }
                    }
                    if (ObjectFlags.isContainer(flags)) {
                        ot = this.namespace.getObjectType(parentOE, baseClass);
                        ot = new ObjectType(ot.getName(), ot.getNamespace(), true, ot.getParentTypes());
                    }
                }
                if (ot == null) {
                    ot = this.namespace.getObjectType(parentOE, baseClass);
                }
                entries[i] = new ObjectEntry(childName, ot, parentOE, flags, true);
                if (count < 0) continue;
                entries[i].setSubordinateCount(count);
                continue;
            }
            catch (JCException jCException) {
                continue;
            }
            catch (JCEntryInfoEmptyFieldException jCEntryInfoEmptyFieldException) {
                continue;
            }
            catch (SPIException sPIException) {
                // empty catch block
            }
        }
        return entries;
    }

    protected JCEntryData[] iteratorGetNext(int numberOfElements) throws JCException {
        JCEntryData dat = this.iterator.current();
        JCEntryData[] entryArray = this.iterator.next(numberOfElements - 1, 0);
        if (dat != null) {
            JCEntryData[] entryArray2 = new JCEntryData[entryArray.length + 1];
            entryArray2[0] = dat;
            for (int i = 0; i < entryArray.length; ++i) {
                entryArray2[i + 1] = entryArray[i];
            }
            entryArray = entryArray2;
        }
        return entryArray;
    }

    private boolean iteratorHasNext() {
        try {
            if (this.iterator.count(2L, 0) >= 2L) {
                return true;
            }
        }
        catch (JCException x) {
            Debug.out("Iterator exception: " + x.getMessage());
        }
        return false;
    }

    protected SPIException resolveSPIException(Exception x) {
        SPIException exception = null;
        if (x instanceof JCException) {
            exception = this.uniqueSPIException.newException(((JCException)((Object)x)).getErrorCode(), "", x);
        } else if (x instanceof SPIException) {
            exception = (SPIException)x;
        }
        if (exception == null) {
            exception = this.spiException.newException(x);
        }
        return exception;
    }
}

