/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds.jclient;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.SimpleSPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.OEComparator;
import com.novell.admin.ns.nds.ObjectFlags;
import com.novell.admin.ns.nds.jclient.JClientChildFilterImpl;
import com.novell.admin.ns.nds.jclient.NDSNamespaceImpl;
import com.novell.application.console.snapin.CountableObjectEntryEnumeration;
import com.novell.application.console.snapin.Debug;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.ResultModifierFilterEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import novell.jclient.JCContext;
import novell.jclient.JCEntryInfo;
import novell.jclient.JCEntryInfoCB;
import novell.jclient.JCEntryInfoEmptyFieldException;
import novell.jclient.JCException;
import novell.jclient.JCListEnumerator;
import novell.jclient.JCListFilter;
import novell.jclient.JCReadCB;
import novell.jclient.JCSearchContextCB;
import novell.jclient.JCSearchFilter;
import novell.jclient.JCTimestamp;
import novell.jclient.JCValue;
import novell.jclient.JClient;

final class ChildObjectEntryEnumerationImpl
implements ObjectEntryEnumeration,
CountableObjectEntryEnumeration {
    private ObjectEntry parentEntry;
    private NDSNamespaceImpl namespace;
    private boolean subtree;
    private ArrayList childResultArrList;
    private Iterator childIter;
    private int internalCountReliability = 5;
    private int internalCrackedCount = 0;
    private int eiInvokedCount = 0;
    private static long count = 0L;
    private int containereiInvokedCnt = 0;
    private static boolean firsttime = true;
    private static long freeinitial;
    private static long freeinitial1;
    private static final int MAX_ITEMS_TO_RETURN = 14000;
    private UniqueSPIException uniqueSPIException = new UniqueSPIException("com.novell.admin.common.exceptions.NSIClientResourceBundle");
    private SimpleSPIException spiException = new SimpleSPIException("com.novell.admin.ns.NSResourceBundle");

    public ChildObjectEntryEnumerationImpl(ObjectEntry parent, ResultModifier modifier, boolean childContainersOnly) throws SPIException {
        this.parentEntry = parent;
        Iterator tmpJCValIter = null;
        JCListEnumerator tmpJCValEnum = null;
        firsttime = true;
        this.subtree = modifier != null ? modifier.isSubContainerSearch() : false;
        this.namespace = (NDSNamespaceImpl)parent.getObjectType().getNamespace();
        JCContext ctx = null;
        try {
            ctx = this.namespace.getContext(parent, 66);
            if (childContainersOnly) {
                JCListFilter filter = new JCListFilter(false, true, false, false, new String(""), new String(""), new JCTimestamp());
                try {
                    JClient.listToCB((JCContext)ctx, (JCListFilter)filter, (int)6156, (JCEntryInfoCB)new ContainerOnlyEntryInfoCallback(true));
                    String[] objectTypeNames = new String[]{"Alias", "Volume", "NCP Server"};
                    ResultModifier volModifier = new ResultModifier("", 0, 0, new ResultModifierFilterEntry(null, objectTypeNames), false);
                    JCSearchFilter searchFilter = new JClientChildFilterImpl(volModifier, this.namespace, this.parentEntry).getFilter();
                    JClient.searchToCB((JCContext)ctx, (JCSearchFilter)searchFilter, (JCEntryInfoCB)new ContainerOnlyEntryInfoCallback(false), (JCReadCB)new ReadCallback(), (JCSearchContextCB)new SearchContextCallback());
                    this.internalCountReliability = 1;
                }
                catch (JCException x) {
                    if (x.getErrorCode() != -754) {
                        throw x;
                    }
                    this.internalCountReliability = 3;
                    Debug.out("14000 object limit reached.  Search has been cancelled");
                }
                tmpJCValIter = this.childResultArrList.iterator();
            } else {
                JCSearchFilter searchFilter = new JClientChildFilterImpl(modifier, this.namespace, this.parentEntry).getFilter();
                if (searchFilter == null) {
                    tmpJCValEnum = new JCListEnumerator(ctx, 6156);
                    this.internalCountReliability = 4;
                } else {
                    try {
                        JClient.searchToCB((JCContext)ctx, (JCSearchFilter)searchFilter, (JCEntryInfoCB)new SearchEntryInfoCallback(), (JCReadCB)new ReadCallback(), (JCSearchContextCB)new SearchContextCallback());
                        this.internalCountReliability = 1;
                    }
                    catch (JCException x) {
                        if (x.getErrorCode() != -754) {
                            throw x;
                        }
                        this.internalCountReliability = 3;
                        Debug.out("14000 object limit reached.  Search has been cancelled");
                    }
                    tmpJCValIter = this.childResultArrList.iterator();
                }
            }
            this.childResultArrList = this.crackEntries(tmpJCValIter, (Enumeration)tmpJCValEnum);
            if (modifier != null && modifier.getSortByKey() != 0) {
                OEComparator oeComparator = new OEComparator(modifier.getSortByKey(), this.namespace);
                Collections.sort(this.childResultArrList, oeComparator);
            }
            if (modifier != null && modifier.getSortOrderKey() == 1) {
                this.reverseList(this.childResultArrList);
            }
            this.childIter = this.childResultArrList.iterator();
        }
        catch (JCException x) {
            throw this.resolveSPIException((Exception)((Object)x));
        }
        finally {
            if (ctx != null) {
                ctx.free();
            }
        }
    }

    public int getCount() {
        return this.internalCrackedCount;
    }

    public int getCountReliability() {
        return this.internalCountReliability;
    }

    public boolean hasMoreElements() {
        return this.childIter.hasNext();
    }

    public Object nextElement() {
        return this.next();
    }

    public ObjectEntry next() {
        return (ObjectEntry)this.childIter.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList crackEntries(Iterator entryIter, Enumeration entryEnum) {
        String treeName = this.parentEntry.getRoot().getName();
        ArrayList<ObjectEntry> entryArrList = this.eiInvokedCount != 0 ? new ArrayList<ObjectEntry>(this.eiInvokedCount) : (this.containereiInvokedCnt != 0 ? new ArrayList(this.containereiInvokedCnt) : new ArrayList());
        boolean thereIsMore = entryIter != null ? entryIter.hasNext() : entryEnum.hasMoreElements();
        while (thereIsMore) {
            JCEntryInfo entry;
            if (entryIter != null) {
                entry = (JCEntryInfo)entryIter.next();
                thereIsMore = entryIter.hasNext();
            } else {
                entry = (JCEntryInfo)entryEnum.nextElement();
                thereIsMore = entryEnum.hasMoreElements();
            }
            try {
                ObjectEntry parentOE;
                String childName;
                String baseClass = entry.getBaseClass();
                ObjectType ot = null;
                int flags = entry.getEntryFlags();
                if (this.subtree) {
                    childName = entry.getEntryDN().toString();
                    parentOE = this.parentEntry.getRoot();
                } else {
                    childName = entry.getEntryRDN().toString();
                    parentOE = this.parentEntry;
                }
                if (ObjectFlags.isAlias(flags)) {
                    String parentDN = this.namespace.getUnrootedName(parentOE);
                    String childString = parentDN.equals("") ? childName : childName + "." + parentDN;
                    JCContext childCtx = null;
                    try {
                        childCtx = this.namespace.getContext(treeName, childString, 2);
                        JCEntryInfo aliasInfo = JClient.getEntryInfo((JCContext)childCtx, (int)131072);
                        baseClass = aliasInfo.getDereferencedBaseClass();
                    }
                    finally {
                        if (childCtx != null) {
                            childCtx.free();
                        }
                    }
                    if (ObjectFlags.isContainer(flags)) {
                        ot = this.namespace.getObjectType(parentOE, baseClass);
                        ot = new ObjectType(ot.getName(), ot.getNamespace(), true, ot.getParentTypes());
                    }
                }
                if (ot == null) {
                    ot = this.namespace.getObjectType(parentOE, baseClass);
                }
                ObjectEntry oe = new ObjectEntry(childName, ot, parentOE, flags, true);
                int subcount = -1;
                try {
                    subcount = entry.getSubordinateCount();
                    oe.setSubordinateCount(subcount);
                }
                catch (JCEntryInfoEmptyFieldException jCEntryInfoEmptyFieldException) {
                    // empty catch block
                }
                entryArrList.add(oe);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.internalCrackedCount = entryArrList.size();
        return entryArrList;
    }

    public void close() {
        this.finalize();
    }

    protected void finalize() {
    }

    private SPIException resolveSPIException(Exception x) {
        SPIException exception = null;
        if (x instanceof JCException) {
            exception = this.uniqueSPIException.newException(((JCException)((Object)x)).getErrorCode(), "", x);
        } else if (x instanceof SPIException) {
            exception = (SPIException)x;
        }
        if (exception == null) {
            exception = this.spiException.newException(x);
        }
        return exception;
    }

    private void reverseList(ArrayList arr) {
        int len = arr.size();
        for (int i = 0; i < len / 2; ++i) {
            Object tmp = arr.get(i);
            arr.set(i, arr.get(len - 1 - i));
            arr.set(len - 1 - i, tmp);
        }
    }

    private class ContainerOnlyEntryInfoCallback
    implements JCEntryInfoCB {
        public ContainerOnlyEntryInfoCallback(boolean clearChildResultList) {
            if (clearChildResultList) {
                ChildObjectEntryEnumerationImpl.this.childResultArrList = new ArrayList();
            }
        }

        public int entryInfoCallback(JCContext context, JCEntryInfo entryInfo) {
            boolean entryWasAdded = true;
            int eflags = 0;
            try {
                eflags = entryInfo.getEntryFlags();
            }
            catch (JCEntryInfoEmptyFieldException jCEntryInfoEmptyFieldException) {
                // empty catch block
            }
            if (ObjectFlags.isAlias(eflags)) {
                if (ObjectFlags.isContainer(eflags)) {
                    ChildObjectEntryEnumerationImpl.this.childResultArrList.add(entryInfo);
                } else {
                    entryWasAdded = false;
                }
            } else {
                ChildObjectEntryEnumerationImpl.this.childResultArrList.add(entryInfo);
            }
            if (entryWasAdded && ++ChildObjectEntryEnumerationImpl.this.containereiInvokedCnt >= 14000) {
                return -754;
            }
            return 0;
        }

        public String toString() {
            return Integer.toString(ChildObjectEntryEnumerationImpl.this.containereiInvokedCnt);
        }
    }

    private class SearchEntryInfoCallback
    implements JCEntryInfoCB {
        public SearchEntryInfoCallback() {
            ChildObjectEntryEnumerationImpl.this.childResultArrList = new ArrayList();
        }

        public int entryInfoCallback(JCContext context, JCEntryInfo entryInfo) {
            if (entryInfo != null) {
                ChildObjectEntryEnumerationImpl.this.childResultArrList.add(entryInfo);
            }
            try {
                Runtime rt = Runtime.getRuntime();
                long free = rt.freeMemory();
                count++;
                if (firsttime) {
                    firsttime = false;
                    freeinitial = free / 2L;
                }
                if (free < freeinitial && ++ChildObjectEntryEnumerationImpl.this.eiInvokedCount >= 14000) {
                    firsttime = true;
                    count = 0L;
                    System.gc();
                    return -754;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }

        public String toString() {
            return Integer.toString(ChildObjectEntryEnumerationImpl.this.eiInvokedCount);
        }
    }

    private static class SearchContextCallback
    implements JCSearchContextCB {
        private int cInvocations = 0;

        private SearchContextCallback() {
        }

        public int searchContextCallback(JCContext context, String lastName, String nextName, int dsErr, long cObjects) {
            return dsErr;
        }

        public String toString() {
            return Integer.toString(this.cInvocations);
        }
    }

    private static class ReadCallback
    implements JCReadCB {
        private int cInvocations = 0;

        private ReadCallback() {
        }

        public int readCallback(JCContext context, JCValue value) {
            return 0;
        }

        public String toString() {
            return Integer.toString(this.cInvocations);
        }
    }
}

