/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds.jclient;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.util.Npp;
import com.novell.admin.ns.FilterResultModifier;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.Debug;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.ResultModifierFilterEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import novell.jclient.JCAclValue;
import novell.jclient.JCBooleanValue;
import novell.jclient.JCCEstringValue;
import novell.jclient.JCCIstringValue;
import novell.jclient.JCClassnameValue;
import novell.jclient.JCCounterValue;
import novell.jclient.JCDistnameValue;
import novell.jclient.JCIntegerValue;
import novell.jclient.JCIntervalValue;
import novell.jclient.JCNUstringValue;
import novell.jclient.JCNetaddressValue;
import novell.jclient.JCNetworkAddress;
import novell.jclient.JCPRstringValue;
import novell.jclient.JCPathValue;
import novell.jclient.JCReadFilter;
import novell.jclient.JCSearchExp;
import novell.jclient.JCSearchFilter;
import novell.jclient.JCSearchSubExp;
import novell.jclient.JCTimestamp;
import novell.jclient.JCUnknownValue;
import novell.jclient.JCValue;

final class JClientChildFilterImpl {
    private JCSearchFilter searchFilter = null;
    private NDSNamespace ns = null;
    private ObjectEntry parent_oe = null;
    private boolean showInheritedSubClasses = false;
    private boolean showAuxAndSubClasses = false;
    private boolean useSimpleAndOpAdvanced = false;
    private static int DEFINDCNT = 2;

    public JClientChildFilterImpl(ResultModifier modifier, NDSNamespace namespace, ObjectEntry oe) {
        this.ns = namespace;
        this.parent_oe = oe;
        if (modifier != null) {
            JCSearchExp searchExpression = null;
            this.showInheritedSubClasses = modifier.getIncludeSubClasses();
            this.showAuxAndSubClasses = modifier.getIncludeAuxClasses();
            this.useSimpleAndOpAdvanced = modifier.getSimpleAndOpAdvanced();
            ResultModifierFilterEntry[] filters = modifier.getFilters();
            boolean isSearch = true;
            if (filters == null || filters.length == 0) {
                isSearch = false;
            } else if (filters.length == 1) {
                String nameFilter = filters[0].getNameFilter();
                String[] objectTypeFilters = filters[0].getTypeFilter();
                if (nameFilter == null || nameFilter.equals("") || nameFilter.equals("*")) {
                    if (objectTypeFilters == null || objectTypeFilters.length == 0) {
                        isSearch = false;
                    } else if (objectTypeFilters.length == 1 && (objectTypeFilters[0] == null || objectTypeFilters[0].equals("") || objectTypeFilters[0].equals("*"))) {
                        isSearch = false;
                    }
                }
            }
            if (isSearch) {
                searchExpression = this.getSimpleSearchExpression(modifier.getFilters());
            }
            if (modifier instanceof FilterResultModifier) {
                searchExpression = this.getExtendedSearchExpression((FilterResultModifier)modifier, searchExpression);
            }
            if (searchExpression == null) {
                ResultModifierFilterEntry[] rmfe = new ResultModifierFilterEntry[1];
                String[] objectTypeNames = new String[]{"*"};
                rmfe[0] = new ResultModifierFilterEntry(null, objectTypeNames);
                searchExpression = this.getSimpleSearchExpression(rmfe);
            }
            if (searchExpression != null) {
                int searchLevel;
                long entryInfoFlags = 6156L;
                if (modifier.isSubContainerSearch()) {
                    searchLevel = 2;
                    entryInfoFlags |= 0x2000L;
                } else {
                    searchLevel = 1;
                }
                this.searchFilter = new JCSearchFilter((long)searchLevel, 0L, 2L, -1L, entryInfoFlags, 1L, new JCReadFilter(false, null, new String[]{""}), searchExpression);
            }
        }
    }

    public JCSearchFilter getFilter() {
        return this.searchFilter;
    }

    private JCSearchExp getSimpleSearchExpression(ResultModifierFilterEntry[] filters) {
        JCSearchExp retSearchExpression = null;
        Vector<JCSearchExp> totalSearchExpressionVec = new Vector<JCSearchExp>(filters.length);
        for (int j = 0; j < filters.length; ++j) {
            String[] objectTypeFilters;
            JCSearchExp TNSearchExp = null;
            String nameFilter = this.escapeTheRDNDot(filters[j].getNameFilter());
            if (nameFilter != null && nameFilter.length() == 0) {
                nameFilter = null;
            }
            if ((objectTypeFilters = filters[j].getTypeFilter()) != null && objectTypeFilters.length > 0) {
                JCSearchSubExp tmpSubExpression;
                JCSearchExp[] typeAndNameSEArray = new JCSearchExp[objectTypeFilters.length];
                for (int i = 0; i < objectTypeFilters.length; ++i) {
                    JCSearchExp tmpSearchExpression = this.showAuxAndSubClasses && !objectTypeFilters[i].equals("*") ? new JCSearchExp(this.convertToJCValue("Object Class", 7, objectTypeFilters[i])) : (this.showInheritedSubClasses && !objectTypeFilters[i].equals("*") ? this.getSubClassSearchExpression(objectTypeFilters[i]) : new JCSearchExp((JCValue)new JCClassnameValue("", 17, 0L, new JCTimestamp(), objectTypeFilters[i])));
                    if (nameFilter != null) {
                        JCSearchExp[] tmpSearchExpArray = new JCSearchExp[]{tmpSearchExpression, new JCSearchExp((JCValue)new JCCIstringValue("", 16, 0L, new JCTimestamp(), nameFilter))};
                        tmpSubExpression = new JCSearchSubExp(tmpSearchExpArray);
                        tmpSearchExpression = new JCSearchExp(2, tmpSubExpression);
                    }
                    typeAndNameSEArray[i] = tmpSearchExpression;
                }
                if (typeAndNameSEArray.length > 1) {
                    tmpSubExpression = new JCSearchSubExp(typeAndNameSEArray);
                    TNSearchExp = new JCSearchExp(1, tmpSubExpression);
                } else {
                    TNSearchExp = typeAndNameSEArray[0];
                }
            } else if (nameFilter != null) {
                TNSearchExp = new JCSearchExp((JCValue)new JCCIstringValue("", 16, 0L, new JCTimestamp(), nameFilter));
            }
            if (TNSearchExp == null) continue;
            totalSearchExpressionVec.addElement(TNSearchExp);
        }
        int tseCount = totalSearchExpressionVec.size();
        if (tseCount > 0) {
            if (tseCount > 1) {
                Object[] finalSearchExpressionArray = new JCSearchExp[tseCount];
                totalSearchExpressionVec.copyInto(finalSearchExpressionArray);
                JCSearchSubExp finalSubExpression = new JCSearchSubExp((JCSearchExp[])finalSearchExpressionArray);
                retSearchExpression = new JCSearchExp(1, finalSubExpression);
            } else {
                retSearchExpression = (JCSearchExp)totalSearchExpressionVec.firstElement();
            }
        }
        return retSearchExpression;
    }

    private JCSearchExp getSubClassSearchExpression(String firstClassName) {
        LinkedHashSet<String> completeClassSubClassSet = new LinkedHashSet<String>();
        try {
            SchemaDefinition classSchemaDef = this.ns.getSchemaDefinition(this.parent_oe);
            SchemaUtil.putThisClassAndSubClassesIntoSet(firstClassName, completeClassSubClassSet, classSchemaDef);
        }
        catch (SPIException spie) {
            completeClassSubClassSet.add(firstClassName);
            Debug.out("\nWarning: Unable to get the NDSSchemaDefinition. The single class name will be used.");
            Debug.out("    " + spie.toString() + "\n");
        }
        int totalClassCount = completeClassSubClassSet.size();
        JCSearchExp[] allClassSEArray = new JCSearchExp[totalClassCount];
        Iterator iter = completeClassSubClassSet.iterator();
        int ii = 0;
        while (iter.hasNext()) {
            allClassSEArray[ii++] = new JCSearchExp((JCValue)new JCClassnameValue("", 17, 0L, new JCTimestamp(), (String)iter.next()));
        }
        if (allClassSEArray.length > 1) {
            JCSearchSubExp tmpSubClassExpression = new JCSearchSubExp(allClassSEArray);
            return new JCSearchExp(1, tmpSubClassExpression);
        }
        return allClassSEArray[0];
    }

    private JCSearchExp getExtendedSearchExpression(FilterResultModifier modifier, JCSearchExp currentSearchExp) {
        JCSearchExp filtersSearchExpression;
        JCSearchSubExp tmpSubExpression;
        FilterResultModifier.Filter[] allFilterArr = modifier.getFRMFilters();
        ArrayList<JCSearchExp> allFilterSEArrList = new ArrayList<JCSearchExp>(allFilterArr.length);
        JCSearchExp retSearchExpression = null;
        for (int kk = 0; kk < allFilterArr.length; ++kk) {
            JCSearchExp tmpSearchExpression;
            FilterResultModifier.Filter.FilterItemGroupPair[] figGroupPairs = allFilterArr[kk].getFilterItemGroupPairs();
            JCSearchExp[] figFilterSEArray = new JCSearchExp[figGroupPairs.length];
            JCSearchExp typeNameSearchExpression = null;
            JCSearchExp figSearchExpression = null;
            for (int i = 0; i < figGroupPairs.length; ++i) {
                FilterResultModifier.FilterItemGroup filterItemGroup = figGroupPairs[i].getFilterItemGroup();
                FilterResultModifier.FilterItemGroup.FilterItem[] filterItems = filterItemGroup.getFilterItems();
                JCSearchExp[] fiSEArray = new JCSearchExp[filterItems.length];
                for (int j = 0; j < filterItems.length; ++j) {
                    JCSearchSubExp notExpression;
                    JCSearchExp[] theNotExpressionArray;
                    String compareFilter = filterItems[j].getCompareFilter();
                    if (compareFilter.equals("=")) {
                        String attributeName = filterItems[j].getAttributeName();
                        if (attributeName.equals("BaseClass")) {
                            if (this.showAuxAndSubClasses && !filterItems[j].getAttributeValue().equals("*")) {
                                fiSEArray[j] = new JCSearchExp(this.convertToJCValue("Object Class", 7, filterItems[j].getAttributeValue()));
                                continue;
                            }
                            if (this.showInheritedSubClasses && !filterItems[j].getAttributeValue().equals("*")) {
                                fiSEArray[j] = this.getSubClassSearchExpression(filterItems[j].getAttributeValue());
                                continue;
                            }
                            fiSEArray[j] = new JCSearchExp((JCValue)new JCCIstringValue("", 17, 0L, new JCTimestamp(), filterItems[j].getAttributeValue()));
                            continue;
                        }
                        fiSEArray[j] = new JCSearchExp(this.convertToJCValue(attributeName, 7, filterItems[j].getAttributeValue()));
                        continue;
                    }
                    if (compareFilter.equals("!")) {
                        theNotExpressionArray = new JCSearchExp[1];
                        String attributeName = filterItems[j].getAttributeName();
                        theNotExpressionArray[0] = attributeName.equals("BaseClass") ? (this.showAuxAndSubClasses && !filterItems[j].getAttributeValue().equals("*") ? new JCSearchExp(this.convertToJCValue("Object Class", 7, filterItems[j].getAttributeValue())) : (this.showInheritedSubClasses && !filterItems[j].getAttributeValue().equals("*") ? this.getSubClassSearchExpression(filterItems[j].getAttributeValue()) : new JCSearchExp((JCValue)new JCCIstringValue("", 17, 0L, new JCTimestamp(), filterItems[j].getAttributeValue())))) : new JCSearchExp(this.convertToJCValue(attributeName, 7, filterItems[j].getAttributeValue()));
                        notExpression = new JCSearchSubExp(theNotExpressionArray);
                        fiSEArray[j] = new JCSearchExp(3, notExpression);
                        continue;
                    }
                    if (compareFilter.equals(">=")) {
                        fiSEArray[j] = new JCSearchExp(this.convertToJCValue(filterItems[j].getAttributeName(), 8, filterItems[j].getAttributeValue()));
                        continue;
                    }
                    if (compareFilter.equals("<=")) {
                        fiSEArray[j] = new JCSearchExp(this.convertToJCValue(filterItems[j].getAttributeName(), 9, filterItems[j].getAttributeValue()));
                        continue;
                    }
                    if (compareFilter.equals("~=")) {
                        fiSEArray[j] = new JCSearchExp(this.convertToJCValue(filterItems[j].getAttributeName(), 10, filterItems[j].getAttributeValue()));
                        continue;
                    }
                    if (compareFilter.equals("!*")) {
                        theNotExpressionArray = new JCSearchExp[]{new JCSearchExp(this.convertToJCValue(filterItems[j].getAttributeName(), 15, filterItems[j].getAttributeValue()))};
                        notExpression = new JCSearchSubExp(theNotExpressionArray);
                        fiSEArray[j] = new JCSearchExp(3, notExpression);
                        continue;
                    }
                    fiSEArray[j] = new JCSearchExp(this.convertToJCValue(filterItems[j].getAttributeName(), 15, filterItems[j].getAttributeValue()));
                }
                if (fiSEArray.length > 1) {
                    int fLogicalFilter = 2;
                    if (filterItems[0].getLogicalFilter() == "|") {
                        fLogicalFilter = 1;
                    }
                    tmpSubExpression = new JCSearchSubExp(fiSEArray);
                    tmpSearchExpression = new JCSearchExp(fLogicalFilter, tmpSubExpression);
                } else {
                    tmpSearchExpression = fiSEArray[0];
                }
                figFilterSEArray[i] = tmpSearchExpression;
            }
            if (figGroupPairs.length > 1) {
                int figLogicalFilter = 1;
                if (figGroupPairs[0].getLogicalFilter() == "&") {
                    figLogicalFilter = 2;
                }
                tmpSubExpression = new JCSearchSubExp(figFilterSEArray);
                figSearchExpression = new JCSearchExp(figLogicalFilter, tmpSubExpression);
            } else {
                figSearchExpression = figFilterSEArray[0];
            }
            if (allFilterArr[kk].getFilterTypeName() != null) {
                typeNameSearchExpression = this.showAuxAndSubClasses && !allFilterArr[kk].getFilterTypeName().equals("*") ? new JCSearchExp(this.convertToJCValue("Object Class", 7, allFilterArr[kk].getFilterTypeName())) : (this.showInheritedSubClasses && !allFilterArr[kk].getFilterTypeName().equals("*") ? this.getSubClassSearchExpression(allFilterArr[kk].getFilterTypeName()) : new JCSearchExp((JCValue)new JCCIstringValue("", 17, 0L, new JCTimestamp(), allFilterArr[kk].getFilterTypeName())));
            }
            if (typeNameSearchExpression != null && figSearchExpression != null) {
                JCSearchExp[] typedExpressionArray = new JCSearchExp[]{typeNameSearchExpression, figSearchExpression};
                JCSearchSubExp typeWithNameSubExpression = new JCSearchSubExp(typedExpressionArray);
                tmpSearchExpression = new JCSearchExp(2, typeWithNameSubExpression);
                allFilterSEArrList.add(tmpSearchExpression);
                continue;
            }
            if (typeNameSearchExpression != null) {
                allFilterSEArrList.add(typeNameSearchExpression);
                continue;
            }
            if (figSearchExpression == null) continue;
            allFilterSEArrList.add(figSearchExpression);
        }
        if (allFilterSEArrList.size() > 0) {
            if (allFilterSEArrList.size() > 1) {
                JCSearchExp[] allExpressionArray = new JCSearchExp[allFilterSEArrList.size()];
                allExpressionArray = allFilterSEArrList.toArray(allExpressionArray);
                tmpSubExpression = new JCSearchSubExp(allExpressionArray);
                filtersSearchExpression = new JCSearchExp(1, tmpSubExpression);
            } else {
                filtersSearchExpression = (JCSearchExp)allFilterSEArrList.get(0);
            }
        } else {
            filtersSearchExpression = null;
        }
        if (filtersSearchExpression != null && currentSearchExp != null) {
            JCSearchExp[] completeExpArray = new JCSearchExp[]{currentSearchExp, filtersSearchExpression};
            tmpSubExpression = new JCSearchSubExp(completeExpArray);
            retSearchExpression = this.useSimpleAndOpAdvanced ? new JCSearchExp(2, tmpSubExpression) : new JCSearchExp(1, tmpSubExpression);
        } else if (filtersSearchExpression != null) {
            retSearchExpression = filtersSearchExpression;
        } else if (currentSearchExp != null) {
            retSearchExpression = currentSearchExp;
        }
        return retSearchExpression;
    }

    private String escapeTheRDNDot(String rdn) {
        if (rdn != null && rdn.length() != 0 && rdn.indexOf(".") != -1) {
            int indexOfDot;
            int fromIndex = rdn.length() - 1;
            StringBuffer escapedString = new StringBuffer(rdn);
            while ((indexOfDot = rdn.lastIndexOf(".", fromIndex)) != -1) {
                if (indexOfDot > 1) {
                    if (rdn.charAt(indexOfDot - 1) != '\\') {
                        escapedString.insert(indexOfDot, "\\");
                    }
                } else {
                    escapedString.insert(indexOfDot, "\\");
                }
                fromIndex = indexOfDot - 1;
            }
            return escapedString.toString();
        }
        return rdn;
    }

    private JCValue convertToJCValue(String name, int op, String value) {
        try {
            Syntax syntax = this.ns.getSchemaDefinition(this.parent_oe).getAttributeDefinition(name).getSyntax();
            switch (syntax.getId()) {
                case 8: {
                    long v = value != null && value.length() > 0 ? Long.parseLong(value) : 0L;
                    return new JCIntegerValue(name, op, 0L, new JCTimestamp(), v);
                }
                case 2: {
                    return new JCCEstringValue(name, op, 0L, new JCTimestamp(), value);
                }
                case 3: {
                    return new JCCIstringValue(name, op, 0L, new JCTimestamp(), value);
                }
                case 20: {
                    return new JCClassnameValue(name, op, 0L, new JCTimestamp(), value);
                }
                case 1: {
                    return new JCDistnameValue(name, op, 0L, new JCTimestamp(), value);
                }
                case 27: {
                    long v = value != null && value.length() > 0 ? Long.parseLong(value) : 0L;
                    return new JCIntervalValue(name, op, 0L, new JCTimestamp(), v);
                }
                case 22: {
                    int ival = value != null && value.length() > 0 ? Integer.parseInt(value) : 0;
                    return new JCCounterValue(name, op, 0L, new JCTimestamp(), ival);
                }
                case 5: {
                    return new JCNUstringValue(name, op, 0L, new JCTimestamp(), value);
                }
                case 4: {
                    return new JCPRstringValue(name, op, 0L, new JCTimestamp(), value);
                }
                case 7: {
                    return new JCBooleanValue(name, op, 0L, new JCTimestamp(), Boolean.valueOf(value).booleanValue());
                }
                case 17: {
                    long privileges = 0L;
                    String trusteeDN = "";
                    String attrName = "";
                    if (value != null) {
                        StringTokenizer st = new StringTokenizer(value, "#");
                        privileges = Long.parseLong(st.nextToken());
                        st.nextToken();
                        trusteeDN = st.nextToken();
                        if (trusteeDN.equals("*")) {
                            trusteeDN = null;
                        }
                        if ((attrName = st.nextToken()).equals("*")) {
                            attrName = null;
                        }
                    }
                    return new JCAclValue(name, op, 0L, new JCTimestamp(), attrName, trusteeDN, privileges);
                }
                case 15: {
                    String volumeDN = "";
                    int nameSpace = 0;
                    String volumePath = "";
                    if (value != null) {
                        StringTokenizer pathTok = new StringTokenizer(value, "#");
                        if (op == 15) {
                            volumeDN = "*";
                            nameSpace = 0;
                            volumePath = "*";
                        } else {
                            volumeDN = pathTok.nextToken();
                            nameSpace = Integer.parseInt(pathTok.nextToken());
                            volumePath = pathTok.nextToken();
                        }
                    }
                    return new JCPathValue(name, op, 0L, new JCTimestamp(), volumeDN, volumePath, nameSpace);
                }
                case 12: {
                    int type = 0;
                    byte[] address = null;
                    if (value != null) {
                        StringTokenizer naTok = new StringTokenizer(value, "#");
                        type = Integer.parseInt(naTok.nextToken());
                        address = JClientChildFilterImpl.toHex(naTok.nextToken());
                    }
                    return new JCNetaddressValue(name, op, 0L, new JCTimestamp(), new JCNetworkAddress(type, address));
                }
            }
            return new JCUnknownValue(name, 15, 0L, new JCTimestamp(), null);
        }
        catch (SPIException e) {
            Debug.out(e.toString() + " - " + name);
        }
        catch (NamespaceException e) {
            Debug.out(e.toString() + " - " + name);
        }
        return new JCUnknownValue(name, 15, 0L, new JCTimestamp(), null);
    }

    private static byte[] toHex(String octetString) {
        int len = octetString.length();
        if (len % 3 != 0) {
            return null;
        }
        char[] chars = new char[len];
        octetString.getChars(0, octetString.length(), chars, 0);
        byte[] bytes = new byte[len / 3];
        int i = 0;
        int pos = 0;
        while (pos < len) {
            int n = ++pos;
            int hi = Character.digit(chars[n], 16);
            int n2 = ++pos;
            ++pos;
            int lo = Character.digit(chars[n2], 16);
            if (hi < 0 || lo < 0) break;
            bytes[i] = (byte)((hi << 4) + lo);
            ++i;
        }
        return bytes;
    }

    public static void printFilter(JCSearchFilter inFilter) {
        String tmpStr;
        Npp.setFormatString("%i%n %m(%l) %s");
        Npp.prime(2);
        Npp.out("ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff");
        if (inFilter == null) {
            Npp.out(" **** Filter is NULL ****");
            Npp.out(" ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff");
            return;
        }
        Npp.out(" **** " + inFilter.toString() + "  ****");
        int tmpVal = (int)inFilter.scope;
        switch (tmpVal) {
            case 0: {
                tmpStr = "ENTRY - this single object";
                break;
            }
            case 1: {
                tmpStr = "SUBORDINATES - immediate children only";
                break;
            }
            case 2: {
                tmpStr = "SUBTREE - entire subtree";
                break;
            }
            case 3: {
                tmpStr = "PARTITION - this partition";
                break;
            }
            default: {
                tmpStr = "UNKNOWN or mixed values";
            }
        }
        Npp.out(" scope: (" + inFilter.scope + ")  " + tmpStr);
        Npp.out(" derefAliases: Not Showing!  (deprecated - use of requestFlags recommended)");
        tmpStr = inFilter.requestFlags == 0L ? "Not Specified" : (inFilter.requestFlags == 1L ? "DEREF_ALIASES - alias referrals returned" : (inFilter.requestFlags == 2L ? "EXTERNAL_REFERENCES - external reference included, no referrals returned" : (inFilter.requestFlags == 4L ? "USE_SPARSE - sparse replicas included" : (inFilter.requestFlags == 8L ? "REFER_SPARSE - sparse replicas treated as sub-refs and returned as referrals" : "UNKNOWN values"))));
        Npp.out(" requestFlags: (" + inFilter.requestFlags + ")  " + tmpStr);
        long tmpResolveFlgs = inFilter.resolveFlags;
        tmpStr = "    ";
        if ((tmpResolveFlgs & 1L) != 0L) {
            tmpResolveFlgs &= 0xFFFFFFFFFFFFFFFEL;
            tmpStr = tmpStr + "ENTRY_ID, ";
        }
        if ((tmpResolveFlgs & 2L) != 0L) {
            tmpResolveFlgs &= 0xFFFFFFFFFFFFFFFDL;
            tmpStr = tmpStr + "READABLE, ";
        }
        if ((tmpResolveFlgs & 4L) != 0L) {
            tmpResolveFlgs &= 0xFFFFFFFFFFFFFFFBL;
            tmpStr = tmpStr + "WRITABLE, ";
        }
        if ((tmpResolveFlgs & 8L) != 0L) {
            tmpResolveFlgs &= 0xFFFFFFFFFFFFFFF7L;
            tmpStr = tmpStr + "MASTER, ";
        }
        if ((tmpResolveFlgs & 0x10L) != 0L) {
            tmpResolveFlgs &= 0xFFFFFFFFFFFFFFEFL;
            tmpStr = tmpStr + "CREATE_ID, ";
        }
        if ((tmpResolveFlgs & 0x20L) != 0L) {
            tmpResolveFlgs &= 0xFFFFFFFFFFFFFFDFL;
            tmpStr = tmpStr + "WALK_TREE, ";
        }
        if ((tmpResolveFlgs & 0x40L) != 0L) {
            tmpResolveFlgs &= 0xFFFFFFFFFFFFFFBFL;
            tmpStr = tmpStr + "DEREFERENCE_ALIASES, ";
        }
        if ((tmpResolveFlgs & 0x200L) != 0L) {
            tmpResolveFlgs &= 0xFFFFFFFFFFFFFDFFL;
            tmpStr = tmpStr + "OLD402_CREATE_ID, ";
        }
        if ((tmpResolveFlgs & 0x400L) != 0L) {
            tmpResolveFlgs &= 0xFFFFFFFFFFFFFBFFL;
            tmpStr = tmpStr + "EXHAUST_REPLICAS, ";
        }
        if ((tmpResolveFlgs & 0x2000L) != 0L) {
            tmpResolveFlgs &= 0xFFFFFFFFFFFFDFFFL;
            tmpStr = tmpStr + "PREFER_REFERRALS, ";
        }
        if ((tmpResolveFlgs & 0x4000L) != 0L) {
            tmpResolveFlgs &= 0xFFFFFFFFFFFFBFFFL;
            tmpStr = tmpStr + "PREFER_ONLY_REFERRALS, ";
        }
        if ((tmpResolveFlgs & 0x8000L) != 0L) {
            tmpResolveFlgs &= 0xFFFFFFFFFFFF7FFFL;
            tmpStr = tmpStr + "NO_HIDDEN, ";
        }
        if ((tmpResolveFlgs & 0x10000L) != 0L) {
            tmpResolveFlgs &= 0xFFFFFFFFFFFEFFFFL;
            tmpStr = tmpStr + "NO_SECURE, ";
        }
        if ((tmpResolveFlgs & 0x20000L) != 0L) {
            tmpResolveFlgs &= 0xFFFFFFFFFFFDFFFFL;
            tmpStr = tmpStr + "CACHE_ONLY, ";
        }
        Npp.out(" resolveFlags: (" + inFilter.resolveFlags + " - remain " + tmpResolveFlgs + ") how names resolved when processing referrals");
        Npp.out(tmpStr);
        Npp.out(" maxObjectsBeforeBreak: " + inFilter.maxObjectsBeforeBreak + "  (ignored by MOAB and all previous NDS versions)");
        long tmpEntryFlgs = inFilter.entryFlags;
        tmpStr = "    ";
        if ((tmpEntryFlgs & 1L) != 0L) {
            tmpEntryFlgs &= 0xFFFFFFFFFFFFFFFEL;
            tmpStr = tmpStr + "OUTPUT_FIELDS, ";
        }
        if ((tmpEntryFlgs & 2L) != 0L) {
            tmpEntryFlgs &= 0xFFFFFFFFFFFFFFFDL;
            tmpStr = tmpStr + "ENTRY_ID, ";
        }
        if ((tmpEntryFlgs & 4L) != 0L) {
            tmpEntryFlgs &= 0xFFFFFFFFFFFFFFFBL;
            tmpStr = tmpStr + "ENTRY_FLAGS, ";
        }
        if ((tmpEntryFlgs & 8L) != 0L) {
            tmpEntryFlgs &= 0xFFFFFFFFFFFFFFF7L;
            tmpStr = tmpStr + "SUBORDINATE_COUNT, ";
        }
        if ((tmpEntryFlgs & 0x10L) != 0L) {
            tmpEntryFlgs &= 0xFFFFFFFFFFFFFFEFL;
            tmpStr = tmpStr + "MODIFICATION_TIME, ";
        }
        if ((tmpEntryFlgs & 0x20L) != 0L) {
            tmpEntryFlgs &= 0xFFFFFFFFFFFFFFDFL;
            tmpStr = tmpStr + "MODIFICATION_TIMESTAMP, ";
        }
        if ((tmpEntryFlgs & 0x40L) != 0L) {
            tmpEntryFlgs &= 0xFFFFFFFFFFFFFFBFL;
            tmpStr = tmpStr + "CREATION_TIMESTAMP, ";
        }
        if ((tmpEntryFlgs & 0x80L) != 0L) {
            tmpEntryFlgs &= 0xFFFFFFFFFFFFFF7FL;
            tmpStr = tmpStr + "PARTITION_ROOT_ID, ";
        }
        if ((tmpEntryFlgs & 0x100L) != 0L) {
            tmpEntryFlgs &= 0xFFFFFFFFFFFFFEFFL;
            tmpStr = tmpStr + "PARENT_ID, ";
        }
        if ((tmpEntryFlgs & 0x200L) != 0L) {
            tmpEntryFlgs &= 0xFFFFFFFFFFFFFDFFL;
            tmpStr = tmpStr + "REVISION_COUNT, ";
        }
        if ((tmpEntryFlgs & 0x400L) != 0L) {
            tmpEntryFlgs &= 0xFFFFFFFFFFFFFBFFL;
            tmpStr = tmpStr + "REPLICA_TYPE, ";
        }
        if ((tmpEntryFlgs & 0x800L) != 0L) {
            tmpEntryFlgs &= 0xFFFFFFFFFFFFF7FFL;
            tmpStr = tmpStr + "BASE_CLASS, ";
        }
        if ((tmpEntryFlgs & 0x1000L) != 0L) {
            tmpEntryFlgs &= 0xFFFFFFFFFFFFEFFFL;
            tmpStr = tmpStr + "ENTRY_RDN, ";
        }
        if ((tmpEntryFlgs & 0x2000L) != 0L) {
            tmpEntryFlgs &= 0xFFFFFFFFFFFFDFFFL;
            tmpStr = tmpStr + "ENTRY_DN, ";
        }
        if ((tmpEntryFlgs & 0x4000L) != 0L) {
            tmpEntryFlgs &= 0xFFFFFFFFFFFFBFFFL;
            tmpStr = tmpStr + "PARTITION_ROOT_DN, ";
        }
        if ((tmpEntryFlgs & 0x8000L) != 0L) {
            tmpEntryFlgs &= 0xFFFFFFFFFFFF7FFFL;
            tmpStr = tmpStr + "PARENT_DN, ";
        }
        if ((tmpEntryFlgs & 0x10000L) != 0L) {
            tmpEntryFlgs &= 0xFFFFFFFFFFFEFFFFL;
            tmpStr = tmpStr + "PURGE_TIME, ";
        }
        if ((tmpEntryFlgs & 0x20000L) != 0L) {
            tmpEntryFlgs &= 0xFFFFFFFFFFFDFFFFL;
            tmpStr = tmpStr + "DEREFERENCED_BASE_CLASS, ";
        }
        if ((tmpEntryFlgs & 0x40000L) != 0L) {
            tmpEntryFlgs &= 0xFFFFFFFFFFFBFFFFL;
            tmpStr = tmpStr + "REPLICA_NUMBER, ";
        }
        if ((tmpEntryFlgs & 0x80000L) != 0L) {
            tmpEntryFlgs &= 0xFFFFFFFFFFF7FFFFL;
            tmpStr = tmpStr + "REPLICA_STATE, ";
        }
        Npp.out(" entryFlags: (" + inFilter.entryFlags + " - remain " + tmpEntryFlgs + ") entry information passed to JCEntryInfoCB");
        Npp.out(tmpStr);
        long tmpValueIT = inFilter.valueInfoType;
        tmpStr = "    ";
        if ((tmpValueIT & 0L) != 0L) {
            tmpValueIT &= 0xFFFFFFFFFFFFFFFFL;
            tmpStr = tmpStr + "ATTRIBUTE_NAMES, ";
        }
        if ((tmpValueIT & 1L) != 0L) {
            tmpValueIT &= 0xFFFFFFFFFFFFFFFEL;
            tmpStr = tmpStr + "ATTRIBUTE_VALUES, ";
        }
        if ((tmpValueIT & 2L) != 0L) {
            tmpValueIT &= 0xFFFFFFFFFFFFFFFDL;
            tmpStr = tmpStr + "EFFECTIVE_PRIVILEGES, ";
        }
        if ((tmpValueIT & 3L) != 0L) {
            tmpValueIT &= 0xFFFFFFFFFFFFFFFCL;
            tmpStr = tmpStr + "VALUE_INFO, ";
        }
        if ((tmpValueIT & 4L) != 0L) {
            tmpValueIT &= 0xFFFFFFFFFFFFFFFBL;
            tmpStr = tmpStr + "ABBREVIATED_VALUE, ";
        }
        if ((tmpValueIT & 8L) != 0L) {
            tmpValueIT &= 0xFFFFFFFFFFFFFFF7L;
            tmpStr = tmpStr + "EXPANDED_CLASS, ";
        }
        Npp.out(" valueInfoType: (" + inFilter.valueInfoType + " - remain " + tmpValueIT + ") attribute information passed JCReadCB");
        Npp.out(tmpStr);
        if (inFilter.rfilter != null) {
            Npp.out(" JCReadFilter - restricts the attributes passed to JCReadCB");
            Npp.out("     syncFormat:" + inFilter.rfilter.syncFormat + "   replica root ID returned");
            if (inFilter.rfilter.minValueTime == null) {
                Npp.out("     minValueTime: null   all attributes newer than time stamp returned");
            } else {
                Npp.out("     minValueTime: " + inFilter.rfilter.minValueTime.toString() + "   all attributes newer than time stamp returned");
            }
            Npp.out("     privilegeDN: " + inFilter.rfilter.privilegeDN + "   not used yet");
            Npp.out("     attributes returned:    \"\" means no attrs  null means all attrs");
            if (inFilter.rfilter.attributeNames == null) {
                Npp.out("         null");
            } else {
                for (int ii = 0; ii < inFilter.rfilter.attributeNames.length; ++ii) {
                    Npp.out("         [" + ii + "]: \"" + inFilter.rfilter.attributeNames[ii] + "\"");
                }
            }
        } else {
            Npp.out(" JCReadFilter is null (restricts the attributes passed to JCReadCB)");
        }
        if (inFilter.sexp != null) {
            Npp.out(" JCSearchExp - defines the directory objects to search for");
            JClientChildFilterImpl.printSearchExp(true, 4, 1, inFilter.sexp);
        } else {
            Npp.out(" JCSearchExp is null (defines the directory objects to search for)");
        }
        Npp.out(" ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff");
    }

    private static void printSearchExp(boolean doPrime, int indentCnt, int levCnt, JCSearchExp srchexp) {
        if (doPrime) {
            Npp.prime(0);
        }
        int opTag = srchexp.getOperator();
        StringBuffer spaceBuff = new StringBuffer();
        spaceBuff.append(' ');
        for (int ii = 0; ii < indentCnt; ++ii) {
            spaceBuff.append(' ');
        }
        if (opTag == 0) {
            JCValue sVal = srchexp.getJCValue();
            String fieldValueStr = sVal != null ? JClientChildFilterImpl.valueToString(sVal) : "(null)";
            Npp.out(spaceBuff.toString() + "val = " + fieldValueStr);
        } else {
            String opTagStr;
            switch (opTag) {
                case 1: {
                    opTagStr = "OR";
                    break;
                }
                case 2: {
                    opTagStr = "AND";
                    break;
                }
                case 3: {
                    opTagStr = "NOT";
                    break;
                }
                default: {
                    opTagStr = "Unknown?";
                }
            }
            JCSearchSubExp ssubexp = srchexp.getJCSearchSubExp();
            if (ssubexp != null) {
                JCSearchExp[] theSubSrchArr = ssubexp.getJCSearchExp();
                int numExps = theSubSrchArr != null && theSubSrchArr.length >= 1 ? theSubSrchArr.length : 0;
                Npp.out(spaceBuff.toString() + opTagStr + "    (" + numExps + " sub expressions)");
                if (theSubSrchArr != null && theSubSrchArr.length >= 1) {
                    for (int jj = 0; jj < theSubSrchArr.length; ++jj) {
                        JClientChildFilterImpl.printSearchExp(false, indentCnt + DEFINDCNT, levCnt + 1, theSubSrchArr[jj]);
                    }
                } else {
                    Npp.out(spaceBuff.toString() + "(subexpression search array null or empty)");
                }
            } else {
                Npp.out(spaceBuff.toString() + opTagStr + "    (0 sub expressions)");
                Npp.out(spaceBuff.toString() + "(no search subexpression)");
            }
        }
    }

    private static String valueToString(JCValue jcval) {
        String jcValStr;
        String jcOpStr;
        String jcAttrStr = jcval.attributeName;
        switch (jcval.operation) {
            case 7: {
                jcOpStr = " == ";
                break;
            }
            case 8: {
                jcOpStr = " >= ";
                break;
            }
            case 9: {
                jcOpStr = " <= ";
                break;
            }
            case 10: {
                jcOpStr = " approx ";
                break;
            }
            case 15: {
                jcOpStr = " present ";
                break;
            }
            case 16: {
                jcOpStr = " OP_RDN ";
                break;
            }
            case 17: {
                jcOpStr = " OP_BASE_CLASS ";
                break;
            }
            default: {
                jcOpStr = " ??" + jcval.operation + "?? ";
            }
        }
        switch (jcval.syntax) {
            case 8: {
                JCIntegerValue tjci = (JCIntegerValue)jcval;
                long iv = tjci.getInteger();
                jcValStr = Long.toString(iv);
                break;
            }
            case 2: {
                JCCEstringValue tjcces = (JCCEstringValue)jcval;
                jcValStr = tjcces.getString();
                break;
            }
            case 3: {
                JCCIstringValue tjccis = (JCCIstringValue)jcval;
                jcValStr = tjccis.getString();
                break;
            }
            case 20: {
                JCClassnameValue tc = (JCClassnameValue)jcval;
                jcValStr = tc.getClassname();
                break;
            }
            case 1: {
                JCDistnameValue td = (JCDistnameValue)jcval;
                jcValStr = td.getDistname();
                break;
            }
            case 27: {
                JCIntervalValue tjciv = (JCIntervalValue)jcval;
                long ivv = tjciv.getInterval();
                jcValStr = Long.toString(ivv);
                break;
            }
            case 5: {
                JCNUstringValue tjnu = (JCNUstringValue)jcval;
                jcValStr = tjnu.getString();
                break;
            }
            case 4: {
                JCPRstringValue tjpr = (JCPRstringValue)jcval;
                jcValStr = tjpr.getString();
                break;
            }
            case 12: 
            case 15: 
            case 17: {
                jcValStr = jcval.toString();
                break;
            }
            default: {
                jcValStr = "Unsupported! - " + jcval.toString();
            }
        }
        return "\"" + jcAttrStr + "\"" + jcOpStr + "\"" + jcValStr + "\"";
    }
}

