/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds.jclient;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.nds.OperationThreadStatus;
import com.novell.admin.ns.nds.jclient.NDSNamespaceImpl;
import novell.jclient.JCContext;
import novell.jclient.JCEntryInfo;
import novell.jclient.JClient;

class NDSMergePartitionThread
extends Thread
implements OperationThreadStatus {
    private String partFDN;
    private int status = 4;
    private SPIException exception = null;
    private NDSNamespaceImpl myNS;
    private String tree;

    private NDSMergePartitionThread() {
    }

    NDSMergePartitionThread(NDSNamespaceImpl ns2, String tree_name, String part) {
        this.partFDN = part;
        this.myNS = ns2;
        this.tree = tree_name;
    }

    public void run() {
        JCContext myPartContext = null;
        try {
            myPartContext = this.myNS.getContext(this.tree, this.partFDN, 8);
            this.status = 3;
            JClient.joinPartitions((JCContext)myPartContext, (long)1L);
            while (this.status != 1) {
                JCEntryInfo entry = JClient.getEntryInfo((JCContext)myPartContext, (int)4);
                if (0 == (entry.getEntryFlags() & 2)) {
                    this.status = 1;
                }
                NDSMergePartitionThread.sleep(2000L);
            }
        }
        catch (Exception e) {
            this.exception = this.myNS.resolveSPIException(e, "");
        }
        finally {
            if (myPartContext != null) {
                myPartContext.free();
            }
        }
    }

    public int operationStatus() throws SPIException {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.status;
    }
}

