/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds.jclient;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.OperationStatus;
import com.novell.admin.ns.Replica;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.NDSPartitionInfo;
import com.novell.admin.ns.nds.NDSPartitionService;
import com.novell.admin.ns.nds.NDSReplica;
import com.novell.admin.ns.nds.NDSReplicaInfo;
import com.novell.admin.ns.nds.NDSReplicaOperationStatus;
import com.novell.admin.ns.nds.NDSReplicaState;
import com.novell.admin.ns.nds.NDSReplicaType;
import com.novell.admin.ns.nds.NetAddressFacade;
import com.novell.admin.ns.nds.jclient.NDSCreatePartitionThread;
import com.novell.admin.ns.nds.jclient.NDSMergePartitionThread;
import com.novell.admin.ns.nds.jclient.NDSNamespaceImpl;
import com.novell.admin.ns.nds.jclient.NDSPartitionOperationStatus;
import com.novell.admin.ns.nds.jclient.NDSReplicaSyncInfo;
import com.novell.application.console.snapin.Debug;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;
import novell.jclient.JCContext;
import novell.jclient.JCEntryInfo;
import novell.jclient.JCEntryInfoEmptyFieldException;
import novell.jclient.JCException;
import novell.jclient.JCNetaddressValue;
import novell.jclient.JCNetworkAddress;
import novell.jclient.JCOctetstringValue;
import novell.jclient.JCPartitionInfo;
import novell.jclient.JCReadFilter;
import novell.jclient.JCReplicapointerValue;
import novell.jclient.JCTimestamp;
import novell.jclient.JCValue;
import novell.jclient.JClient;

public class NDSPartitionServiceImpl
implements NDSPartitionService {
    private ObjectEntry mytreeOE;
    private NDSNamespaceImpl myNS;
    private static boolean OneTimeForceMaster = false;

    public NDSPartitionServiceImpl(NDSNamespaceImpl ns2, ObjectEntry treeObjectEntry) {
        this.mytreeOE = treeObjectEntry;
        this.myNS = ns2;
    }

    public OperationStatus createPartition(ObjectEntry partObjEntry) throws SPIException {
        String partFDN = this.myNS.getUnrootedName(partObjEntry);
        NDSCreatePartitionThread partitionOperationT = new NDSCreatePartitionThread(this.myNS, this.mytreeOE.getName(), partFDN);
        partitionOperationT.setPriority(4);
        partitionOperationT.setDaemon(true);
        partitionOperationT.start();
        return new NDSPartitionOperationStatus(partObjEntry, this.mytreeOE.getName(), this.myNS, partitionOperationT);
    }

    public OperationStatus mergePartition(ObjectEntry partObjEntry) throws SPIException {
        String partFDN = this.myNS.getUnrootedName(partObjEntry);
        NDSMergePartitionThread partitionOperationT = new NDSMergePartitionThread(this.myNS, this.mytreeOE.getName(), partFDN);
        partitionOperationT.setPriority(4);
        partitionOperationT.setDaemon(true);
        partitionOperationT.start();
        return new NDSPartitionOperationStatus(partObjEntry, this.mytreeOE.getName(), this.myNS, partitionOperationT);
    }

    public void abortPartitionOperation(ObjectEntry oe) throws SPIException {
        JCContext repCtx = null;
        try {
            repCtx = this.myNS.getContext(oe, 8);
            JClient.abortPartitionOperation((JCContext)repCtx, (long)0L);
        }
        catch (Exception e) {
            throw this.myNS.resolveSPIException(e, "");
        }
        finally {
            if (repCtx != null) {
                repCtx.free();
            }
        }
    }

    public NDSPartitionInfo getPartitionInfo(ObjectEntry partOE) throws SPIException {
        JCContext partCtx = null;
        try {
            partCtx = this.myNS.getContext(partOE, 2);
            String serverConnectedToDN = partCtx.getServerName();
            Date lastSucSyncTime = new Date(0L);
            Date lastAttSyncTime = new Date(0L);
            NDSReplicaSyncInfo[] repSyncInfoArr = this.getSortedPartitionStatus(partCtx);
            boolean foundSuccess = false;
            boolean foundAttemptedWithError = false;
            for (int siidx = 0; siidx < repSyncInfoArr.length; ++siidx) {
                int siErrCode = repSyncInfoArr[siidx].getErrorCode();
                int siStatFlags = repSyncInfoArr[siidx].getStatusFlags();
                if (!(foundSuccess || siErrCode != 0 || siStatFlags != 2 && siStatFlags != 0)) {
                    lastSucSyncTime.setTime((long)repSyncInfoArr[siidx].getTimeStamp() * 1000L);
                    foundSuccess = true;
                    if (foundAttemptedWithError) break;
                    lastAttSyncTime.setTime((long)repSyncInfoArr[siidx].getTimeStamp() * 1000L);
                    foundAttemptedWithError = true;
                    break;
                }
                if (foundAttemptedWithError || siErrCode == 0) continue;
                lastAttSyncTime.setTime((long)repSyncInfoArr[siidx].getTimeStamp() * 1000L);
                foundAttemptedWithError = true;
            }
            NDSReplicaInfo[] repInfoArr = this.constructNDSReplicaInfo(partCtx, partOE, null);
            Vector<NDSReplicaInfo> repInfosVec = new Vector<NDSReplicaInfo>(repInfoArr.length);
            String mstrRepFDN = null;
            for (int ridx = 0; ridx < repInfoArr.length; ++ridx) {
                repInfosVec.add(repInfoArr[ridx]);
                int repType = repInfoArr[ridx].getReplicaType().getType();
                if (repType != 0) continue;
                mstrRepFDN = this.myNS.getUnrootedName(repInfoArr[ridx].getStoredOnServer());
            }
            String partDN = this.myNS.getUnrootedName(partOE);
            if (partDN.equals("")) {
                partDN = partOE.getRoot().getName();
            }
            NDSPartitionInfo nDSPartitionInfo = new NDSPartitionInfo(partDN, serverConnectedToDN, mstrRepFDN, lastSucSyncTime, lastAttSyncTime, repInfosVec);
            return nDSPartitionInfo;
        }
        catch (JCException e) {
            throw this.myNS.resolveSPIException((Exception)((Object)e), "");
        }
        finally {
            if (partCtx != null) {
                partCtx.free();
            }
        }
    }

    public Replica[] getPartitionReplicaList(ObjectEntry partOE, String serverToRead) throws SPIException {
        JCContext prtCtx = null;
        try {
            prtCtx = serverToRead != null ? this.myNS.getContext(partOE, 2, this.myNS.getObjectEntry(this.mytreeOE, serverToRead)) : this.myNS.getContext(partOE, OneTimeForceMaster ? 8 : 2);
            OneTimeForceMaster = false;
            Replica[] replicaArray = this.getPartitionReplicaList(prtCtx, partOE);
            return replicaArray;
        }
        catch (Exception e) {
            throw this.myNS.resolveSPIException(e, "");
        }
        finally {
            if (prtCtx != null) {
                prtCtx.free();
            }
        }
    }

    private Replica[] getPartitionReplicaList(JCContext resolvedPartitionCtx, ObjectEntry partitionOE) throws SPIException {
        Vector<NDSReplica> repList = new Vector<NDSReplica>();
        try {
            String[] repAttrStrings = new String[]{"Replica"};
            JCReadFilter repFilter = new JCReadFilter(false, new JCTimestamp(), repAttrStrings);
            JCValue[] repPtrValues = JClient.readEntry((JCContext)resolvedPartitionCtx, (long)1L, (JCReadFilter)repFilter);
            for (int rvIndex = 0; rvIndex < repPtrValues.length; ++rvIndex) {
                JCReplicapointerValue repValue = (JCReplicapointerValue)repPtrValues[rvIndex];
                ObjectEntry repServerStoredOnOE = this.myNS.getObjectEntry(partitionOE.getRoot(), repValue.getServerDN());
                int flags = repValue.getReplicaType();
                repList.addElement(new NDSReplica(partitionOE, repServerStoredOnOE, NDSReplicaType.getNDSReplicaType(flags & 0xFFFF), NDSReplicaState.getNDSReplicaState((flags & 0xFFFF0000) >>> 16)));
            }
        }
        catch (JCException e) {
            throw this.myNS.resolveSPIException((Exception)((Object)e), "");
        }
        Object[] replicaArr = new Replica[repList.size()];
        repList.copyInto(replicaArr);
        return replicaArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NDSReplicaInfo[] getDirectedPartitionReplicaList(ObjectEntry partitionOE, ObjectEntry serverOE) throws SPIException {
        JCContext prtCtx = null;
        try {
            prtCtx = serverOE != null ? this.myNS.getContext(partitionOE, 2, serverOE) : this.myNS.getContext(partitionOE, OneTimeForceMaster ? 8 : 2);
            OneTimeForceMaster = false;
            Replica[] directedServerList = this.getPartitionReplicaList(prtCtx, partitionOE);
            NDSReplicaInfo[] info = new NDSReplicaInfo[directedServerList.length];
            for (int i = 0; i < directedServerList.length; ++i) {
                JCContext directedPrtCtx = null;
                try {
                    directedPrtCtx = this.myNS.getContext(partitionOE, 2, directedServerList[i].getStoredOnServer());
                    NDSReplicaInfo[] reqRepInfo = this.constructNDSReplicaInfo(directedPrtCtx, partitionOE, directedServerList[i].getStoredOnServer());
                    if (reqRepInfo.length > 0) {
                        info[i] = reqRepInfo[0];
                        continue;
                    }
                    info[i] = null;
                    continue;
                }
                finally {
                    if (directedPrtCtx != null) {
                        directedPrtCtx.free();
                    }
                }
            }
            NDSReplicaInfo[] nDSReplicaInfoArray = info;
            return nDSReplicaInfoArray;
        }
        catch (Exception e) {
            throw this.myNS.resolveSPIException(e, "");
        }
        finally {
            if (prtCtx != null) {
                prtCtx.free();
            }
        }
    }

    public void receiveUpdates(ObjectEntry partObjEntry, String servFDN) throws SPIException {
    }

    public void sendUpdates(ObjectEntry partObjEntry, String servFDN) throws SPIException {
    }

    public void syncReplica(ObjectEntry partObjEntry, String servFDN) throws SPIException {
    }

    public Replica[] getServerPartitionList(ObjectEntry serverOE) throws SPIException {
        JCContext prtCtx2 = null;
        Vector<NDSReplica> repList = new Vector<NDSReplica>();
        Object[] replicas = null;
        JCContext prtCtx = null;
        try {
            ObjectEntry serverPartOE = this.myNS.getObjectEntry(serverOE.getRoot(), this.myNS.getUnrootedName(serverOE));
            prtCtx = this.myNS.getContext(serverOE, 2);
            prtCtx2 = prtCtx.duplicate();
            String[] attrStrings = new String[]{"Network Address"};
            JCReadFilter filter = new JCReadFilter(false, new JCTimestamp(), attrStrings);
            JCValue[] vals = JClient.readEntry((JCContext)prtCtx2, (long)1L, (JCReadFilter)filter);
            for (int index = 0; index < vals.length; ++index) {
                JCNetaddressValue netValue = (JCNetaddressValue)vals[index];
                if (9 != netValue.getAddress().getType()) continue;
                prtCtx2.connect(0L, netValue.getAddress());
                prtCtx2.authenticate();
                break;
            }
            JCPartitionInfo[] values = JClient.listPartitions((JCContext)prtCtx2, (long)1L, (String)this.myNS.getUnrootedName(serverOE));
            for (int index = 0; index < values.length; ++index) {
                ObjectEntry partOE;
                String partitionName = values[index].getPartitionDN();
                if (partitionName.equals("")) {
                    partOE = serverOE.getRoot();
                } else {
                    try {
                        partOE = this.myNS.getObjectEntry(serverOE.getRoot(), partitionName);
                    }
                    catch (SPIException spie) {
                        partOE = null;
                        String partSimpleName = partitionName;
                        Debug.out("Warning: Unable to create OE for " + partSimpleName + "  Trying to compensate");
                        Debug.out("    " + spie.toString());
                        try {
                            if (spie instanceof UniqueSPIException && ((UniqueSPIException)spie).getErrorCode() == -626) {
                                int dotPos;
                                ObjectEntry partParentOE = serverOE.getRoot();
                                String partContainerName = null;
                                int firstchkPos = 1;
                                while ((dotPos = partSimpleName.indexOf(46, firstchkPos)) > 0) {
                                    try {
                                        if (partSimpleName.charAt(dotPos - 1) != '\\') {
                                            partContainerName = partSimpleName.substring(dotPos + 1);
                                            partSimpleName = partSimpleName.substring(0, dotPos);
                                            break;
                                        }
                                        firstchkPos = dotPos + 1;
                                    }
                                    catch (IndexOutOfBoundsException iobe) {
                                        // empty catch block
                                        break;
                                    }
                                }
                                if (partContainerName != null) {
                                    partParentOE = this.myNS.getObjectEntry(partParentOE, partContainerName);
                                }
                                ObjectType partObjectType = this.myNS.getObjectType(partParentOE, "Unknown");
                                partOE = new ObjectEntry(partSimpleName, partObjectType, partParentOE, 4L);
                            } else {
                                Debug.out("Unable to compensate - ignoring ");
                            }
                        }
                        catch (Exception ee) {
                            Debug.out("Unable to compensate - ignoring because of following additional error:");
                            Debug.out("    " + ee.toString());
                        }
                    }
                }
                if (partOE == null) continue;
                repList.addElement(new NDSReplica(partOE, serverPartOE, NDSReplicaType.getNDSReplicaType(values[index].getReplicaType() & 0xFFFF), NDSReplicaState.getNDSReplicaState(values[index].getReplicaState())));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw this.myNS.resolveSPIException(e, "");
        }
        finally {
            if (prtCtx2 != null) {
                prtCtx2.free();
            }
            if (prtCtx != null) {
                prtCtx.free();
            }
        }
        replicas = new Replica[repList.size()];
        repList.copyInto(replicas);
        return replicas;
    }

    public int getNumberOfReplicasOnServer(ObjectEntry servObjEntry) throws SPIException {
        int num;
        JCContext partContext = null;
        try {
            partContext = this.myNS.getContext(servObjEntry, 2);
            JCPartitionInfo[] partInfo = JClient.listPartitions((JCContext)partContext, (long)1L, (String)this.myNS.getUnrootedName(servObjEntry));
            num = partInfo.length;
        }
        catch (JCException e) {
            throw this.myNS.resolveSPIException((Exception)((Object)e), "");
        }
        finally {
            if (partContext != null) {
                partContext.free();
            }
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPartitionRoot(ObjectEntry oe) throws SPIException {
        JCContext myPartContext = null;
        try {
            myPartContext = this.myNS.getContext(oe, 2);
            JCEntryInfo entry = JClient.getEntryInfo((JCContext)myPartContext, (int)16384);
            String partitionRoot = entry.getPartitionRootDN().toString();
            String string = partitionRoot.equals("") ? oe.getRoot().getName() : partitionRoot;
            return string;
        }
        catch (JCException e) {
            throw this.myNS.resolveSPIException((Exception)((Object)e), "");
        }
        catch (JCEntryInfoEmptyFieldException jCEntryInfoEmptyFieldException) {
        }
        finally {
            if (myPartContext != null) {
                myPartContext.free();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPartition(ObjectEntry oe) throws SPIException {
        JCContext myPartContext = null;
        try {
            myPartContext = this.myNS.getContext(oe, 2);
            JCEntryInfo entry = JClient.getEntryInfo((JCContext)myPartContext, (int)4);
            boolean bl = (entry.getEntryFlags() & 2) > 0;
            return bl;
        }
        catch (JCException e) {
            throw this.myNS.resolveSPIException((Exception)((Object)e), "");
        }
        catch (JCEntryInfoEmptyFieldException jCEntryInfoEmptyFieldException) {
        }
        finally {
            if (myPartContext != null) {
                myPartContext.free();
            }
        }
        return false;
    }

    public OperationStatus createReplica(ObjectEntry oe, String servFDN, int type) throws SPIException {
        JCContext prtCtx = null;
        try {
            prtCtx = this.myNS.getContext(oe, 8);
            JClient.addReplica((JCContext)prtCtx, (long)1L, (String)servFDN, (int)type);
            OneTimeForceMaster = true;
        }
        catch (JCException e) {
            throw this.myNS.resolveSPIException((Exception)((Object)e), "");
        }
        finally {
            if (prtCtx != null) {
                prtCtx.free();
            }
        }
        return new NDSReplicaOperationStatus(1);
    }

    public OperationStatus deleteReplica(ObjectEntry oe, String servFDN) throws SPIException {
        JCContext prtCtx = null;
        try {
            prtCtx = this.myNS.getContext(oe, 8);
            JClient.removeReplica((JCContext)prtCtx, (long)1L, (String)servFDN);
            OneTimeForceMaster = true;
        }
        catch (JCException e) {
            throw this.myNS.resolveSPIException((Exception)((Object)e), "");
        }
        finally {
            if (prtCtx != null) {
                prtCtx.free();
            }
        }
        return new NDSReplicaOperationStatus(1);
    }

    public OperationStatus changeReplicaType(ObjectEntry oe, String servFDN, int type) throws SPIException {
        JCContext prtCtx = null;
        try {
            prtCtx = this.myNS.getContext(oe, 8);
            JClient.changeReplicaType((JCContext)prtCtx, (long)1L, (String)servFDN, (int)type);
            OneTimeForceMaster = true;
        }
        catch (JCException e) {
            throw this.myNS.resolveSPIException((Exception)((Object)e), "");
        }
        finally {
            if (prtCtx != null) {
                prtCtx.free();
            }
        }
        return new NDSReplicaOperationStatus(1);
    }

    public NDSReplicaInfo getReplicaInfo(NDSReplica replica, String unusedParam) throws SPIException {
        return this.getReplicaInfo(replica.getPartition(), replica.getStoredOnServer(), null);
    }

    public NDSReplicaInfo getReplicaInfo(ObjectEntry partitionOE, ObjectEntry serverStoredOnOE) throws SPIException {
        return this.getReplicaInfo(partitionOE, serverStoredOnOE, null);
    }

    public NDSReplicaInfo getReplicaInfo(ObjectEntry partitionOE, ObjectEntry serverStoredOnOE, ObjectEntry serverToReadOE) throws SPIException {
        JCContext partContext = null;
        try {
            partContext = serverToReadOE != null ? this.myNS.getContext(partitionOE, 2, serverToReadOE) : this.myNS.getContext(partitionOE, OneTimeForceMaster ? 8 : 2);
            OneTimeForceMaster = false;
            NDSReplicaInfo[] reqRepInfo = this.constructNDSReplicaInfo(partContext, partitionOE, serverStoredOnOE);
            if (reqRepInfo.length > 0) {
                NDSReplicaInfo nDSReplicaInfo = reqRepInfo[0];
                return nDSReplicaInfo;
            }
            NDSReplicaInfo nDSReplicaInfo = null;
            return nDSReplicaInfo;
        }
        catch (Exception e) {
            throw this.myNS.resolveSPIException(e, "");
        }
        finally {
            if (partContext != null) {
                partContext.free();
            }
        }
    }

    private NDSReplicaInfo[] constructNDSReplicaInfo(JCContext resolvedPartitionCtx, ObjectEntry partitionOE, ObjectEntry requestedServerStoredOnOE) throws SPIException {
        try {
            String requestedServerStoredOnDN;
            int replicaInfoCount;
            String serverConnectedToDN = resolvedPartitionCtx.getServerName();
            NDSReplicaSyncInfo[] repSyncInfoArr = this.getSortedPartitionStatus(resolvedPartitionCtx);
            String[] repAttrStrings = new String[]{"Replica"};
            JCReadFilter repFilter = new JCReadFilter(false, new JCTimestamp(), repAttrStrings);
            JCValue[] repPtrValues = JClient.readEntry((JCContext)resolvedPartitionCtx, (long)1L, (JCReadFilter)repFilter);
            int n = replicaInfoCount = requestedServerStoredOnOE == null ? repPtrValues.length : 1;
            if (requestedServerStoredOnOE == null) {
                replicaInfoCount = repPtrValues.length;
                requestedServerStoredOnDN = null;
            } else {
                replicaInfoCount = 1;
                requestedServerStoredOnDN = this.myNS.getUnrootedName(requestedServerStoredOnOE);
            }
            NDSReplicaInfo[] replicaInfoArr = new NDSReplicaInfo[replicaInfoCount];
            int riaIndex = 0;
            for (int rpidx = 0; rpidx < repPtrValues.length; ++rpidx) {
                JCReplicapointerValue repValToUse = (JCReplicapointerValue)repPtrValues[rpidx];
                String tmpServerStoredOnDN = repValToUse.getServerDN();
                if (requestedServerStoredOnDN != null && !requestedServerStoredOnDN.equalsIgnoreCase(tmpServerStoredOnDN)) continue;
                ObjectEntry tmpServerStoredOnOE = requestedServerStoredOnDN == null ? this.myNS.getObjectEntry(this.mytreeOE, tmpServerStoredOnDN) : requestedServerStoredOnOE;
                Vector<Object> serverStoredOnRefAddrVec = new Vector<Object>();
                JCNetworkAddress[] jcnetAddresses = repValToUse.getReferral().getReferral();
                for (int jcaidx = 0; jcaidx < jcnetAddresses.length; ++jcaidx) {
                    ValueList refValList = NetAddressFacade.createValueList(jcnetAddresses[jcaidx].getType(), jcnetAddresses[jcaidx].getAddress());
                    serverStoredOnRefAddrVec.addElement(refValList.createFacade());
                }
                int repTypeAndState = repValToUse.getReplicaType();
                NDSReplicaType repType = NDSReplicaType.getNDSReplicaType(repTypeAndState & 0xFFFF);
                NDSReplicaState repState = NDSReplicaState.getNDSReplicaState((repTypeAndState & 0xFFFF0000) >>> 16);
                Date repLastSuccessfulTimeSync = new Date(0L);
                int repSyncErrorCode = 0;
                for (int rsiIndex = 0; rsiIndex < repSyncInfoArr.length; ++rsiIndex) {
                    int siErrCode = repSyncInfoArr[rsiIndex].getErrorCode();
                    String siServerName = repSyncInfoArr[rsiIndex].getServerName();
                    int siStatFlags = repSyncInfoArr[rsiIndex].getStatusFlags();
                    if ((siErrCode == 0 || siServerName == null || !siServerName.equalsIgnoreCase(tmpServerStoredOnDN)) && (siStatFlags != 0 && siStatFlags != 2 || siServerName != null && !siServerName.equalsIgnoreCase(tmpServerStoredOnDN))) continue;
                    repLastSuccessfulTimeSync.setTime((long)repSyncInfoArr[rsiIndex].getTimeStamp() * 1000L);
                    repSyncErrorCode = siErrCode;
                    break;
                }
                replicaInfoArr[riaIndex] = new NDSReplicaInfo(partitionOE, tmpServerStoredOnOE, serverConnectedToDN, repValToUse.getReplicaNumber(), repType, repState, repLastSuccessfulTimeSync, serverStoredOnRefAddrVec, repSyncErrorCode);
                if (requestedServerStoredOnDN != null) break;
                ++riaIndex;
            }
            return replicaInfoArr;
        }
        catch (JCException e) {
            throw this.myNS.resolveSPIException((Exception)((Object)e), "");
        }
    }

    private NDSReplicaSyncInfo[] getSortedPartitionStatus(JCContext resolvedPartitionCtx) throws SPIException {
        String[] attrStrings = new String[]{"Partition Status"};
        JCReadFilter filter = new JCReadFilter(false, new JCTimestamp(), attrStrings);
        JCValue[] partStatVals = new JCValue[]{};
        try {
            partStatVals = JClient.readEntry((JCContext)resolvedPartitionCtx, (long)1L, (JCReadFilter)filter);
        }
        catch (JCException e) {
            Debug.out("Error reading Partition Status Attribute: " + e.toString());
            throw this.myNS.resolveSPIException((Exception)((Object)e), "");
        }
        NDSReplicaSyncInfo[] replicaSyncInfoArr = new NDSReplicaSyncInfo[partStatVals.length];
        for (int psvIndex = 0; psvIndex < partStatVals.length; ++psvIndex) {
            try {
                replicaSyncInfoArr[psvIndex] = new NDSReplicaSyncInfo(((JCOctetstringValue)partStatVals[psvIndex]).getOctets());
                continue;
            }
            catch (IOException e) {
                Debug.out("Error parsing the Partition Status attribute into a NDSReplicaSyncInfo: " + e.toString());
                throw this.myNS.resolveSPIException(e, "");
            }
        }
        Arrays.sort(replicaSyncInfoArr, new Comparator(){

            public int compare(Object a, Object b) {
                int bstatus;
                int btime;
                int atime = ((NDSReplicaSyncInfo)a).getTimeStamp();
                if (atime > (btime = ((NDSReplicaSyncInfo)b).getTimeStamp())) {
                    return -1;
                }
                if (btime > atime) {
                    return 1;
                }
                int astatus = ((NDSReplicaSyncInfo)a).getStatusFlags();
                if (astatus > (bstatus = ((NDSReplicaSyncInfo)b).getStatusFlags())) {
                    return -1;
                }
                if (bstatus > astatus) {
                    return 1;
                }
                return 0;
            }

            public boolean equals(Object a) {
                return a == this;
            }
        });
        return replicaSyncInfoArr;
    }

    public Date getUTCTime(ObjectEntry partObjEntry) throws SPIException {
        return new Date();
    }
}

