/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds.jclient;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.NSFileObject;
import com.novell.admin.ns.NSFileTrustee;

public class NSFileObjectImpl
implements NSFileObject {
    private String m_fullBackslashedName;
    private int m_type;
    private NSFileTrustee[] m_fileTrusteearr = null;
    private boolean m_junctionFile;

    public NSFileObjectImpl(String name, int type) {
        this.m_setName(name);
        this.m_setType(type);
    }

    public String getName() throws SPIException {
        return this.m_fullBackslashedName;
    }

    public String getNameBackslashed() throws SPIException {
        return this.m_fullBackslashedName;
    }

    public String getNameForwardslashed() throws SPIException {
        return this.m_fullBackslashedName.replace('\\', '/');
    }

    public String[] getDirNameBaseNameBackslashed() throws SPIException {
        return this.parseDirNameBaseName(this.m_fullBackslashedName, '\\');
    }

    public String[] getDirNameBaseNameForwardslashed() throws SPIException {
        return this.parseDirNameBaseName(this.getNameForwardslashed(), '/');
    }

    public int getType() throws SPIException {
        return this.m_type;
    }

    void setType(int type) throws SPIException {
        this.m_setType(type);
    }

    public NSFileTrustee[] getTrustees() throws SPIException {
        if (this.m_fileTrusteearr == null) {
            this.m_fileTrusteearr = new NSFileTrustee[0];
        }
        return this.m_fileTrusteearr;
    }

    void setTrustees(NSFileTrustee[] fileTrustees) throws SPIException {
        this.m_fileTrusteearr = fileTrustees;
    }

    public boolean isJunctionFile() {
        return this.m_junctionFile;
    }

    void setJunctionFile(boolean junctionFile) {
        this.m_junctionFile = junctionFile;
    }

    private void m_setName(String inputName) {
        if (inputName == null) {
            this.m_fullBackslashedName = "";
        } else {
            this.m_fullBackslashedName = inputName.replace('/', '\\');
            int slen = this.m_fullBackslashedName.length();
            if (slen == 0) {
                this.m_fullBackslashedName = inputName;
            } else if (this.m_fullBackslashedName.charAt(slen - 1) == '\\') {
                int startPos = 0;
                if (this.m_fullBackslashedName.charAt(0) == '\\' && slen > 1) {
                    startPos = 1;
                }
                this.m_fullBackslashedName = this.m_fullBackslashedName.substring(startPos, slen - 1);
            } else if (this.m_fullBackslashedName.charAt(0) == '\\') {
                this.m_fullBackslashedName = this.m_fullBackslashedName.substring(1);
            }
        }
    }

    private void m_setType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.m_type = type;
                break;
            }
            default: {
                this.m_type = 0;
            }
        }
    }

    private String[] parseDirNameBaseName(String nameToParse, char slashChar) {
        String[] retStrArr = new String[2];
        int lastSlash = nameToParse.lastIndexOf(slashChar);
        if (lastSlash >= 0) {
            retStrArr[0] = nameToParse.substring(0, lastSlash);
            retStrArr[1] = nameToParse.substring(lastSlash + 1);
        } else {
            retStrArr[0] = "";
            retStrArr[1] = nameToParse;
        }
        return retStrArr;
    }
}

