/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds.jclient;

import com.novell.admin.ns.nds.jclient.BrowserObjectEntryEnumerationImpl;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.SnapinException;
import com.novell.application.console.snapin.VirtualObjectEntryEnumeration;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import novell.jclient.JCEntryData;
import novell.jclient.JCException;

public class VirtualObjectEntryEnumerationImpl
extends BrowserObjectEntryEnumerationImpl
implements Enumeration,
VirtualObjectEntryEnumeration {
    private BrowserObjectEntryEnumerationImpl browserEnumeration;
    private static final int lastEntryPosition = 1000;

    public VirtualObjectEntryEnumerationImpl(BrowserObjectEntryEnumerationImpl bEnumeration) throws JCException {
        super(bEnumeration);
        this.browserEnumeration = bEnumeration;
        this.childOECache.setLastPosition(this.getPosition());
    }

    public int moveTo(int position) throws SnapinException {
        if (position == 0 && this.childOECache.getFirstPosition() == 0) {
            this.desiredIndex = this.childOECache.getFirstIndex();
            return position;
        }
        try {
            this.iterator.setPosition(position, 0);
            this.needToGetCurrentObject = true;
            this.desiredIndex = 0;
            this.iteratorAtEnd = true;
            position = this.getPosition();
            int currentPosition = this.getCurrentPosition();
            if (currentPosition == -2) {
                currentPosition = 1001;
            }
            this.centerCacheAroundPosition(position, currentPosition);
        }
        catch (Exception x) {
            throw this.resolveSPIException(x);
        }
        return position;
    }

    public int moveTo(String target) throws SnapinException {
        int position = 0;
        try {
            this.iterator.setPosition("CN", target, 0);
            this.needToGetCurrentObject = true;
            this.desiredIndex = 0;
            this.iteratorAtEnd = true;
            position = this.getPosition();
            int currentPosition = this.getCurrentPosition();
            if (currentPosition == -2) {
                currentPosition = 1001;
            }
            this.centerCacheAroundPosition(position, currentPosition);
        }
        catch (Exception x) {
            throw this.resolveSPIException(x);
        }
        if (position > 0) {
            --this.desiredIndex;
        }
        return position;
    }

    public int moveLeft(int count) throws SnapinException {
        ObjectEntry[] entries;
        try {
            entries = this.getNextElements(count, true);
        }
        catch (NoSuchElementException x) {
            entries = new ObjectEntry[]{};
        }
        catch (Exception x) {
            throw this.resolveSPIException(x);
        }
        return entries.length;
    }

    public int moveRight(int count) throws SnapinException {
        ObjectEntry[] entries;
        try {
            entries = this.getNextElements(count, false);
        }
        catch (NoSuchElementException x) {
            entries = new ObjectEntry[]{};
        }
        catch (Exception x) {
            throw this.resolveSPIException(x);
        }
        return entries.length;
    }

    public ObjectEntry[] getNext(int count) throws SnapinException {
        ObjectEntry[] entries;
        try {
            entries = this.getNextElements(count, false);
        }
        catch (NoSuchElementException x) {
            entries = new ObjectEntry[]{};
        }
        catch (Exception x) {
            throw this.resolveSPIException(x);
        }
        return entries;
    }

    public ObjectEntry[] getPrev(int count) throws SnapinException {
        ObjectEntry[] entries;
        try {
            entries = this.getNextElements(count, true);
        }
        catch (NoSuchElementException x) {
            entries = new ObjectEntry[]{};
        }
        catch (Exception x) {
            throw this.resolveSPIException(x);
        }
        return entries;
    }

    public int getCurrentPosition() {
        int position = this.childOECache.getPosition(this.desiredIndex);
        if (position == 1001) {
            position = -2;
        }
        return position;
    }

    public int getCount() throws SnapinException {
        int count = super.getCount();
        if (count == -1) {
            count = this.childOECache.getApproximateCount();
        }
        return count;
    }

    public int getCountReliability() {
        return super.getCountReliability();
    }

    long getCount(int maxCount) {
        try {
            return this.iterator.count((long)maxCount, 0);
        }
        catch (JCException x) {
            return -1L;
        }
    }

    public int getLastEntryPosition() {
        return 1000;
    }

    private void centerCacheAroundPosition(int newPosition, int previousPosition) throws JCException {
        this.childOECache.reset(new Object[0], 0, 0);
        if (newPosition == 0) {
            try {
                this.getNextElementsFromWireAndCache(this.cacheSize, false);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.desiredIndex = this.childOECache.getFirstIndex();
        } else if (newPosition == 1000) {
            try {
                this.iterator.skip((long)(1 - this.cacheSize), 0);
                this.getNextElementsFromWireAndCache(this.cacheSize, false);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.desiredIndex = this.childOECache.getLastIndex();
        } else if (previousPosition < newPosition) {
            long itemsSkipped = 0 - this.entryTwoFifthsSlice;
            try {
                itemsSkipped = this.iterator.skip((long)(0 - this.entryTwoFifthsSlice), 0);
                this.getNextElementsFromWireAndCache(this.cacheSize, false);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.desiredIndex = this.entryTwoFifthsSlice - (this.entryTwoFifthsSlice + (int)itemsSkipped) + 1;
        } else {
            long itemsSkipped = 0 - this.entryThreeFifthsSlice;
            try {
                itemsSkipped = this.iterator.skip((long)(0 - this.entryThreeFifthsSlice), 0);
                this.getNextElementsFromWireAndCache(this.cacheSize, false);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.desiredIndex = this.entryThreeFifthsSlice - (this.entryThreeFifthsSlice + (int)itemsSkipped) + 1;
        }
    }

    protected synchronized ObjectEntry[] getNextElementsFromWireAndCache(int numberOfElements, boolean reverse) throws NoSuchElementException, JCException {
        JCEntryData[] entryArray;
        int firstCachePosition;
        Object[] entries = null;
        if (reverse) {
            if (this.iteratorAtEnd) {
                this.iterator.skip((long)(0 - this.childOECache.getSize()), 0);
            }
            this.iteratorAtEnd = false;
            firstCachePosition = this.getPosition();
            entryArray = this.iterator.previous(numberOfElements, 0);
            this.needToGetCurrentObject = true;
        } else {
            if (!this.iteratorAtEnd) {
                this.iterator.skip((long)this.childOECache.getSize(), 0);
            }
            this.iteratorAtEnd = true;
            firstCachePosition = this.getPosition();
            if (this.needToGetCurrentObject) {
                entryArray = this.browserEnumeration.iteratorGetNext(numberOfElements);
                this.needToGetCurrentObject = false;
            } else {
                entryArray = this.iterator.next(numberOfElements, 0);
            }
        }
        entries = this.crackTheEntries(entryArray);
        if (entries.length == 0) {
            throw new NoSuchElementException();
        }
        if (reverse) {
            this.childOECache.prepend(entries, this.getPosition(), firstCachePosition);
        } else {
            int lastPosition = this.getPosition() - 1;
            if (lastPosition < 0) {
                lastPosition = 0;
            }
            if (this.childOECache.getSize() != 0) {
                this.childOECache.append(entries, firstCachePosition, lastPosition);
            } else {
                this.childOECache.reset(entries, firstCachePosition, lastPosition);
            }
        }
        return entries;
    }

    private int getPosition() {
        int position = 0;
        try {
            position = this.iterator.getPosition(0);
        }
        catch (JCException x) {
            position = 0;
        }
        return position;
    }
}

