/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.snapin;

import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.Debug;
import com.novell.application.console.snapin.NamespaceSnapin;
import com.novell.application.console.snapin.ObjectEntryParentAndSimpleName;
import com.novell.application.console.snapin.ObjectType;
import java.io.Serializable;
import java.util.Vector;

public class ObjectEntry
implements Serializable {
    private String m_simpleName;
    private String m_asIsComplexName;
    private ObjectType m_objectType;
    private ObjectType[] m_subTypes;
    private ObjectEntry m_asIsParent;
    private long m_objectFlags;
    private int m_subordinateCount;

    public ObjectEntry(String name, ObjectType type) {
        Debug.n_assert(name != null && type != null);
        this.m_simpleName = name;
        this.m_asIsComplexName = null;
        this.m_objectType = type;
        this.m_subTypes = new ObjectType[0];
        this.m_asIsParent = null;
        this.m_objectFlags = 0L;
        this.m_subordinateCount = -1;
    }

    public ObjectEntry(String name, ObjectType type, long objectFlags) {
        Debug.n_assert(name != null && type != null);
        this.m_simpleName = name;
        this.m_asIsComplexName = null;
        this.m_objectType = type;
        this.m_subTypes = new ObjectType[0];
        this.m_asIsParent = null;
        this.m_objectFlags = objectFlags;
        this.m_subordinateCount = -1;
    }

    public ObjectEntry(String name, ObjectType type, ObjectEntry parent) {
        Debug.n_assert(name != null && type != null);
        this.m_simpleName = name;
        this.m_asIsComplexName = null;
        this.m_objectType = type;
        this.m_subTypes = new ObjectType[0];
        this.m_asIsParent = parent;
        this.m_objectFlags = 0L;
        this.m_subordinateCount = -1;
    }

    public ObjectEntry(String name, ObjectType type, ObjectEntry parent, long objectFlags) {
        Debug.n_assert(name != null && type != null);
        this.m_simpleName = name;
        this.m_asIsComplexName = null;
        this.m_objectType = type;
        this.m_subTypes = new ObjectType[0];
        this.m_asIsParent = parent;
        this.m_objectFlags = objectFlags;
        this.m_subordinateCount = -1;
    }

    public ObjectEntry(String oeName, ObjectType oeType, ObjectEntry parent, long objectFlags, boolean nameMayBeComplex) {
        block7: {
            int delimPos;
            block8: {
                int simpleNamePos;
                Debug.n_assert(oeName != null && oeType != null);
                this.m_simpleName = oeName;
                this.m_asIsComplexName = null;
                this.m_objectType = oeType;
                this.m_subTypes = new ObjectType[0];
                this.m_asIsParent = parent;
                this.m_objectFlags = objectFlags;
                this.m_subordinateCount = -1;
                if (!nameMayBeComplex) break block7;
                if (!oeType.isFileSystem()) break block8;
                for (simpleNamePos = oeName.length() - 1; simpleNamePos >= 0 && oeName.charAt(simpleNamePos) != '\\' && oeName.charAt(simpleNamePos) != '/' && oeName.charAt(simpleNamePos) != ':'; --simpleNamePos) {
                }
                if (simpleNamePos < 0) break block7;
                this.m_simpleName = oeName.substring(simpleNamePos + 1);
                this.m_asIsComplexName = oeName;
                break block7;
            }
            if (oeName.length() == 0 && parent != null) {
                this.m_simpleName = parent.m_simpleName;
                this.m_asIsComplexName = parent.m_asIsComplexName;
                this.m_asIsParent = parent.m_asIsParent;
                return;
            }
            int delim = 46;
            if (oeType.getNamespace().getUniqueID().equals("LDAP")) {
                delim = 44;
            }
            int firstchkPos = 1;
            while ((delimPos = oeName.indexOf(delim, firstchkPos)) > 0) {
                try {
                    if (oeName.charAt(delimPos - 1) != '\\') {
                        this.m_simpleName = oeName.substring(0, delimPos);
                        this.m_asIsComplexName = oeName;
                        break;
                    }
                    firstchkPos = delimPos + 1;
                }
                catch (IndexOutOfBoundsException iobe) {
                    break;
                }
            }
        }
    }

    public void setSubTypes(ObjectType[] types) {
        this.m_subTypes = types;
    }

    public ObjectType[] getSubTypes() {
        return this.m_subTypes;
    }

    public void addSubType(ObjectType type) {
        Debug.n_assert(type != null);
        if (type != null) {
            ObjectType[] newSubs = new ObjectType[this.m_subTypes.length + 1];
            for (int i = 0; i < this.m_subTypes.length; ++i) {
                newSubs[i] = this.m_subTypes[i];
            }
            newSubs[newSubs.length - 1] = type;
            this.m_subTypes = newSubs;
        }
    }

    public boolean removeSubType(ObjectType type) {
        Debug.n_assert(type != null && this.m_subTypes.length > 0);
        boolean found = false;
        if (type != null && this.m_subTypes.length > 0) {
            int i;
            Vector<ObjectType> newSubs = new Vector<ObjectType>();
            for (i = 0; i < this.m_subTypes.length; ++i) {
                if (!this.m_subTypes[i].equals(type)) {
                    newSubs.addElement(this.m_subTypes[i]);
                    continue;
                }
                found = true;
            }
            this.m_subTypes = new ObjectType[newSubs.size()];
            for (i = 0; i < this.m_subTypes.length; ++i) {
                this.m_subTypes[i] = (ObjectType)newSubs.elementAt(i);
            }
        }
        return found;
    }

    public String getName() {
        return this.m_simpleName;
    }

    public String getAsIsName() {
        if (this.m_asIsComplexName != null) {
            return this.m_asIsComplexName;
        }
        return this.m_simpleName;
    }

    public boolean isComplexName() {
        return this.m_asIsComplexName != null;
    }

    public String getFullName() {
        return this.m_objectType.getNamespace().getFullName(this);
    }

    public ObjectType getObjectType() {
        return this.m_objectType;
    }

    public long getObjectFlags() {
        return this.m_objectFlags;
    }

    public synchronized void setObjectFlags(long objectFlags) {
        this.m_objectFlags = objectFlags;
    }

    public ObjectEntry getParent() {
        if (this.m_asIsComplexName != null) {
            try {
                AdminNamespace ns2 = this.getAdminNamespace();
                ObjectEntryParentAndSimpleName parentAndName = ns2.getParentAndSimpleName(this);
                if (parentAndName != null) {
                    this.m_simpleName = parentAndName.getSimpleName();
                    this.m_asIsParent = parentAndName.getParentOE();
                    this.m_asIsComplexName = null;
                } else {
                    Debug.n_assert(false, this, "Unable to getParentAndSimpleName()");
                    Debug.out("Unable to getParentAndSimpleName()");
                }
            }
            catch (Exception e) {
                Debug.reportSnapinError(e);
                Debug.out("  Exception: " + e.toString() + "\n");
            }
        }
        return this.m_asIsParent;
    }

    public ObjectEntry getAsIsParent() {
        return this.m_asIsParent;
    }

    public ObjectEntry getRoot() {
        String thisNamespace = this.m_objectType.getNamespace().getUniqueID();
        ObjectEntry oe = this;
        ObjectEntry theAsIsParent = this.getAsIsParent();
        while (theAsIsParent != null && theAsIsParent.getObjectType().getNamespace().getUniqueID().equals(thisNamespace)) {
            oe = theAsIsParent;
            theAsIsParent = oe.getAsIsParent();
        }
        return oe;
    }

    public boolean equals(Object object) {
        String name2;
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof ObjectEntry)) {
            return false;
        }
        ObjectEntry oe = (ObjectEntry)object;
        if (!this.m_simpleName.equals(oe.getName())) {
            return false;
        }
        ObjectType type2 = oe.getObjectType();
        if (!this.m_objectType.equals(type2)) {
            return false;
        }
        String name1 = this.m_objectType.getNamespace().getFullName(this);
        if (name1 == null) {
            name1 = this.m_asIsComplexName != null ? this.m_asIsComplexName : this.m_simpleName;
        }
        if ((name2 = type2.getNamespace().getFullName(oe)) == null) {
            name2 = oe.getAsIsName();
        }
        return name1.equals(name2);
    }

    public boolean equalsIgnoreCase(Object object) {
        String name2;
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof ObjectEntry)) {
            return false;
        }
        ObjectEntry oe = (ObjectEntry)object;
        if (!this.m_simpleName.equalsIgnoreCase(oe.getName())) {
            return false;
        }
        ObjectType type2 = oe.getObjectType();
        if (!this.m_objectType.equals(type2)) {
            return false;
        }
        String name1 = this.m_objectType.getNamespace().getFullName(this);
        if (name1 == null) {
            name1 = this.m_asIsComplexName != null ? this.m_asIsComplexName : this.m_simpleName;
        }
        if ((name2 = type2.getNamespace().getFullName(oe)) == null) {
            name2 = oe.getAsIsName();
        }
        return name1.equalsIgnoreCase(name2);
    }

    public int hashCode() {
        int h = this.m_objectType.getName().hashCode() & 0xFF;
        h = (h << 24) + (this.m_simpleName.hashCode() & 0xFFFFFF);
        return h;
    }

    public String toString() {
        return this.m_simpleName;
    }

    public String getTypeName() {
        return this.m_objectType.getName();
    }

    public String getNamespaceUniqueID() {
        return this.m_objectType.getNamespace().getUniqueID();
    }

    public NamespaceSnapin getNamespace() {
        return this.m_objectType.getNamespace();
    }

    public AdminNamespace getAdminNamespace() {
        return this.m_objectType.getAdminNamespace();
    }

    public int getSubordinateCount() {
        return this.m_subordinateCount;
    }

    public void setSubordinateCount(int count) {
        this.m_subordinateCount = count;
    }

    public ObjectType[] getObjectTypes() {
        return new ObjectType[]{this.m_objectType};
    }
}

