/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.snapin;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.SchemaUtil;
import com.novell.application.console.snapin.ResultModifierFilterEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;

public class ResultModifier
implements Serializable {
    private boolean showInheritedSubClasses = false;
    private boolean showAuxAndSubClasses = false;
    private boolean useSimpleAndOpAdvanced = false;
    private boolean showGlue = false;
    private int allowFileSystemBrowse = 0;
    public static final int ALLOWFILESYSTEMBROWSE_NONE = 0;
    public static final int ALLOWFILESYSTEMBROWSE_VOLUME = 1;
    public static final int ALLOWFILESYSTEMBROWSE_NCPSERVER = 2;
    public static final int SORTBY_KEY_UNSORTED = 0;
    public static final int SORTBY_KEY_TYPE = 1;
    public static final int SORTBY_KEY_NAME = 2;
    public static final int SORTBY_KEY_TYPE_NAME = 3;
    public static final int SORTORDER_KEY_ASCENDING = 0;
    public static final int SORTORDER_KEY_DECENDING = 1;
    public static final int BLOCK_KEY_NORMAL = 0;
    public static final int BLOCK_KEY_SHOW_BLOCKED_OBJECTS = 1;
    private String m_descriptiveName = null;
    private int m_sortByKey = 3;
    private int m_sortOrderKey = 0;
    private boolean m_subContainerSearch = false;
    private int m_blockKey = 0;
    private Vector RMFEfilters = new Vector();

    public ResultModifier(String descriptiveName) {
        this.m_descriptiveName = descriptiveName;
    }

    public ResultModifier(String descriptiveName, int sortByKey, int sortOrderKey, ResultModifierFilterEntry filterEntry) {
        this.m_descriptiveName = descriptiveName;
        this.m_sortByKey = sortByKey;
        this.m_sortOrderKey = sortOrderKey;
        this.m_subContainerSearch = false;
        this.addFilter(filterEntry);
    }

    public ResultModifier(String descriptiveName, int sortByKey, int sortOrderKey, ResultModifierFilterEntry filterEntry, boolean subContainerSearch) {
        this.m_descriptiveName = descriptiveName;
        this.m_sortByKey = sortByKey;
        this.m_sortOrderKey = sortOrderKey;
        this.m_subContainerSearch = subContainerSearch;
        this.addFilter(filterEntry);
    }

    public ResultModifier(String descriptiveName, int sortByKey, int sortOrderKey, ResultModifierFilterEntry filterEntry, boolean subContainerSearch, boolean subClasses) {
        this.m_descriptiveName = descriptiveName;
        this.m_sortByKey = sortByKey;
        this.m_sortOrderKey = sortOrderKey;
        this.m_subContainerSearch = subContainerSearch;
        this.showInheritedSubClasses = subClasses;
        this.addFilter(filterEntry);
    }

    public ResultModifier(int blockKey) {
        this.m_blockKey = blockKey;
    }

    public boolean equals(Object obj) {
        ResultModifierFilterEntry[] candidateFilters;
        if (!(obj instanceof ResultModifier)) {
            return false;
        }
        ResultModifier rm = (ResultModifier)obj;
        if (this == rm) {
            return true;
        }
        if (this.m_sortByKey != rm.getSortByKey() || this.m_sortOrderKey != rm.getSortOrderKey()) {
            return false;
        }
        int thisLength = this.RMFEfilters.size();
        if (thisLength != (candidateFilters = rm.getFilters()).length) {
            return false;
        }
        for (int k = 0; k < thisLength; ++k) {
            if (candidateFilters[k].equals(this.RMFEfilters.elementAt(k))) continue;
            return false;
        }
        return true;
    }

    public String getDescriptiveName() {
        return this.m_descriptiveName;
    }

    public void setSortByKey(int sortByKey) {
        this.m_sortByKey = sortByKey;
    }

    public int getSortByKey() {
        return this.m_sortByKey;
    }

    public void setSortOrderKey(int sortOrderKey) {
        this.m_sortOrderKey = sortOrderKey;
    }

    public int getSortOrderKey() {
        return this.m_sortOrderKey;
    }

    public boolean isSubContainerSearch() {
        return this.m_subContainerSearch;
    }

    public void setSubContainerSearch(boolean subContainerSearch) {
        this.m_subContainerSearch = subContainerSearch;
    }

    public int getBlockKey() {
        return this.m_blockKey;
    }

    public void addFilter(ResultModifierFilterEntry filterEntry) {
        if (null != filterEntry) {
            this.RMFEfilters.addElement(filterEntry);
        }
    }

    public void clearFilters() {
        this.RMFEfilters = new Vector();
    }

    public void setIncludeSubClasses(boolean inShowInheritedSubClasses) {
        this.showInheritedSubClasses = inShowInheritedSubClasses;
    }

    public boolean getIncludeSubClasses() {
        return this.showInheritedSubClasses;
    }

    public void setIncludeAuxClasses(boolean inShowAuxAndSubClasses) {
        this.showAuxAndSubClasses = inShowAuxAndSubClasses;
    }

    public boolean getIncludeAuxClasses() {
        return this.showAuxAndSubClasses;
    }

    public void setSimpleAndOpAdvanced(boolean inUseSimpleAndOpAdvanced) {
        this.useSimpleAndOpAdvanced = inUseSimpleAndOpAdvanced;
    }

    public boolean getSimpleAndOpAdvanced() {
        return this.useSimpleAndOpAdvanced;
    }

    public void setShowGlue(boolean showGlue) {
        this.showGlue = showGlue;
    }

    public boolean getShowGlue() {
        return this.showGlue;
    }

    public void setAllowFileSystemBrowse(int inAllowFileSystemBrowse) {
        this.allowFileSystemBrowse = inAllowFileSystemBrowse;
    }

    public int getAllowFileSystemBrowse() {
        return this.allowFileSystemBrowse;
    }

    public ResultModifierFilterEntry[] getFilters() {
        ResultModifierFilterEntry[] filterArray = new ResultModifierFilterEntry[this.RMFEfilters.size()];
        filterArray = this.RMFEfilters.toArray(filterArray);
        return filterArray;
    }

    public boolean getFiltered() {
        for (int i = 0; i < this.RMFEfilters.size(); ++i) {
            ResultModifierFilterEntry entry = (ResultModifierFilterEntry)this.RMFEfilters.elementAt(i);
            if (null == entry) continue;
            String strNameFilter = entry.getNameFilter();
            if (null != strNameFilter && 0 != strNameFilter.length()) {
                return true;
            }
            String[] typeFilters = entry.getTypeFilter();
            if (null == typeFilters || 0 == typeFilters.length) continue;
            for (int k = 0; k < typeFilters.length; ++k) {
                if (null == typeFilters[k]) continue;
                return true;
            }
        }
        return false;
    }

    public String getFilterString() {
        return this.getFilterString(null);
    }

    public String getFilterString(AdminNamespace namespace) {
        String finalFilterString;
        String simpleFilterString = this.getSimpleFilterString(namespace);
        String complexFilterString = this.getComplexFilterString(namespace);
        if (simpleFilterString.length() > 0 && complexFilterString.length() > 0) {
            finalFilterString = this.useSimpleAndOpAdvanced ? "(&" + simpleFilterString + complexFilterString + ")" : "(|" + simpleFilterString + complexFilterString + ")";
        } else {
            finalFilterString = simpleFilterString + complexFilterString;
            if (finalFilterString.length() == 0) {
                finalFilterString = "(objectClass=*)";
            }
        }
        return finalFilterString;
    }

    protected String getSimpleFilterString(AdminNamespace namespace) {
        boolean eDir = true;
        try {
            if (namespace != null && namespace.isSupported("NVDS")) {
                eDir = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResultModifierFilterEntry[] filters = this.getFilters();
        ArrayList<String> itemList = new ArrayList<String>();
        for (int j = 0; j < filters.length; ++j) {
            String nameTypeFilterString;
            String nameValue = filters[j].getNameFilter();
            String[] typeValues = filters[j].getTypeFilter();
            String nameFilterString = this.getNameFilterString(nameValue, eDir);
            String typeFilterString = this.getTypeFilterString(typeValues, eDir, namespace);
            if (nameFilterString.length() > 0 && typeFilterString.length() > 0) {
                nameTypeFilterString = "(&" + nameFilterString + typeFilterString + ")";
            } else {
                nameTypeFilterString = nameFilterString + typeFilterString;
                if (nameTypeFilterString.length() == 0) continue;
            }
            itemList.add(nameTypeFilterString);
        }
        StringBuffer simpleFilterBuf = new StringBuffer();
        if (itemList.size() > 1) {
            simpleFilterBuf.append("(|");
        }
        Iterator iter = itemList.iterator();
        while (iter.hasNext()) {
            simpleFilterBuf.append((String)iter.next());
        }
        if (itemList.size() > 1) {
            simpleFilterBuf.append(")");
        }
        return simpleFilterBuf.toString();
    }

    protected String getNameFilterString(String nameValue, boolean eDir) {
        if (nameValue == null) {
            return "";
        }
        if ((nameValue = nameValue.trim()).length() == 0) {
            return "";
        }
        if (eDir) {
            return "(Name=" + nameValue + ")";
        }
        if (SchemaUtil.FindUnescapedChar('=', nameValue) == -1) {
            return "(distinguishedValue=" + nameValue + ")";
        }
        return "(" + nameValue + ")";
    }

    protected String getTypeFilterString(String[] typeValues, boolean eDir, AdminNamespace namespace) {
        String baseOrObjectClass;
        if (typeValues == null || typeValues.length == 0) {
            return "";
        }
        String string = baseOrObjectClass = eDir ? "objectClass" : "structuralObjectClass";
        if (this.showAuxAndSubClasses) {
            baseOrObjectClass = "objectClass";
        }
        boolean expandSubclasses = this.showInheritedSubClasses && !this.showAuxAndSubClasses && !eDir;
        SchemaDefinition schemaDef = null;
        if (expandSubclasses) {
            try {
                schemaDef = namespace.getSchemaDefinition(null);
            }
            catch (SPIException sPIException) {
                // empty catch block
            }
        }
        LinkedHashSet<String> classSet = new LinkedHashSet<String>();
        for (int i = 0; i < typeValues.length; ++i) {
            if (typeValues[i] == null || typeValues[i].length() <= 0) continue;
            if (typeValues[i].equals("*")) {
                return "";
            }
            if (expandSubclasses) {
                if (typeValues[i].equalsIgnoreCase("Top")) {
                    return "";
                }
                SchemaUtil.putThisClassAndSubClassesIntoSet(typeValues[i], classSet, schemaDef);
                continue;
            }
            classSet.add(typeValues[i]);
        }
        Iterator iter = classSet.iterator();
        LinkedHashSet<String> classFilters = new LinkedHashSet<String>();
        while (iter.hasNext()) {
            classFilters.add("(" + baseOrObjectClass + "=" + iter.next() + ")");
        }
        if (classFilters.size() == 0) {
            return "";
        }
        iter = classFilters.iterator();
        if (classFilters.size() == 1) {
            return (String)iter.next();
        }
        StringBuffer sb = new StringBuffer("(|");
        while (iter.hasNext()) {
            sb.append(iter.next());
        }
        sb.append(")");
        return sb.toString();
    }

    protected String getComplexFilterString(AdminNamespace namespace) {
        return "";
    }
}

