/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.snapin;

import com.novell.application.console.shell.Resources;
import com.novell.application.console.snapin.Debug;
import com.novell.application.console.snapin.NConeFactory;
import com.novell.utility.localization.Loc;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

class TraceWindow
extends Frame {
    private TextArea text;
    private int windowPosX = -1;
    private int windowPosY = -1;

    public TraceWindow() {
        super("Trace");
        JButton printButton = NConeFactory.novellJButton((JButton)new JButton("Print..."), (String)Loc.removeHotChar((String)Resources.getString((String)"WindowPrintKey")), (String)"");
        JButton hideButton = NConeFactory.novellJButton((JButton)new JButton("Hide"), (String)Loc.removeHotChar((String)Resources.getString((String)"WindowHideKey")), (String)"");
        JButton closeButton = NConeFactory.novellJButton((JButton)new JButton("Close"), (String)Loc.removeHotChar((String)Resources.getString((String)"WindowCloseKey")), (String)"");
        JPanel buttonPanel = NConeFactory.novellJPanel((JPanel)new JPanel(), (String)"", (String)"");
        buttonPanel.setBackground(SystemColor.control);
        buttonPanel.add(printButton);
        buttonPanel.add(hideButton);
        buttonPanel.add(closeButton);
        this.setLayout(new BorderLayout());
        this.text = new TextArea(10, 10);
        this.add("Center", this.text);
        this.add("South", buttonPanel);
        this.setSize(600, 300);
        this.setFont(new Font("Dialog", 0, 12));
        this.enableEvents(64L);
        hideButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TraceWindow.this.setVisible(false);
            }
        });
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TraceWindow.this.dispose();
                Debug.window = null;
            }
        });
        printButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintJob pjob = TraceWindow.this.getToolkit().getPrintJob(TraceWindow.this, "Debug", null);
                Dimension pageSize = pjob.getPageDimension();
                pageSize.height += 200;
                Graphics pg = pjob.getGraphics();
                String buffer = TraceWindow.this.text.getText();
                String line = "";
                Font font = new Font("Dialog", 0, 18);
                Font numFont = new Font("Dialog", 1, 18);
                FontMetrics metrics = TraceWindow.this.getFontMetrics(font);
                int maxDescent = metrics.getMaxDescent();
                int lineHeight = metrics.getHeight();
                int begLineIndex = 0;
                int endLineIndex = 0;
                int y = 0;
                int pageNo = 1;
                int topMargin = 100;
                int margin = 25;
                int lineThickness = 5;
                if (pg != null) {
                    pg.setFont(font);
                    endLineIndex = buffer.indexOf("\n", begLineIndex);
                    while (endLineIndex != -1) {
                        if ((y += lineHeight) + lineHeight > pageSize.height) {
                            pg.setFont(numFont);
                            pg.drawLine(margin, pageSize.height + lineHeight + topMargin - lineThickness, pageSize.width - margin + 300, pageSize.height + lineHeight + topMargin);
                            pg.drawString("Page: " + pageNo, margin, pageSize.height + lineHeight * 2 + topMargin);
                            pg.setFont(font);
                            pg.dispose();
                            pg = pjob.getGraphics();
                            pg.setFont(font);
                            y = 0;
                            ++pageNo;
                        }
                        line = buffer.substring(begLineIndex, endLineIndex);
                        begLineIndex = endLineIndex + 1;
                        line = line.replace('\t', ' ');
                        line = line.replace('\r', ' ');
                        line = line.replace('\n', ' ');
                        pg.drawString(line, margin, y - maxDescent + topMargin);
                        endLineIndex = buffer.indexOf("\n", begLineIndex);
                    }
                    pg.setFont(numFont);
                    pg.drawLine(margin, pageSize.height + lineHeight + topMargin - lineThickness, pageSize.width - margin + 300, pageSize.height + lineHeight + topMargin);
                    pg.drawString("Page: " + pageNo, margin, pageSize.height + lineHeight * 2 + topMargin);
                    pg.dispose();
                    pjob.end();
                }
            }
        });
    }

    public void write(String outString) {
        this.text.append(outString + "\n");
    }

    protected void processEvent(AWTEvent event) {
        if (event.getID() == 201) {
            this.dispose();
            Debug.window = null;
        }
        super.processEvent(event);
    }

    public void setVisible(boolean visible) {
        Rectangle parentRect = new Rectangle();
        Dimension sizeScreen = Toolkit.getDefaultToolkit().getScreenSize();
        super.setVisible(visible);
        if (!visible) {
            return;
        }
        parentRect.setBounds(0, 0, sizeScreen.width, sizeScreen.height);
        if (this.windowPosX == -1) {
            this.windowPosX = Math.max(0, parentRect.x + (parentRect.width - this.getSize().width) / 2);
            this.windowPosX = Math.min(this.windowPosX, sizeScreen.width - this.getSize().width);
        } else {
            this.windowPosX = this.getLocationOnScreen().x;
        }
        if (this.windowPosY == -1) {
            this.windowPosY = Math.max(0, parentRect.y + (parentRect.height - this.getSize().height) / 2);
            this.windowPosY = Math.min(this.windowPosY, sizeScreen.height - this.getSize().height);
        } else {
            this.windowPosY = this.getLocationOnScreen().y;
        }
        this.setLocation(this.windowPosX, this.windowPosY);
    }
}

