/*
 * Decompiled with CFR 0.152.
 */
package com.novell.WebServiceSDK;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.io.Writer;

public class Base64OutputStream
extends OutputStream {
    private final int iBufferSize = 3;
    byte[] buf = new byte[3];
    int buffered = 0;
    int chunksdone = 0;
    boolean finished = false;
    Writer out;
    private static char[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();

    public Base64OutputStream(Writer writer) {
        this.out = writer;
    }

    @Override
    public synchronized void write(int n) throws IOException {
        this.buf[this.buffered++] = (byte)n;
        if (this.buffered == this.buf.length) {
            this.empty_buffer();
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.write(byArray[n + i]);
        }
    }

    public void write(InputStream inputStream) throws IOException {
        if (this.buffered != 0) {
            boolean bl = false;
            while (this.buffered != this.buf.length) {
                int n = inputStream.read();
                if (n != -1) {
                    this.write(n);
                    continue;
                }
                return;
            }
        }
        while ((this.buffered = inputStream.read(this.buf)) == this.buf.length) {
            this.empty_buffer();
        }
    }

    @Override
    public void flush() throws IOException {
        this.empty_buffer();
        this.out.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        this.flush();
        this.out.close();
        super.close();
    }

    protected void empty_buffer() throws IOException {
        if (this.buffered != 0) {
            if (this.finished) {
                throw new StreamCorruptedException();
            }
            this.out.write(Base64OutputStream.encode(this.buf, 0, this.buffered));
            ++this.chunksdone;
            this.buffered = 0;
            if (this.chunksdone / 3 >= 6 || this.finished) {
                this.out.write(10);
                this.chunksdone = 0;
            }
        }
    }

    public static char[] encode(byte[] byArray) {
        return Base64OutputStream.encode(byArray, 0, byArray == null ? 0 : byArray.length);
    }

    public static char[] encode(byte[] byArray, int n, int n2) {
        char[] cArray = new char[(n2 - n + 2) / 3 * 4];
        int n3 = n;
        int n4 = 0;
        while (n3 < n2) {
            boolean bl = false;
            boolean bl2 = false;
            int n5 = 0xFF & byArray[n3];
            n5 <<= 8;
            if (n3 + 1 < n2) {
                n5 |= 0xFF & byArray[n3 + 1];
                bl2 = true;
            }
            n5 <<= 8;
            if (n3 + 2 < n2) {
                n5 |= 0xFF & byArray[n3 + 2];
                bl = true;
            }
            cArray[n4 + 3] = alphabet[bl ? n5 & 0x3F : 64];
            cArray[n4 + 2] = alphabet[bl2 ? (n5 >>= 6) & 0x3F : 64];
            cArray[n4 + 1] = alphabet[(n5 >>= 6) & 0x3F];
            cArray[n4 + 0] = alphabet[(n5 >>= 6) & 0x3F];
            n3 += 3;
            n4 += 4;
        }
        return cArray;
    }
}

