/*
 * Decompiled with CFR 0.152.
 */
package com.novell.WebServiceSDK;

import com.novell.WebServiceSDK.WSConnectionListener;
import com.novell.WebServiceSDK.WSConnectionManager;
import com.novell.WebServiceSDK.WSDebug;
import com.novell.WebServiceSDK.WSException;
import com.novell.WebServiceSDK.WSHttp;
import com.novell.WebServiceSDK.WSMessage;
import com.novell.WebServiceSDK.WSPublisher;
import com.novell.WebServiceSDK.WSSoap;

class InternalWSPublisher
extends WSPublisher
implements WSConnectionListener,
Runnable {
    public void setConnectionManager(WSConnectionManager wSConnectionManager) {
        this.m_ConnMgr = wSConnectionManager;
    }

    public void setSoapObject(WSSoap wSSoap) {
        this.m_SoapObject = new WSSoap(wSSoap);
    }

    public void setHttpObject(WSHttp wSHttp) {
        this.m_HttpObject = new WSHttp(wSHttp);
        this.m_MasterHttpObject = wSHttp;
    }

    @Override
    public void run() {
        try {
            WSMessage wSMessage = this.publish();
        }
        catch (WSException wSException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataReceived(int n) {
        if (!this.m_httpHeaderReceived) {
            if ((char)n != '\n') {
                this.m_ReturnBits.append((char)n);
                return;
            }
            if (this.m_ReturnBits.length() == 0 || this.m_ReturnBits.charAt(0) == '\r') {
                WSDebug.trace(5, "Publisher HTTP header received");
                this.m_httpHeaderReceived = true;
                if (this.m_MessageSize == 0) {
                    this.m_MessageReceived = true;
                    InternalWSPublisher internalWSPublisher = this;
                    synchronized (internalWSPublisher) {
                        WSDebug.trace(5, "Publisher Notify message received");
                        this.notify();
                    }
                }
                return;
            }
            String string = this.m_ReturnBits.toString();
            WSDebug.trace(1, string);
            this.m_ReturnBits = new StringBuffer();
            if (string.toLowerCase().startsWith("content-length:")) {
                this.m_MessageSize = Integer.parseInt(string.substring(15).trim());
                WSDebug.trace(5, "Message size = " + this.m_MessageSize);
            }
            this.m_ReturnHttpHeader.add(string);
        } else if (this.m_MessageSize != 0) {
            if (this.m_MessageBuffer == null) {
                this.m_MessageBuffer = new StringBuffer();
            }
            this.m_MessageBuffer.append((char)n);
            WSDebug.trace(1, (char)n);
            if (this.m_MessageBuffer.length() >= this.m_MessageSize) {
                this.m_MessageReceived = true;
                InternalWSPublisher internalWSPublisher = this;
                synchronized (internalWSPublisher) {
                    WSDebug.trace(5, "Publisher Notify message received");
                    this.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosed() {
        WSDebug.trace(5, "Publisher connectionClosed()");
        InternalWSPublisher internalWSPublisher = this;
        synchronized (internalWSPublisher) {
            this.m_ConnectionClosed = true;
            this.notify();
        }
    }
}

