/*
 * Decompiled with CFR 0.152.
 */
package com.novell.WebServiceSDK;

import com.novell.WebServiceSDK.InternalWSMessage;
import com.novell.WebServiceSDK.InternalWSPublisher;
import com.novell.WebServiceSDK.WSConnectionHandle;
import com.novell.WebServiceSDK.WSConnectionManager;
import com.novell.WebServiceSDK.WSDebug;
import com.novell.WebServiceSDK.WSException;
import com.novell.WebServiceSDK.WSHttp;
import com.novell.WebServiceSDK.WSMessage;
import com.novell.WebServiceSDK.WSMessageListener;
import com.novell.WebServiceSDK.WSSoap;
import com.novell.WebServiceSDK.WebService;
import java.io.IOException;
import org.w3c.dom.Node;

public abstract class WSPublisher {
    protected WSSoap m_SoapObject = null;
    protected WSHttp m_HttpObject = null;
    protected WSHttp m_MasterHttpObject;
    protected WSConnectionManager m_ConnMgr = null;
    private WSMessageListener m_PublishListener = null;
    protected boolean m_httpHeaderReceived = false;
    protected boolean m_MessageReceived = false;
    protected WSHttp m_ReturnHttpHeader = null;
    protected int m_MessageSize = 0;
    protected StringBuffer m_MessageBuffer = null;
    protected StringBuffer m_ReturnBits;
    private WSConnectionHandle m_ConnHandle;
    private long m_Timeout = 60000L;
    private Object m_SyncObject = new Object();
    protected boolean m_ConnectionClosed;

    public long getTimeout() {
        return this.m_Timeout;
    }

    public void setTimeout(long l) {
        this.m_Timeout = l;
    }

    public void addPublishListener(WSMessageListener wSMessageListener) {
        this.m_PublishListener = wSMessageListener;
    }

    public void asyncPublish() {
        WSDebug.trace(5, "Publisher asyncPublish()");
        Thread thread = new Thread((InternalWSPublisher)this);
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized WSMessage publish() throws WSException {
        WSDebug.trace(5, "Publisher publish");
        InternalWSMessage internalWSMessage = null;
        Object object = this.m_SyncObject;
        synchronized (object) {
            this.m_httpHeaderReceived = false;
            this.m_MessageReceived = false;
            this.m_MessageSize = 0;
            this.m_MessageBuffer = null;
            this.m_ReturnHttpHeader = new WSHttp();
            this.m_ReturnBits = new StringBuffer();
            this.m_HttpObject.setContentLength(this.m_SoapObject.toString().length());
            String string = this.m_HttpObject.toString();
            string = string + this.m_SoapObject.toString();
            boolean bl = false;
            int n = 0;
            while (!bl) {
                if (++n >= 5) {
                    throw new WSException(WebService.m_ResBundle.getString("disconnected"));
                }
                this.m_ConnectionClosed = false;
                this.m_ConnHandle = this.m_ConnMgr.getConnectionHandle();
                this.m_ConnHandle.addConnectionListener((InternalWSPublisher)this);
                try {
                    this.m_ConnHandle.sendMessage(string);
                    bl = true;
                    try {
                        this.wait(this.m_Timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        WSDebug.trace(5, "Publisher wait() interupted");
                    }
                    if (this.m_MessageReceived || !this.m_ConnectionClosed) continue;
                    this.m_ConnHandle.abort();
                    bl = false;
                }
                catch (IOException iOException) {
                    this.m_ConnHandle.abort();
                }
            }
            if (!this.m_MessageReceived) {
                this.m_ConnHandle.abort();
                WSDebug.trace(5, "Publisher Time out exceeded");
                WSDebug.trace(5, "Publisher Message not received");
                throw new WSException(WebService.m_ResBundle.getString("timeoutExceeded"));
            }
            WSDebug.trace(5, "Publisher Message received");
            this.m_ConnHandle.unuse();
            if (this.m_ReturnHttpHeader.getHttpResponse() != null && !this.m_ReturnHttpHeader.getHttpResponse().startsWith("200")) {
                int n2 = Integer.parseInt(this.m_ReturnHttpHeader.getHttpResponse().substring(0, 3));
                String string2 = null;
                try {
                    string2 = WebService.m_HTTPBundle.getString("HTTP" + n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string2 == null) {
                    throw new WSException(WebService.m_ResBundle.getString("httpError") + " " + this.m_ReturnHttpHeader.getHttpResponse(), 1, n2);
                }
                throw new WSException(string2, 1, n2);
            }
            if (this.m_ReturnHttpHeader.getCookie() != null) {
                this.m_MasterHttpObject.setCookie(this.m_ReturnHttpHeader.getCookie());
            }
            internalWSMessage = new InternalWSMessage();
            internalWSMessage.setHttpHeader(this.m_ReturnHttpHeader);
            if (this.m_MessageBuffer == null) {
                throw new WSException(WebService.m_ResBundle.getString("noSoap"));
            }
            internalWSMessage.setSoap(new WSSoap(this.m_MessageBuffer.toString()));
        }
        if (this.m_PublishListener != null) {
            this.m_PublishListener.WSMessageReceived(internalWSMessage);
        }
        return internalWSMessage;
    }

    public void setEvent(String string) {
        WSDebug.trace(5, "Publisher setEvent(" + string + ")");
        this.m_SoapObject.setEvent(string);
        this.m_HttpObject.setSoapAction(string);
    }

    public void setParams(String string) throws WSException {
        this.m_SoapObject.setParams(string);
    }

    public void setParams(Node node) {
        WSDebug.trace(5, "Publisher setParams(Document)");
        this.m_SoapObject.setParams(node);
    }

    public void sendResponse(WSMessage wSMessage) {
        InternalWSMessage internalWSMessage = (InternalWSMessage)wSMessage;
        this.setEvent("RemoteSendAnswer");
        this.setParams(internalWSMessage.getParamsElement());
        this.asyncPublish();
    }
}

