/*
 * Decompiled with CFR 0.152.
 */
package com.novell.WebServiceSDK;

import com.novell.WebServiceSDK.WSDebug;
import com.novell.WebServiceSDK.WSException;
import com.novell.WebServiceSDK.WSSocketProvider;
import com.novell.WebServiceSDK.WSTrustManager;
import com.novell.WebServiceSDK.WebService;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;

class WSSSLSocketProvider
extends WSSocketProvider
implements Runnable {
    FileInputStream keyStoreIStream = null;
    SSLContext m_SSLContext;
    SocketFactory m_SocketFactory;
    SSLSocket m_sslSocket;
    boolean m_handshakeComplete = false;
    String providerName;

    public WSSSLSocketProvider() throws WSException {
        Serializable serializable;
        Object object;
        String string = "keystore.key";
        String string2 = "Novell";
        char[] cArray = string2.toCharArray();
        try {
            object = Class.forName("com.sun.net.ssl.internal.ssl.Provider");
            serializable = (Provider)((Class)object).newInstance();
            Security.addProvider((Provider)serializable);
            this.providerName = "SunJSSE";
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                serializable = Class.forName("com.ibm.jsse.IBMJSSEProvider");
                Provider provider = (Provider)((Class)serializable).newInstance();
                Security.addProvider(provider);
                this.providerName = "IBMJSSE";
            }
            catch (Exception exception) {
                throw new WSException(WebService.m_ResBundle.getString("unableToInitializeJSSE"));
            }
        }
        catch (Exception exception) {
            throw new WSException(WebService.m_ResBundle.getString("unableToInitializeJSSE"));
        }
        try {
            this.keyStoreIStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.keyStoreIStream = null;
        }
        try {
            object = KeyStore.getInstance(KeyStore.getDefaultType());
            ((KeyStore)object).load(this.keyStoreIStream, cArray);
            if (this.keyStoreIStream != null) {
                this.keyStoreIStream.close();
                this.keyStoreIStream = null;
            }
            serializable = new TrustManager[]{new WSTrustManager((KeyStore)object, string, cArray)};
            this.m_SSLContext = SSLContext.getInstance("TLS", this.providerName);
            this.m_SSLContext.init(null, (TrustManager[])serializable, null);
            this.m_SocketFactory = this.m_SSLContext.getSocketFactory();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new WSException(WebService.m_ResBundle.getString("unableToInitializeJSSE"));
        }
        catch (KeyManagementException keyManagementException) {
            throw new WSException(WebService.m_ResBundle.getString("unableToInitializeJSSE"));
        }
        catch (CertificateException certificateException) {
            throw new WSException(WebService.m_ResBundle.getString("unableToInitializeJSSE"));
        }
        catch (KeyStoreException keyStoreException) {
            throw new WSException(WebService.m_ResBundle.getString("unableToInitializeJSSE"));
        }
        catch (IOException iOException) {
            throw new WSException(WebService.m_ResBundle.getString("unableToInitializeJSSE"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new WSException(WebService.m_ResBundle.getString("unableToInitializeJSSE"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket getSocket(String string, int n) throws WSException {
        Socket socket = null;
        try {
            socket = this.m_SocketFactory.createSocket(string, n);
        }
        catch (IOException iOException) {
            throw new WSException(WebService.m_ResBundle.getString("unableToConnect"));
        }
        this.m_sslSocket = (SSLSocket)socket;
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
        try {
            WSSSLSocketProvider wSSSLSocketProvider = this;
            synchronized (wSSSLSocketProvider) {
                this.wait(60000L);
                WSDebug.trace(2, "SSL Handshake timeout occured");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.m_handshakeComplete) {
            throw new WSException(WebService.m_ResBundle.getString("handshakeFailure"));
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.m_sslSocket.startHandshake();
            WSDebug.trace(2, "SSL Handshake complete");
            this.m_handshakeComplete = true;
        }
        catch (IOException iOException) {
            WSDebug.trace(2, "SSL IOException: " + iOException);
        }
        WSSSLSocketProvider wSSSLSocketProvider = this;
        synchronized (wSSSLSocketProvider) {
            this.notify();
        }
    }
}

