/*
 * Decompiled with CFR 0.152.
 */
package com.novell.WebServiceSDK;

import com.novell.WebServiceSDK.InternalWSSubscriber;
import com.novell.WebServiceSDK.Utils;
import com.novell.WebServiceSDK.WSConnectionManager;
import com.novell.WebServiceSDK.WSDebug;
import com.novell.WebServiceSDK.WSException;
import com.novell.WebServiceSDK.WSHttp;
import com.novell.WebServiceSDK.WSMessage;
import com.novell.WebServiceSDK.WSMessageListener;
import com.novell.WebServiceSDK.WSPublisher;
import com.novell.WebServiceSDK.WSSoap;
import com.novell.WebServiceSDK.WebService;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class WSSubscriber {
    protected WSSoap m_soapObject = null;
    protected WSHttp m_httpObject = null;
    protected WSConnectionManager m_connMgr = null;
    protected WebService m_webService;
    protected WSMessageListener m_subscriptionListener = null;
    private Vector m_subscriptionList = new Vector();
    private Thread m_subscriberThread = null;
    protected boolean m_autoSubscribe = false;

    public void addSubscriptionListener(WSMessageListener wSMessageListener) {
        this.m_subscriptionListener = wSMessageListener;
    }

    public void addSubscription(String string) throws WSException {
        WSDebug.trace(7, "addSubscription(" + string + ")");
        String[] stringArray = new String[]{string};
        this.addSubscription(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscription(String[] stringArray) throws WSException {
        WSDebug.trace(7, "addSubscription()");
        for (int i = 0; i < stringArray.length; ++i) {
            WSDebug.trace(7, stringArray[i]);
        }
        WSPublisher wSPublisher = this.m_webService.createPublisher();
        wSPublisher.setEvent("RemoteSubscribe");
        wSPublisher.setParams(this.buildParamsDocument(stringArray));
        wSPublisher.publish();
        Vector vector = this.m_subscriptionList;
        synchronized (vector) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.m_subscriptionList.add(stringArray[i]);
            }
        }
    }

    public synchronized void autoSubscribe() {
        this.m_subscriberThread = new Thread((InternalWSSubscriber)this);
        this.m_subscriberThread.setDaemon(true);
        this.m_autoSubscribe = true;
        this.m_subscriberThread.start();
    }

    public void unsubscribe(String string) throws WSException {
        String[] stringArray = new String[]{string};
        this.unsubscribe(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String[] stringArray) throws WSException {
        int n;
        WSDebug.trace(7, "unsubscribe()");
        for (n = 0; n < stringArray.length; ++n) {
            WSDebug.trace(7, stringArray[n]);
        }
        WSPublisher wSPublisher = this.m_webService.createPublisher();
        wSPublisher.setEvent("RemoteUnsubscribe");
        wSPublisher.setParams(this.buildParamsDocument(stringArray));
        wSPublisher.publish();
        Vector vector = this.m_subscriptionList;
        synchronized (vector) {
            for (n = 0; n < stringArray.length; ++n) {
                for (int i = 0; i < this.m_subscriptionList.size(); ++i) {
                    if (!stringArray[n].equals((String)this.m_subscriptionList.get(i))) continue;
                    this.m_subscriptionList.remove(i);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe() throws WSException {
        WSDebug.trace(7, "unsubscribe() - ALL");
        WSPublisher wSPublisher = this.m_webService.createPublisher();
        wSPublisher.setEvent("RemoteUnsubscribe");
        Vector vector = this.m_subscriptionList;
        synchronized (vector) {
            wSPublisher.setParams(this.buildParamsDocument(this.m_subscriptionList));
            this.m_subscriptionList.clear();
        }
        wSPublisher.publish();
    }

    public WSMessage getMessage(boolean bl) throws WSException {
        return this.getMessage(bl, 0);
    }

    public WSMessage getMessage(boolean bl, int n) throws WSException {
        WSMessage wSMessage;
        Element element;
        NodeList nodeList;
        WSDebug.trace(7, "getMessage(" + bl + ")");
        WSPublisher wSPublisher = this.m_webService.createPublisher();
        wSPublisher.addPublishListener(this.m_subscriptionListener);
        if (bl) {
            wSPublisher.setTimeout(n);
        }
        if ((nodeList = (element = (wSMessage = this.getMessage(bl, wSPublisher)).getParamsElement()).getElementsByTagName("EBX:XError")).getLength() == 0) {
            return wSMessage;
        }
        Element element2 = (Element)nodeList.item(0);
        String string = element2.getAttribute("EBX:ErrorCode");
        if (null != string && string.equals("-347156218")) {
            return null;
        }
        return wSMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WSMessage getMessage(boolean bl, WSPublisher wSPublisher) throws WSException {
        wSPublisher.setEvent("RemoteGetMessage");
        Vector vector = this.m_subscriptionList;
        synchronized (vector) {
            Document document = this.buildParamsDocument(this.m_subscriptionList);
            if (bl) {
                Element element = document.getDocumentElement();
                element.appendChild(document.createElement("Wait"));
            }
            wSPublisher.setParams(document);
        }
        return wSPublisher.publish();
    }

    public synchronized void stopAutoSubscribe() {
        this.m_autoSubscribe = false;
        this.m_subscriberThread.interrupt();
        try {
            this.m_subscriberThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Document buildParamsDocument(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return this.buildParamsDocument(vector);
    }

    private Document buildParamsDocument(Vector vector) {
        Document document = Utils.newDocument();
        Element element = document.createElement("params");
        document.appendChild(element);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Element element2 = document.createElement("Event");
            Text text = document.createTextNode((String)vector.get(i));
            element.appendChild(element2);
            element2.appendChild(text);
        }
        return document;
    }
}

