/*
 * Decompiled with CFR 0.152.
 */
package com.novell.naudit.lcache;

import com.novell.naudit.lcache.Connection;
import com.novell.naudit.lcache.LCache;
import com.novell.naudit.lcache.LogList;
import com.novell.naudit.util.Constants;
import com.novell.naudit.util.Log;
import com.novell.naudit.util.LogEventConfig;
import com.novell.naudit.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class ClientConnection
extends Thread
implements Constants {
    private Socket socket;
    private DataOutputStream out;
    private DataInputStream in;
    private LCache lcache;
    private String appName;
    private String logHost;
    private String pemCertificate;
    private String pemPrivateKey;
    static int count = 0;

    public ClientConnection(LCache lCache, Socket socket) throws IOException {
        this.socket = socket;
        this.lcache = lCache;
        this.socket.setSoTimeout(180000);
        this.out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        this.in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
    }

    @Override
    public void run() {
        try {
            this.socket.setSoTimeout(180000);
            this.out.writeInt(Util.getLEInt(16795468));
            this.out.flush();
            int n = Util.getBEInt(this.in.readInt());
            byte[] byArray = new byte[n];
            this.in.readFully(byArray);
            if (!this.parseWelcome(byArray, n)) {
                Log.log("jlcache", "Bad welcome format from logevent. Closing socket");
                this.socket.close();
                return;
            }
            if (this.appName.length() > 255 || this.logHost.length() > 256) {
                Log.log("jlcache", "Bad welcome format from logevent: AppName or LogHost is too big.");
                this.socket.close();
                return;
            }
            Connection connection = new Connection();
            if (!this.lcache.addLogApp(connection, this.appName, this.logHost, this.pemCertificate, this.pemPrivateKey)) {
                Log.log("jlcache", "ClientThread: error adding app for: " + this.appName);
                this.socket.close();
                return;
            }
            this.out.writeByte(1);
            this.out.flush();
            while (!LCache.exiting) {
                int n2 = 0;
                int n3 = 0;
                try {
                    n2 = Util.getBEInt(this.in.readInt());
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    Log.log("jlcache", "LCache has not received any data from" + this.appName + " .Continue to wait");
                    continue;
                }
                n3 = Util.getBEInt(this.in.readInt());
                switch (n2) {
                    case 69: 
                    case 86: {
                        LogList logList = connection.logListEntry;
                        try {
                            long l;
                            byte[] byArray2 = new byte[n3];
                            this.in.readFully(byArray2);
                            if (LogEventConfig.logCacheLimitAction != 0 && (l = logList.handle.getFilePointer()) > LogEventConfig.logMaxCacheSize) {
                                if (LogEventConfig.logCacheLimitAction == 1) break;
                                if (LogEventConfig.logCacheLimitAction == 2) {
                                    logList.lockSem.acquire();
                                    logList.handle.close();
                                    try {
                                        if (!logList.file.delete()) {
                                            if (Log.loglevel > 4) {
                                                Log.log("ClientConnection", "Failed to remove application " + logList.appName + " cache file " + logList.path + ".");
                                            }
                                            this.socket.close();
                                            return;
                                        }
                                    }
                                    catch (SecurityException securityException) {
                                        if (Log.loglevel > 4) {
                                            Log.log("ClientConnection", "Failed to remove application " + logList.appName + " cache file " + logList.path + ": " + securityException.getMessage());
                                        }
                                        this.socket.close();
                                        return;
                                    }
                                    try {
                                        logList.handle = new RandomAccessFile(logList.file, "rw");
                                        this.lcache.writeMagicHeader(logList);
                                    }
                                    catch (Exception exception) {
                                        if (Log.loglevel > 4) {
                                            Log.log("ClientConnection", "Could not re-acquire handle to cache file: " + exception.getMessage());
                                        }
                                        this.socket.close();
                                        return;
                                    }
                                    logList.lockSem.release();
                                }
                            }
                            logList.lockSem.acquire();
                            logList.handle.writeInt(Util.getNativeInt(n3 + 8));
                            logList.handle.writeInt(Util.getLEInt(n2));
                            logList.handle.writeInt(Util.getLEInt(n3));
                            if (logList.nextCheck == 0L) {
                                logList.nextCheck = System.currentTimeMillis() + (long)LogEventConfig.logCheckInterval;
                            }
                            boolean bl = false;
                            int n4 = Util.getBEInt(byArray2, 0);
                            if ((n4 & 0x1000) != 0) {
                                byte[] byArray3 = Util.getLEBytes(n4 ^= 0x1000);
                                byArray2[0] = byArray3[0];
                                byArray2[1] = byArray3[1];
                                byArray2[2] = byArray3[2];
                                byArray2[3] = byArray3[3];
                                bl = true;
                            }
                            logList.handle.write(byArray2);
                            if (bl) {
                                this.out.writeByte(1);
                                this.out.flush();
                            }
                        }
                        catch (Exception exception) {
                            Log.log("jlcache", "Exception trying to write data to cache file: " + exception.getMessage());
                        }
                        logList.lockSem.release();
                        break;
                    }
                    case 81: {
                        return;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Log.log("jlcache", "Exception trying to communicate with logevent: " + exception.getMessage());
        }
    }

    private boolean parseWelcome(byte[] byArray, int n) {
        byte by = 0;
        int n2 = 0;
        int n3 = Util.getByteOffset(by, byArray, n2, n);
        if (n3 == -1) {
            return false;
        }
        this.appName = new String(byArray, n2, n3 - n2);
        ++n3;
        n2 = n3;
        if ((n3 = Util.getByteOffset(by, byArray, n2, n)) == -1) {
            return false;
        }
        this.logHost = new String(byArray, n2, n3 - n2);
        ++n3;
        n2 = n3;
        if ((n3 = Util.getByteOffset(by, byArray, n2, n)) == -1) {
            return false;
        }
        this.pemCertificate = new String(byArray, n2, n3 - n2);
        ++n3;
        n2 = n3;
        if ((n3 = Util.getByteOffset(by, byArray, n2, n)) == -1) {
            return false;
        }
        this.pemPrivateKey = new String(byArray, n2, n3 - n2);
        return true;
    }
}

