/*
 * Decompiled with CFR 0.152.
 */
package com.novell.naudit.lcache;

import com.novell.naudit.lcache.LCache;
import com.novell.naudit.lcache.LogList;
import com.novell.naudit.util.Constants;
import com.novell.naudit.util.Log;
import com.novell.naudit.util.LogEventConfig;
import com.novell.naudit.util.SLSConnection;
import com.novell.naudit.util.Util;
import java.io.RandomAccessFile;

public class MonitorCache
extends Thread
implements Constants {
    private static String MODULE_NAME = "jlcache/MonitorCache";
    private LCache lcache;
    static int storedEvents = 0;

    public MonitorCache(LCache lCache) {
        this.lcache = lCache;
    }

    @Override
    public void run() {
        long l = 0L;
        long l2 = 0L;
        boolean bl = false;
        while (!LCache.exiting) {
            LCache.logListSem.acquire();
            LogList logList = this.lcache.logList;
            LCache.logListSem.release();
            if (logList != null) {
                do {
                    if (logList.nextCheck > 0L && logList.nextCheck < System.currentTimeMillis()) {
                        try {
                            SLSConnection sLSConnection = new SLSConnection(logList.appName, logList.certs, logList.privateKey, logList.host, LogEventConfig.logEnginePort);
                            sLSConnection.authenticate();
                            logList.lockSem.acquire();
                            RandomAccessFile randomAccessFile = logList.handle;
                            randomAccessFile.getChannel().force(false);
                            l2 = randomAccessFile.length();
                            randomAccessFile.seek(0L);
                            l = this.lcache.getMagicHeaderSize(logList.pemCertificate, logList.pemPrivateKey);
                            if (l >= l2) {
                                bl = true;
                            }
                            randomAccessFile.seek(l2);
                            logList.lockSem.release();
                            bl = false;
                            long l3 = 0L;
                            while (!bl) {
                                block13: {
                                    logList.lockSem.acquire();
                                    try {
                                        randomAccessFile.getChannel().force(false);
                                        l2 = randomAccessFile.length();
                                        randomAccessFile.seek(l);
                                        int n = Util.getBEIntFromNative(randomAccessFile.readInt());
                                        byte[] byArray = new byte[n];
                                        randomAccessFile.readFully(byArray);
                                        sLSConnection.sendData(byArray);
                                        ++l3;
                                        l = randomAccessFile.getFilePointer();
                                        randomAccessFile.seek(l2);
                                        if (l < l2) break block13;
                                        bl = true;
                                    }
                                    catch (Exception exception) {
                                        Log.log(MODULE_NAME, "Exception while trying to send data to server: " + exception.getMessage());
                                        logList.lockSem.release();
                                        break;
                                    }
                                }
                                logList.lockSem.release();
                            }
                            sLSConnection.closeConnection();
                            System.out.println("MonitorCache processed: " + l3);
                            logList.lockSem.acquire();
                            logList.handle.setLength(logList.magicHeaderSize);
                            logList.nextCheck = 0L;
                            logList.lockSem.release();
                        }
                        catch (Exception exception) {
                            Log.log(MODULE_NAME, "Exception while preparing to send data to server: " + exception.getMessage());
                        }
                    }
                    LCache.logListSem.acquire();
                    logList = logList.next;
                    LCache.logListSem.release();
                } while (logList != null);
            }
            try {
                for (int i = 0; i < LogEventConfig.logCheckInterval && !LCache.exiting; ++i) {
                    MonitorCache.sleep(1000L);
                }
            }
            catch (Exception exception) {
            }
        }
    }
}

