/*
 * Decompiled with CFR 0.152.
 */
package com.novell.naudit.logevent;

import com.novell.naudit.logevent.LogEventException;
import com.novell.naudit.logevent.LogHandle;
import com.novell.naudit.logevent.Monitor;
import com.novell.naudit.util.Constants;
import com.novell.naudit.util.Log;
import com.novell.naudit.util.LogEventConfig;
import com.novell.naudit.util.SLSConnection;
import com.novell.naudit.util.SLSException;
import com.novell.naudit.util.Semaphore;
import com.novell.naudit.util.Util;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.Socket;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class LogEvent
implements Constants {
    private static final String PRODUCT_NAME = "Novell Audit Platform Agent";
    private final String PRODUCT_VERSION = "$Revision:   1.40  $";
    private static final String PRODUCT_SHORT_NAME = "jlogevent";
    public static boolean initialized = false;
    public static Semaphore cacheSem;
    private LogHandle logHandle = null;

    public LogEvent() throws LogEventException {
        if (!initialized) {
            this.logInitialize();
        }
    }

    public void logOpen(String string, String string2, int n) throws LogEventException {
        this.logOpen(null, string, string2, n);
    }

    public void logOpen(String string, String string2, String string3, int n) throws LogEventException {
        try {
            this.doLogOpen(string, string2, string3, n);
        }
        catch (Throwable throwable) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
            Log.log(PRODUCT_SHORT_NAME, "Error: " + byteArrayOutputStream.toString());
            throw new LogEventException(throwable.getMessage(), throwable);
        }
    }

    private void doLogOpen(String string, String string2, String string3, int n) throws LogEventException {
        int n2;
        Object object;
        Object object2;
        if (!initialized) {
            this.logInitialize();
        }
        if ((n & 8) != 0) {
            this.logOpenSimple(string2, string3, n);
            return;
        }
        this.logHandle = new LogHandle();
        this.logHandle.flags = n;
        this.logHandle.magic = 654645623;
        this.logHandle.timeout = 180;
        this.logHandle.primarySocket = null;
        this.logHandle.foSockets = new SLSConnection[LogEventConfig.logFOCount];
        this.logHandle.cacheSocket = null;
        this.logHandle.lock = new Semaphore(1);
        for (int i = 0; i < this.logHandle.foSockets.length; ++i) {
            this.logHandle.foSockets[i] = null;
        }
        long l = System.currentTimeMillis();
        this.logHandle.sessionId = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        if (LogEventConfig.logDebug == -1) {
            this.logHandle.flags |= Integer.MIN_VALUE;
        }
        if (LogEventConfig.logSigned == 1) {
            this.logHandle.flags |= 0x20;
        }
        if ((n & 4) != 0) {
            try {
                object2 = new BufferedReader(new FileReader(string2));
                object = new StringBuffer();
                while (((BufferedReader)object2).ready()) {
                    ((StringBuffer)object).append(((BufferedReader)object2).readLine() + Util.NEW_LINE);
                }
                ((BufferedReader)object2).close();
                this.logHandle.pemCertificate = ((StringBuffer)object).toString();
            }
            catch (IOException iOException) {
                this.logHandle.lastError = 14;
                LogEventException logEventException = new LogEventException("Error opening certificate file: " + string2 + Util.NEW_LINE + iOException.getMessage(), iOException);
                logEventException.setErrorCode(14);
                throw logEventException;
            }
            try {
                object2 = new BufferedReader(new FileReader(string3));
                object = new StringBuffer();
                while (((BufferedReader)object2).ready()) {
                    ((StringBuffer)object).append(((BufferedReader)object2).readLine());
                }
                ((BufferedReader)object2).close();
                this.logHandle.pemPrivateKey = ((StringBuffer)object).toString();
            }
            catch (IOException iOException) {
                this.logHandle.lastError = 15;
                object = new LogEventException("Error opening private key file: " + string3 + Util.NEW_LINE + iOException.getMessage(), iOException);
                ((LogEventException)object).setErrorCode(15);
                throw object;
            }
        }
        if ((n & 0x10) != 0) {
            try {
                this.logHandle.pemCertificate = Util.pemEncodeCertificate(string2);
            }
            catch (Exception exception) {
                this.logHandle.lastError = 14;
                LogEventException logEventException = new LogEventException("Error creating pem encoded certificate: " + Util.NEW_LINE + exception.getMessage(), exception);
                logEventException.setErrorCode(14);
                throw logEventException;
            }
            try {
                this.logHandle.pemPrivateKey = Util.pemEncodePrivateKey(string3);
            }
            catch (Exception exception) {
                this.logHandle.lastError = 15;
                LogEventException logEventException = new LogEventException("Error creating pem encoded private key: " + Util.NEW_LINE + exception.getMessage(), exception);
                logEventException.setErrorCode(15);
                throw logEventException;
            }
        }
        if (string2 != null) {
            this.logHandle.pemCertificate = string2;
            this.logHandle.pemPrivateKey = string3;
        } else {
            this.logHandle.pemCertificate = "";
            this.logHandle.pemPrivateKey = "";
        }
        try {
            object2 = CertificateFactory.getInstance("X.509");
            this.logHandle.certificate = (X509Certificate)((CertificateFactory)object2).generateCertificate(new ByteArrayInputStream(Util.parseCertificate(this.logHandle.pemCertificate).getBytes(Constants.UTF_8)));
            this.logHandle.certs = new X509Certificate[1];
            this.logHandle.certs[0] = this.logHandle.certificate;
            if (string != null && !string.isEmpty()) {
                this.logHandle.appName = string;
            } else {
                object = this.logHandle.certificate.getExtensionValue("2.16.840.1.113719.1.347.10.1");
                if (object == null) {
                    LogEventException logEventException = new LogEventException("No application name was supplied and certificate has no X.509 extension 2.16.840.1.113719.1.347.10.1");
                    logEventException.setErrorCode(16);
                    throw logEventException;
                }
                this.logHandle.appName = new String((byte[])object, 4, ((Object)object).length - 4);
            }
        }
        catch (Exception exception) {
            this.logHandle.lastError = 16;
            object = new LogEventException("Error creating certificate: " + Util.NEW_LINE + exception.getMessage(), exception);
            ((LogEventException)object).setErrorCode(16);
            throw object;
        }
        try {
            object2 = KeyFactory.getInstance(this.logHandle.certificate.getPublicKey().getAlgorithm());
            object = Util.getPrivateKeySpec(this.logHandle.pemPrivateKey);
            this.logHandle.privateKey = ((KeyFactory)object2).generatePrivate((KeySpec)object);
        }
        catch (Exception exception) {
            object = new LogEventException("Error creating certificate: " + Util.NEW_LINE + exception.getMessage(), exception);
            ((LogEventException)object).setErrorCode(17);
            throw object;
        }
        if ((n & 2) == 0 && !this.prepareCache()) {
            Log.log(PRODUCT_SHORT_NAME, "Failed to connect to cache for application " + this.logHandle.appName + ", DISABLING cache mode.");
            n |= 2;
        }
        int n3 = 0;
        object = "";
        boolean bl = false;
        try {
            this.logHandle.primarySocket = new SLSConnection(this.logHandle.appName, this.logHandle.certs, this.logHandle.privateKey, LogEventConfig.logHost, LogEventConfig.logEnginePort);
            n2 = this.logHandle.primarySocket.authenticate();
            if (LogEventConfig.logSigned == 0 && (n2 & 0x40) != 0) {
                this.logHandle.flags |= 0x20;
            }
            if ((n & 0x80) == 0) {
                this.logGetEnabledEvents();
            }
        }
        catch (SLSException sLSException) {
            n3 = sLSException.getErrorCode();
            object = sLSException.getMessage();
            bl = true;
        }
        catch (Exception exception) {
            n3 = 6;
            object = exception.getMessage();
            bl = true;
        }
        if (!bl) {
            return;
        }
        this.logHandle.lastError = n3;
        this.logHandle.useCache = true;
        this.logHandle.socketIndex = 1;
        this.logHandle.offlineTime = System.currentTimeMillis() + (long)(LogEventConfig.logCheckInterval * 1000);
        Log.log(PRODUCT_SHORT_NAME, "Failing primary connection for application " + this.logHandle.appName + ".");
        for (n2 = 0; n2 < LogEventConfig.logFOHost.length; ++n2) {
            ReconnectToServer reconnectToServer = new ReconnectToServer(this.logHandle);
            if (reconnectToServer.connectFOServer(n2 + 2)) {
                this.logHandle.socketIndex = n2 + 2;
                this.logHandle.useCache = false;
                Log.log(PRODUCT_SHORT_NAME, "Switching application " + this.logHandle.appName + " to failover logging server, " + LogEventConfig.logFOHost[n2] + ".");
                return;
            }
            if (this.logHandle.foSockets[n2] != null) {
                this.logHandle.foSockets[n2].closeConnection();
                this.logHandle.foSockets[n2] = null;
            }
            reconnectToServer = null;
        }
        if ((n & 2) != 0) {
            LogEventException logEventException = new LogEventException("Error connecting to log server and cache: " + Util.NEW_LINE + (String)object);
            logEventException.setErrorCode(n3);
            throw logEventException;
        }
    }

    public boolean logGetEnabledEvents() {
        String string = this.logReadAppConfiguration();
        if (string == null) {
            return false;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
            Element element = document.getDocumentElement();
            if (element == null) {
                return false;
            }
            Element element2 = this.getChildNode(element, "EventConfiguration");
            if (element2 == null) {
                return false;
            }
            if (!element2.getAttribute("enabled").equals("true")) {
                this.logHandle.eventListEnabled = false;
                return true;
            }
            this.logHandle.eventListEnabled = true;
            Collection<? extends Element> collection = this.getChildElements(element2, "event");
            if (this.logHandle.eventList == null) {
                this.logHandle.eventList = new Hashtable();
            } else {
                this.logHandle.eventList.clear();
            }
            for (Element element3 : collection) {
                String string2 = element3.getFirstChild().getNodeValue();
                if (string2.length() <= 0) continue;
                try {
                    this.logHandle.eventList.put(new Integer((int)Long.decode("0x" + string2).longValue()), string2);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public Collection<? extends Element> getChildElements(Node node, String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element;
            String string2;
            Node node2 = nodeList.item(i);
            if (!(node2 instanceof Element) || !(string2 = (element = (Element)node2).getNodeName()).equalsIgnoreCase(string)) continue;
            arrayList.add(element);
        }
        return arrayList;
    }

    public Element getChildNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            String string2;
            Node node2 = nodeList.item(i);
            if (!(node2 instanceof Element) || !(string2 = ((Element)node2).getNodeName()).equalsIgnoreCase(string)) continue;
            return (Element)node2;
        }
        return null;
    }

    public boolean prepareCache() {
        try {
            cacheSem.acquire();
            for (int i = 0; i < 15; ++i) {
                try {
                    this.logHandle.cacheSocket = new Socket("127.0.0.1", LogEventConfig.logCachePort);
                    break;
                }
                catch (Exception exception) {
                    if (i == 0) {
                        this.logLoadCache();
                        Thread.sleep(10000L);
                    }
                    this.logHandle.cacheSocket = null;
                    continue;
                }
            }
            if (this.logHandle.cacheSocket == null) {
                cacheSem.release();
                Log.log(PRODUCT_SHORT_NAME, "Unable to connect to lcache");
                return false;
            }
            cacheSem.release();
            DataInputStream dataInputStream = new DataInputStream(this.logHandle.cacheSocket.getInputStream());
            DataOutputStream dataOutputStream = new DataOutputStream(this.logHandle.cacheSocket.getOutputStream());
            int n = Util.getBEInt(dataInputStream.readInt());
            if (n < 4) {
                this.logHandle.cacheSocket.close();
                return false;
            }
            byte[] byArray = this.logHandle.appName.getBytes("UTF-8");
            byte[] byArray2 = LogEventConfig.logHost.getBytes("UTF-8");
            byte[] byArray3 = this.logHandle.pemCertificate.getBytes("UTF-8");
            byte[] byArray4 = this.logHandle.pemPrivateKey.getBytes("UTF-8");
            int n2 = byArray.length + byArray2.length + byArray3.length + byArray4.length + 4;
            dataOutputStream.writeInt(Util.getLEInt(n2));
            dataOutputStream.write(byArray);
            dataOutputStream.writeByte(0);
            dataOutputStream.write(byArray2);
            dataOutputStream.writeByte(0);
            dataOutputStream.write(byArray3);
            dataOutputStream.writeByte(0);
            dataOutputStream.write(byArray4);
            dataOutputStream.writeByte(0);
            dataOutputStream.flush();
            byte by = dataInputStream.readByte();
            if ((by & 1) == 0) {
                this.logHandle.cacheSocket.close();
                return false;
            }
            this.logHandle.cacheOut = dataOutputStream;
            this.logHandle.cacheIn = dataInputStream;
        }
        catch (Exception exception) {
            Log.log(PRODUCT_SHORT_NAME, "Exception while preparing cache: " + exception.getMessage());
            return false;
        }
        return true;
    }

    private void logLoadCache() {
        String string = System.getProperty("file.separator");
        String string2 = System.getProperty("path.separator");
        String string3 = System.getProperty("na.loglevel", "NONE");
        String string4 = System.getProperty("na._logFile", "nproduct.log");
        String string5 = System.getProperty("JAVA_HOME", System.getProperty("java.home"));
        String string6 = System.getProperty("java.class.path");
        if (LogEventConfig.logJavaClassPath != null) {
            if (string6 != null) {
                string6 = string6 + string2;
            }
            string6 = string6 + LogEventConfig.logJavaClassPath;
        }
        String string7 = "-c";
        if (LogEventConfig.logCacheEncrypt) {
            string7 = "-s";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string5 + string + "bin" + string + "java");
        arrayList.add("-Dna.loglevel=" + string3);
        arrayList.add("-Dna._logFile=" + string4);
        if (LogEventConfig.jLogDebug != null) {
            for (String object : LogEventConfig.jLogDebug) {
                arrayList.add(object);
            }
        }
        arrayList.add("-classpath");
        arrayList.add(string6);
        arrayList.add("com.novell.naudit.lcache.LCache");
        arrayList.add("-port:" + LogEventConfig.logCachePort);
        arrayList.add("-slsport:" + LogEventConfig.logEnginePort);
        arrayList.add("-int:" + LogEventConfig.logCheckInterval);
        arrayList.add(string7);
        arrayList.add("-dir:" + LogEventConfig.logCacheDir);
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(arrayList.toArray(new String[arrayList.size()]));
            StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream(), "CACHE ERROR");
            StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream(), "CACHE OUTPUT");
            streamGobbler.start();
            streamGobbler2.start();
        }
        catch (Exception exception) {
            Log.log(PRODUCT_SHORT_NAME, "Exception starting lcache: " + exception.getMessage());
        }
    }

    public void logOpenSimple(String string, String string2, long l) {
    }

    public void logClose() {
        try {
            if (this.logHandle.primarySocket != null) {
                this.logHandle.primarySocket.closeConnection();
            }
            if (this.logHandle.foSockets != null) {
                for (int i = 0; i < this.logHandle.foSockets.length; ++i) {
                    if (this.logHandle.foSockets[i] == null) continue;
                    this.logHandle.foSockets[i].closeConnection();
                    this.logHandle.foSockets[i] = null;
                }
            }
            this.closeCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeCache() throws IOException {
        if (!this.sendCommandRequest(this.logHandle, 1, 81, 0)) {
            return;
        }
        this.flushClient(this.logHandle, 1);
        if (this.logHandle.cacheSocket != null && this.logHandle.cacheSocket.isConnected()) {
            this.logHandle.cacheSocket.close();
        }
    }

    public int logGetError() {
        return this.logHandle.lastError;
    }

    public boolean logEventDirect(String string, int n, int n2, int n3, int n4, String string2, String string3, int n5, int n6, int n7, int n8, byte[] byArray) {
        return this.logEventExt(string, n, n2, n3, n4, null, 0, null, 0, null, string2, string3, null, n5, n6, 0, n7, n8, byArray);
    }

    public boolean logEventExt(String string, int n, int n2, int n3, int n4, String string2, int n5, String string3, int n6, String string4, String string5, String string6, String string7, int n7, int n8, int n9, int n10, int n11, byte[] byArray) {
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        byte[] byArray6 = null;
        byte[] byArray7 = null;
        byte[] byArray8 = null;
        int n20 = 0;
        boolean bl = false;
        if (LogEventConfig.logProtVersion >= 3) {
            n12 |= 0x1000;
        }
        try {
            int n21;
            Object object;
            if (LogEventConfig.dropAllEvents) {
                return true;
            }
            if (this.logHandle == null) {
                return false;
            }
            if (n2 == 8 && (n4 & Integer.MIN_VALUE) != 0) {
                return true;
            }
            if ((this.logHandle.flags & 0x80) == 0 && this.logHandle.eventListEnabled && (object = this.logHandle.eventList.get(new Integer(n))) == null) {
                return true;
            }
            if (string5 != null && (string5 = string5.trim()).length() <= 0) {
                string5 = null;
            }
            if (string6 != null && (string6 = string6.trim()).length() <= 0) {
                string6 = null;
            }
            if (string7 != null && (string7 = string7.trim()).length() <= 0) {
                string7 = null;
            }
            if (string2 != null && (string2 = string2.trim()).length() <= 0) {
                string2 = null;
            }
            if (string3 != null && (string3 = string3.trim()).length() <= 0) {
                string3 = null;
            }
            if (string4 != null && (string4 = string4.trim()).length() <= 0) {
                string4 = null;
            }
            if ((n4 & 1) != 0 && !this.logHandle.useCache) {
                n12 |= 0x20;
            }
            if (string5 != null) {
                n12 |= 1;
                byArray3 = string5.getBytes("UTF-8");
                n14 = byArray3.length + 1;
                if (n14 > 255) {
                    if ((n4 & 0x40) != 0) {
                        this.logHandle.lastError = 1;
                        return false;
                    }
                    string5 = new String(byArray3, 0, 255, "UTF-8").trim();
                    n14 = (byArray3 = string5.getBytes("UTF-8")).length;
                    if (n14 < 255) {
                        ++n14;
                    }
                }
            } else {
                n14 = 0;
            }
            if (string6 != null) {
                n12 |= 2;
                byArray4 = string6.getBytes("UTF-8");
                n15 = byArray4.length + 1;
                if (n15 > 255) {
                    if ((n4 & 0x40) != 0) {
                        this.logHandle.lastError = 1;
                        return false;
                    }
                    string6 = new String(byArray4, 0, 255, "UTF-8").trim();
                    n15 = (byArray4 = string6.getBytes("UTF-8")).length;
                    if (n15 < 255) {
                        ++n15;
                    }
                }
            } else {
                n15 = 0;
            }
            if (string7 != null) {
                n12 |= 0x400;
                byArray5 = string7.getBytes("UTF-8");
                n16 = byArray5.length + 1;
                if (n16 > 255) {
                    if ((n4 & 0x40) != 0) {
                        this.logHandle.lastError = 1;
                        return false;
                    }
                    string7 = new String(byArray5, 0, 255, "UTF-8").trim();
                    n16 = (byArray5 = string7.getBytes("UTF-8")).length;
                    if (n16 < 255) {
                        ++n16;
                    }
                }
            } else {
                n16 = 0;
            }
            if (string2 != null) {
                n12 |= 0x80;
                byArray6 = string2.getBytes("UTF-8");
                n17 = byArray6.length + 1;
                if (n17 > 255) {
                    if ((n4 & 0x40) != 0) {
                        this.logHandle.lastError = 1;
                        return false;
                    }
                    string2 = new String(byArray6, 0, 255, "UTF-8").trim();
                    n17 = (byArray6 = string2.getBytes("UTF-8")).length;
                    if (n17 < 255) {
                        ++n17;
                    }
                }
            } else {
                n17 = 0;
            }
            if (string3 != null) {
                n12 |= 0x100;
                byArray7 = string3.getBytes("UTF-8");
                n18 = byArray7.length + 1;
                if (n18 > 255) {
                    if ((n4 & 0x40) != 0) {
                        this.logHandle.lastError = 1;
                        return false;
                    }
                    string3 = new String(byArray7, 0, 255, "UTF-8").trim();
                    n18 = (byArray7 = string3.getBytes("UTF-8")).length;
                    if (n18 < 255) {
                        ++n18;
                    }
                }
            } else {
                n18 = 0;
            }
            if (string4 != null) {
                n12 |= 0x200;
                byArray8 = string4.getBytes("UTF-8");
                n19 = byArray8.length + 1;
                if (n19 > 255) {
                    if ((n4 & 0x40) != 0) {
                        this.logHandle.lastError = 1;
                        return false;
                    }
                    string4 = new String(byArray8, 0, 255, "UTF-8").trim();
                    n19 = (byArray8 = string4.getBytes("UTF-8")).length;
                    if (n19 < 255) {
                        ++n19;
                    }
                }
            } else {
                n19 = 0;
            }
            if (n11 > 0) {
                n12 |= 0x10;
                if (n11 > 3072) {
                    if (LogEventConfig.allowBigData) {
                        n12 |= 0x40;
                        bl = true;
                        if (n11 > LogEventConfig.logMaxBigData) {
                            if ((n4 & 0x40) != 0) {
                                this.logHandle.lastError = 2;
                                return false;
                            }
                            n11 = LogEventConfig.logMaxBigData;
                        }
                    } else {
                        if ((n4 & 0x40) != 0) {
                            this.logHandle.lastError = 2;
                            return false;
                        }
                        n11 = 3072;
                    }
                }
            }
            if (string != null && (n13 = (byArray2 = string.getBytes("UTF-8")).length + 1 + this.logHandle.appName.length() + 1) > 255) {
                if ((n4 & 0x40) != 0) {
                    this.logHandle.lastError = 3;
                    return false;
                }
                string = new String(byArray2, 0, 255 - this.logHandle.appName.length(), "UTF-8").trim();
                n13 = (byArray2 = string.getBytes("UTF-8")).length + this.logHandle.appName.length();
                if (n13 < 255) {
                    ++n13;
                }
            }
            object = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object);
            int n22 = 0;
            int n23 = 20;
            int n24 = 84;
            dataOutputStream.writeInt(Util.getLEInt(n12));
            dataOutputStream.writeInt(Util.getLEInt(n13));
            dataOutputStream.writeInt(Util.getLEInt(n14));
            dataOutputStream.writeInt(Util.getLEInt(n15));
            dataOutputStream.writeInt(Util.getLEInt(n11));
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(Util.getLEInt((int)(System.currentTimeMillis() / 1000L)));
            dataOutputStream.writeInt(Util.getLEInt(this.logHandle.sequence));
            ++this.logHandle.sequence;
            dataOutputStream.writeInt(Util.getLEInt(n));
            dataOutputStream.writeInt(Util.getLEInt(n2));
            dataOutputStream.writeInt(Util.getLEInt(n3));
            dataOutputStream.writeInt(Util.getLEInt(n7));
            dataOutputStream.writeInt(Util.getLEInt(n8));
            dataOutputStream.writeInt(Util.getLEInt(n10));
            if (LogEventConfig.logProtVersion > 1) {
                dataOutputStream.writeInt(Util.getLEInt(n17));
                dataOutputStream.writeInt(Util.getLEInt(n18));
                dataOutputStream.writeInt(Util.getLEInt(n19));
                dataOutputStream.writeInt(Util.getLEInt(n16));
                dataOutputStream.writeInt(Util.getLEInt(n9));
                dataOutputStream.writeInt(Util.getLEInt(n5));
                dataOutputStream.writeInt(Util.getLEInt(n6));
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(Util.getLEInt(this.logHandle.sessionId));
            }
            dataOutputStream.write(this.logHandle.appName.getBytes("UTF-8"));
            dataOutputStream.write(92);
            dataOutputStream.write(byArray2, 0, (n13 -= this.logHandle.appName.length() + 1) - 1);
            dataOutputStream.writeByte(0);
            if (LogEventConfig.logProtVersion > 1) {
                if (string2 != null) {
                    dataOutputStream.write(byArray6, 0, n17 - 1);
                    dataOutputStream.writeByte(0);
                }
                if (string3 != null) {
                    dataOutputStream.write(byArray7, 0, n18 - 1);
                    dataOutputStream.writeByte(0);
                }
                if (string4 != null) {
                    dataOutputStream.write(byArray8, 0, n19 - 1);
                    dataOutputStream.writeByte(0);
                }
            }
            if (string5 != null) {
                dataOutputStream.write(byArray3, 0, n14 - 1);
                dataOutputStream.writeByte(0);
            }
            if (string6 != null) {
                dataOutputStream.write(byArray4, 0, n15 - 1);
                dataOutputStream.writeByte(0);
            }
            if (string7 != null) {
                dataOutputStream.write(byArray5, 0, n16 - 1);
                dataOutputStream.writeByte(0);
            }
            if (n11 > 0 && !bl) {
                dataOutputStream.write(byArray, 0, n11);
            }
            byte[] byArray9 = ((ByteArrayOutputStream)object).toByteArray();
            n20 = ((ByteArrayOutputStream)object).size();
            this.logHandle.lock.acquire();
            if ((this.logHandle.flags & 0x20) != 0) {
                n12 |= 4;
                this.logHandle.signatureContext = Signature.getInstance("MD5withRSA");
                this.logHandle.signatureContext.initSign(this.logHandle.privateKey);
                this.logHandle.signatureContext.update(this.logHandle.signature);
                this.logHandle.signatureContext.update(byArray9, 4, n20 - 4);
                if (bl) {
                    this.logHandle.signatureContext.update(byArray, 0, n11);
                }
                this.logHandle.signature = this.logHandle.signatureContext.sign();
                this.logHandle.signatureSize = this.logHandle.signature.length;
                dataOutputStream.write(this.logHandle.signature);
                n20 += this.logHandle.signatureSize;
                byArray9 = ((ByteArrayOutputStream)object).toByteArray();
            }
            dataOutputStream.close();
            byte[] byArray10 = Util.getLEBytes(this.logHandle.signatureSize);
            byArray9[n23] = byArray10[0];
            byArray9[n23 + 1] = byArray10[1];
            byArray9[n23 + 2] = byArray10[2];
            byArray9[n23 + 3] = byArray10[3];
            if (LogEventConfig.logProtVersion > 1 && (n21 = Util.getLocalIPAddress(this.logHandle.primarySocket)) != 0) {
                byte[] byArray11 = Util.getLEBytes(n21);
                byArray9[n24] = byArray11[0];
                byArray9[n24 + 1] = byArray11[1];
                byArray9[n24 + 2] = byArray11[2];
                byArray9[n24 + 3] = byArray11[3];
            }
            byte[] byArray12 = Util.getLEBytes(n12);
            byArray9[n22] = byArray12[0];
            byArray9[n22 + 1] = byArray12[1];
            byArray9[n22 + 2] = byArray12[2];
            byArray9[n22 + 3] = byArray12[3];
            if (!this.sendEvent(byArray9, n20, n11, bl, byArray, false)) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        if ((n4 & 1) != 0) {
            if (this.logHandle.socketIndex == 1) {
                this.logHandle.lastError = 13;
                this.logHandle.lock.release();
                return false;
            }
            byte by = 0;
            try {
                by = this.getClientByte(this.logHandle, this.logHandle.socketIndex);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!(by & true)) {
                this.logHandle.lastError = 12;
                this.logHandle.lock.release();
                return false;
            }
        }
        if (0L < this.logHandle.offlineTime && this.logHandle.offlineTime < System.currentTimeMillis()) {
            this.logHandle.lock.release();
            Log.log(PRODUCT_SHORT_NAME, "Attempting to re-establish connection to secure log server for application " + this.logHandle.appName + ".");
            ReconnectToServer reconnectToServer = new ReconnectToServer(this.logHandle);
            if ((this.logHandle.flags & 1) == 0) {
                reconnectToServer.reconnect();
            } else {
                reconnectToServer.start();
            }
        } else {
            this.logHandle.lock.release();
        }
        return true;
    }

    private boolean sendEvent(byte[] byArray, int n, int n2, boolean bl, byte[] byArray2, boolean bl2) {
        int n3;
        int n4;
        boolean bl3 = true;
        try {
            n4 = 69;
            if (LogEventConfig.logProtVersion > 1) {
                n4 = 86;
            }
            n3 = n;
            if (bl) {
                n3 = n + n2;
            }
            if (bl3 = this.sendCommandRequest(this.logHandle, this.logHandle.socketIndex, n4, n3)) {
                bl3 = this.sendClient(this.logHandle, this.logHandle.socketIndex, byArray, 0, n);
                if (bl) {
                    bl3 = this.sendClient(this.logHandle, this.logHandle.socketIndex, byArray2, 0, n2);
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        if (bl3) {
            bl3 = this.flushClient(this.logHandle, this.logHandle.socketIndex);
        }
        if (bl3 && LogEventConfig.logProtVersion >= 3) {
            try {
                n4 = this.getClientByte(this.logHandle, this.logHandle.socketIndex);
                if ((n4 & 1) == 0) {
                    bl3 = false;
                }
            }
            catch (Exception exception) {
                bl3 = false;
            }
        }
        if (!bl3) {
            switch (this.logHandle.socketIndex) {
                case 0: {
                    this.logHandle.offlineTime = System.currentTimeMillis() + (long)(LogEventConfig.logCheckInterval * 1000);
                    if (this.logHandle.foSockets != null && this.logHandle.foSockets.length > 0) {
                        ReconnectToServer reconnectToServer = new ReconnectToServer(this.logHandle);
                        for (n3 = 0; n3 < this.logHandle.foSockets.length; ++n3) {
                            if (this.logHandle.foSockets[n3] != null) {
                                this.logHandle.foSockets[n3].closeConnection();
                                this.logHandle.foSockets[n3] = null;
                            }
                            if (!reconnectToServer.connectFOServer(n3 + 2)) continue;
                            this.logHandle.socketIndex = n3 + 2;
                            Log.log(PRODUCT_SHORT_NAME, "Switching application " + this.logHandle.appName + " to failover log server, " + LogEventConfig.logFOHost[n3] + ".");
                            return this.sendEvent(byArray, n, n2, bl, byArray2, bl2);
                        }
                        reconnectToServer = null;
                    }
                    this.logHandle.socketIndex = 1;
                    this.logHandle.useCache = true;
                    Log.log(PRODUCT_SHORT_NAME, "Switching application " + this.logHandle.appName + " to cache.");
                    return this.sendEvent(byArray, n, n2, bl, byArray2, bl2);
                }
                case 1: {
                    if (bl2 || (this.logHandle.flags & 2) != 0) {
                        Log.log(PRODUCT_SHORT_NAME, "All log channels have failed. Stopping logging of events for application " + this.logHandle.appName + ".");
                        this.logHandle.lastError = 11;
                        this.logHandle.lock.release();
                        return false;
                    }
                    if (!this.prepareCache()) {
                        Log.log(PRODUCT_SHORT_NAME, "Failed to connect to cache for application %s, DISABLING cache mode.");
                    }
                    return this.sendEvent(byArray, n, n2, bl, byArray2, true);
                }
            }
            this.logHandle.offlineTime = System.currentTimeMillis() + (long)(LogEventConfig.logCheckInterval * 1000);
            ++this.logHandle.socketIndex;
            for (int i = this.logHandle.socketIndex; i < this.logHandle.foSockets.length + 2; ++i) {
                ReconnectToServer reconnectToServer;
                if (this.logHandle.foSockets[i] != null) {
                    this.logHandle.foSockets[i].closeConnection();
                    this.logHandle.foSockets[i] = null;
                }
                if ((reconnectToServer = new ReconnectToServer(this.logHandle)).connectFOServer(i)) {
                    this.logHandle.socketIndex = i;
                    Log.log(PRODUCT_SHORT_NAME, "Switching application " + this.logHandle.appName + " to failover log server, " + LogEventConfig.logFOHost[i - 2] + ".");
                    return this.sendEvent(byArray, n, n2, bl, byArray2, bl2);
                }
                reconnectToServer = null;
            }
            this.logHandle.socketIndex = 1;
            this.logHandle.useCache = true;
            Log.log(PRODUCT_SHORT_NAME, "Switching application " + this.logHandle.appName + " from failover log server to cache..");
            return this.sendEvent(byArray, n, n2, bl, byArray2, bl2);
        }
        return true;
    }

    private byte getClientByte(LogHandle logHandle, int n) throws Exception {
        switch (n) {
            case 0: {
                return logHandle.primarySocket.getByte();
            }
            case 1: {
                return logHandle.cacheIn.readByte();
            }
        }
        return logHandle.foSockets[n - 2].getByte();
    }

    private byte[] getClientBytes(LogHandle logHandle, int n, int n2) throws Exception {
        switch (n) {
            case 0: {
                return logHandle.primarySocket.getBytes(n2);
            }
            case 1: {
                byte[] byArray = new byte[n2];
                logHandle.cacheIn.readFully(byArray);
                return byArray;
            }
        }
        return logHandle.foSockets[n - 2].getBytes(n2);
    }

    private int getClientInt(LogHandle logHandle, int n) throws Exception {
        switch (n) {
            case 0: {
                return logHandle.primarySocket.getInt();
            }
            case 1: {
                return logHandle.cacheIn.readInt();
            }
        }
        return logHandle.foSockets[n - 2].getInt();
    }

    private boolean sendClient(LogHandle logHandle, int n, byte[] byArray, int n2, int n3) {
        try {
            switch (n) {
                case 0: {
                    logHandle.primarySocket.sendData(byArray, n2, n3);
                    break;
                }
                case 1: {
                    logHandle.cacheOut.write(byArray, n2, n3);
                    break;
                }
                default: {
                    logHandle.foSockets[n - 2].sendData(byArray, n2, n3);
                    break;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean sendCommandRequest(LogHandle logHandle, int n, int n2, int n3) {
        try {
            n2 = Util.getLEInt(n2);
            if (n3 != 0) {
                n3 = Util.getLEInt(n3);
            }
            switch (n) {
                case 0: {
                    logHandle.primarySocket.sendData(n2);
                    logHandle.primarySocket.sendData(n3);
                    break;
                }
                case 1: {
                    logHandle.cacheOut.writeInt(n2);
                    logHandle.cacheOut.writeInt(n3);
                    break;
                }
                default: {
                    logHandle.foSockets[n - 2].sendData(n2);
                    logHandle.foSockets[n - 2].sendData(n3);
                    break;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean flushClient(LogHandle logHandle, int n) {
        try {
            switch (n) {
                case 0: {
                    logHandle.primarySocket.flushData();
                    break;
                }
                case 1: {
                    this.logHandle.cacheOut.flush();
                    break;
                }
                default: {
                    logHandle.foSockets[n - 2].flushData();
                    break;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean logEventText(String string, int n, int n2, int n3, String string2, String string3) {
        return this.logEventExt(string, n, n2, 0, n3, null, 0, null, 0, null, string2, string3, null, 0, 0, 0, 0, 0, null);
    }

    public boolean logEventNameValue(String string, int n, int n2, int n3, String string2, int n4) {
        return this.logEventExt(string, n, n2, 0, n3, null, 0, null, 0, null, string2, null, null, n4, 0, 0, 0, 0, null);
    }

    public boolean logEventLong(String string, int n, int n2, int n3, int n4, int n5) {
        return this.logEventExt(string, n, n2, 0, n3, null, 0, null, 0, null, null, null, null, n4, n5, 0, 0, 0, null);
    }

    public boolean logEventRaw(String string, int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        return this.logEventExt(string, n, n2, 0, n3, null, 0, null, 0, null, null, null, null, 0, 0, 0, n4, n5, byArray);
    }

    public boolean logAddMonitor(int n) {
        try {
            if (!this.sendCommandRequest(this.logHandle, 0, 68, n)) {
                this.logHandle.lastError = 6;
                return false;
            }
            this.flushClient(this.logHandle, 0);
            byte by = this.getClientByte(this.logHandle, 0);
            return (by & 1) != 0;
        }
        catch (Exception exception) {
            this.logHandle.lastError = 6;
            return true;
        }
    }

    public boolean logRemoveMonitor(int n) {
        try {
            if (!this.sendCommandRequest(this.logHandle, 0, 88, n)) {
                this.logHandle.lastError = 6;
                return false;
            }
            this.flushClient(this.logHandle, 0);
            byte by = this.getClientByte(this.logHandle, 0);
            return (by & 1) != 0;
        }
        catch (Exception exception) {
            this.logHandle.lastError = 6;
            return true;
        }
    }

    public boolean logRemoveMonitorList() {
        if (!this.sendCommandRequest(this.logHandle, 0, 83, 0)) {
            this.logHandle.lastError = 6;
            return false;
        }
        this.flushClient(this.logHandle, 0);
        try {
            byte by = this.getClientByte(this.logHandle, 0);
            return (by & 1) != 0;
        }
        catch (Exception exception) {
            this.logHandle.lastError = 6;
            return true;
        }
    }

    public Monitor logRequestMonitors() {
        if (!this.sendCommandRequest(this.logHandle, 0, 77, 0)) {
            this.logHandle.lastError = 6;
            return null;
        }
        this.flushClient(this.logHandle, 0);
        try {
            Monitor monitor = null;
            Monitor monitor2 = null;
            int n = this.logHandle.primarySocket.getInt();
            for (int i = 0; i < n; ++i) {
                int n2 = this.logHandle.primarySocket.getInt();
                int n3 = this.logHandle.primarySocket.getInt();
                if (monitor == null) {
                    monitor2 = monitor = new Monitor(n2, n3);
                    continue;
                }
                Monitor monitor3 = new Monitor(n2, n3);
                monitor2.setNext(monitor3);
                monitor2 = monitor3;
            }
            return monitor;
        }
        catch (Exception exception) {
            this.logHandle.lastError = 6;
            return null;
        }
    }

    public int logRequestMonitorCount() {
        if (!this.sendCommandRequest(this.logHandle, 0, 77, 0)) {
            this.logHandle.lastError = 6;
            return -1;
        }
        this.flushClient(this.logHandle, 0);
        try {
            int n = this.logHandle.primarySocket.getInt();
            for (int i = 0; i < n; ++i) {
                this.logHandle.primarySocket.getInt();
                this.logHandle.primarySocket.getInt();
            }
            return n;
        }
        catch (Exception exception) {
            this.logHandle.lastError = 6;
            return -1;
        }
    }

    private boolean logInitialize() {
        if (!LogEventConfig.readConfiguration(null)) {
            return false;
        }
        cacheSem = new Semaphore(1);
        initialized = true;
        Log.log(PRODUCT_SHORT_NAME, "Using primary Secure Log Server " + LogEventConfig.logHost + ".");
        return true;
    }

    public String logReadAppConfiguration() {
        try {
            this.sendCommandRequest(this.logHandle, 0, 82, 0);
            this.flushClient(this.logHandle, 0);
            int n = this.getClientInt(this.logHandle, 0);
            if (n == 0) {
                this.logHandle.lastError = 6;
                return null;
            }
            if (n > 0) {
                byte[] byArray = null;
                byArray = this.getClientBytes(this.logHandle, 0, n);
                if (byArray == null) {
                    this.logHandle.lastError = 6;
                    return null;
                }
                return new String(byArray, "UTF-8");
            }
        }
        catch (Exception exception) {
            this.logHandle.lastError = 6;
        }
        return null;
    }

    class StreamGobbler
    extends Thread {
        InputStream is;
        String type;

        StreamGobbler(InputStream inputStream, String string) {
            this.is = inputStream;
            this.type = string;
        }

        @Override
        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.is);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    System.out.println(this.type + ">" + string);
                }
            }
            catch (IOException iOException) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                iOException.printStackTrace(new PrintStream(byteArrayOutputStream));
                Log.log(LogEvent.PRODUCT_SHORT_NAME, "Error: " + byteArrayOutputStream.toString());
            }
        }
    }

    class ReconnectToServer
    extends Thread {
        LogHandle handle = null;

        public ReconnectToServer(LogHandle logHandle) {
            this.handle = logHandle;
        }

        @Override
        public void run() {
            this.reconnect();
        }

        public boolean reconnect() {
            try {
                int n = this.handle.socketIndex;
                ((LogEvent)LogEvent.this).logHandle.primarySocket = new SLSConnection(this.handle.appName, this.handle.certs, this.handle.privateKey, LogEventConfig.logHost, LogEventConfig.logEnginePort);
                ((LogEvent)LogEvent.this).logHandle.primarySocket.authenticate();
                Log.log(LogEvent.PRODUCT_SHORT_NAME, "Application " + ((LogEvent)LogEvent.this).logHandle.appName + " reconnected to Secure Logging Server.");
                this.handle.offlineTime = 0L;
                this.handle.socketIndex = 0;
                if (n != 0 && n != 1) {
                    ((LogEvent)LogEvent.this).logHandle.lock.acquire();
                    if (((LogEvent)LogEvent.this).logHandle.foSockets[n - 2] != null) {
                        ((LogEvent)LogEvent.this).logHandle.foSockets[n - 2].closeConnection();
                        ((LogEvent)LogEvent.this).logHandle.foSockets[n - 2] = null;
                    }
                    ((LogEvent)LogEvent.this).logHandle.lock.release();
                }
            }
            catch (Exception exception) {
                if (this.handle.socketIndex == 1) {
                    for (int i = 0; i < ((LogEvent)LogEvent.this).logHandle.foSockets.length; ++i) {
                        if (((LogEvent)LogEvent.this).logHandle.foSockets[i] != null) {
                            ((LogEvent)LogEvent.this).logHandle.foSockets[i].closeConnection();
                            ((LogEvent)LogEvent.this).logHandle.foSockets[i] = null;
                        }
                        if (this.connectFOServer(i + 2)) {
                            ((LogEvent)LogEvent.this).logHandle.socketIndex = i + 2;
                            Log.log(LogEvent.PRODUCT_SHORT_NAME, "Switching application " + ((LogEvent)LogEvent.this).logHandle.appName + " to failover log server, " + LogEventConfig.logFOHost[i] + ".");
                            break;
                        }
                        if (((LogEvent)LogEvent.this).logHandle.foSockets[i] == null) continue;
                        ((LogEvent)LogEvent.this).logHandle.foSockets[i].closeConnection();
                        ((LogEvent)LogEvent.this).logHandle.foSockets[i] = null;
                    }
                }
                ((LogEvent)LogEvent.this).logHandle.offlineTime = System.currentTimeMillis() + (long)(LogEventConfig.logCheckInterval * 1000);
                return false;
            }
            return true;
        }

        public boolean connectFOServer(int n) {
            try {
                if (((LogEvent)LogEvent.this).logHandle.foSockets[n - 2] != null) {
                    ((LogEvent)LogEvent.this).logHandle.foSockets[n - 2].closeConnection();
                }
                ((LogEvent)LogEvent.this).logHandle.foSockets[n - 2] = new SLSConnection(this.handle.appName, this.handle.certs, this.handle.privateKey, LogEventConfig.logFOHost[n - 2], LogEventConfig.logEnginePort);
                ((LogEvent)LogEvent.this).logHandle.foSockets[n - 2].authenticate();
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
    }
}

