/*
 * Decompiled with CFR 0.152.
 */
package com.novell.naudit.util;

import com.novell.naudit.util.Constants;
import com.novell.naudit.util.Log;
import com.novell.naudit.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;

public class LogEventConfig
implements Constants {
    public static String LOGEVENT_CONFIG_FILE;
    public static String LOGEVENT_CONFIG_FILE_WINNT;
    public static String LOGEVENT_CONFIG_FILE_WINDOWS;
    public static String NAUDIT_TEMP_DIR;
    public static String os;
    public static final int CONTINUE_LOGGING = 0;
    public static final int STOP_LOGGING = 1;
    public static final int DROP_CACHE = 2;
    public static String logHost;
    public static String[] logFOHost;
    public static int logFOCount;
    public static String logCacheCredentials;
    public static String logCacheDir;
    public static int logCachePort;
    public static int logEnginePort;
    public static boolean allowUnload;
    public static boolean allowSSL;
    public static boolean logCacheEncrypt;
    public static boolean allowBigData;
    public static boolean logLocal;
    public static int logCheckInterval;
    public static int logDebug;
    public static int logProtVersion;
    public static boolean logForceVersion;
    public static int logSigned;
    public static int logMaxBigData;
    public static boolean defaultCacheDir;
    public static boolean defaultCachePort;
    public static Collection<String> jLogDebug;
    public static boolean dropAllEvents;
    public static long logMaxCacheSize;
    public static int logCacheLimitAction;
    public static String logJavaClassPath;

    public static boolean readConfiguration(String[] stringArray) {
        try {
            if (stringArray == null || stringArray.length < 1) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(LOGEVENT_CONFIG_FILE)));
                while (bufferedReader.ready()) {
                    Object object;
                    String string = bufferedReader.readLine().trim();
                    if (string.startsWith("#")) continue;
                    if (string.startsWith("LogHost=")) {
                        object = string.substring(8).trim();
                        if (((String)object).equalsIgnoreCase("Not Configured")) {
                            dropAllEvents = true;
                            continue;
                        }
                        String[] stringArray2 = ((String)object).split(",");
                        logHost = stringArray2[0];
                        if (stringArray2.length <= 1) continue;
                        logFOHost = new String[stringArray2.length - 1];
                        for (int i = 1; i < stringArray2.length; ++i) {
                            LogEventConfig.logFOHost[i - 1] = stringArray2[i];
                            ++logFOCount;
                        }
                        continue;
                    }
                    if (string.startsWith("JLogDebug=")) {
                        object = string.substring(10).split(" ");
                        jLogDebug = new ArrayList<String>(((String[])object).length);
                        for (String string2 : object) {
                            jLogDebug.add(string2);
                        }
                        continue;
                    }
                    if (string.startsWith("JLogCacheDir=")) {
                        defaultCacheDir = false;
                        logCacheDir = string.substring(13);
                        continue;
                    }
                    if (string.startsWith("LogEnginePort=")) {
                        logEnginePort = Integer.parseInt(string.substring(14));
                        continue;
                    }
                    if (string.startsWith("JLogCachePort=")) {
                        defaultCachePort = false;
                        logCachePort = Integer.parseInt(string.substring(14));
                        continue;
                    }
                    if (string.startsWith("LogCacheUnload=")) {
                        if (Character.toLowerCase(string.charAt(15)) != 'n') continue;
                        allowUnload = false;
                        continue;
                    }
                    if (string.startsWith("LogCacheSecure=")) {
                        if (Character.toLowerCase(string.charAt(15)) == 'y') {
                            logCacheEncrypt = true;
                            continue;
                        }
                        logCacheEncrypt = false;
                        continue;
                    }
                    if (string.startsWith("LogReconnectInterval=")) {
                        logCheckInterval = Integer.parseInt(string.substring(21));
                        continue;
                    }
                    if (string.startsWith("LogDebug=")) {
                        object = string.substring(9).trim();
                        if (((String)object).equalsIgnoreCase("never")) {
                            logDebug = -1;
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("always")) {
                            logDebug = 1;
                            continue;
                        }
                        if (!((String)object).equalsIgnoreCase("server")) continue;
                        logDebug = 0;
                        continue;
                    }
                    if (string.startsWith("LogSigned=")) {
                        object = string.substring(10).trim();
                        if (((String)object).equalsIgnoreCase("never")) {
                            logSigned = -1;
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("always")) {
                            logSigned = 1;
                            continue;
                        }
                        if (!((String)object).equalsIgnoreCase("server")) continue;
                        logSigned = 0;
                        continue;
                    }
                    if (string.startsWith("ForceServerVersionNumber=")) {
                        object = string.substring(25).trim();
                        if (((String)object).startsWith("1.0.0")) {
                            Log.log("LogEventConfig.readConfiguration()", "[INFO] forced to use Nsure Audit SLS version 1.0.0");
                            logForceVersion = true;
                            logProtVersion = 1;
                            continue;
                        }
                        if (((String)object).startsWith("1.0.1")) {
                            Log.log("LogEventConfig.readConfiguration()", "[INFO] forced to use Nsure Audit SLS version 1.0.1");
                            logForceVersion = true;
                            logProtVersion = 1;
                            continue;
                        }
                        if (((String)object).startsWith("1.0.2")) {
                            Log.log("LogEventConfig.readConfiguration()", "[INFO] forced to use Nsure Audit SLS version 1.0.2");
                            logForceVersion = true;
                            logProtVersion = 2;
                            continue;
                        }
                        if (((String)object).startsWith("1.0.3.P")) {
                            Log.log("LogEventConfig.readConfiguration()", "[INFO] forced to use Nsure Audit SLS version 1.0.3 P1 or newer");
                            logForceVersion = true;
                            logProtVersion = 3;
                            continue;
                        }
                        if (((String)object).startsWith("1.0.3")) {
                            Log.log("LogEventConfig.readConfiguration()", "[INFO] forced to use Nsure Audit SLS version 1.0.3");
                            logForceVersion = true;
                            logProtVersion = 2;
                            continue;
                        }
                        if (((String)object).startsWith("1.0.4")) {
                            Log.log("LogEventConfig.readConfiguration()", "[INFO] forced to use Nsure Audit SLS version 1.0.4");
                            logForceVersion = true;
                            logProtVersion = 3;
                            continue;
                        }
                        if (!((String)object).startsWith("1.0.4.P")) continue;
                        Log.log("LogEventConfig.readConfiguration()", "[INFO] forced to use Nsure Audit SLS version 1.0.4 P1 or newer");
                        logForceVersion = true;
                        logProtVersion = 3;
                        continue;
                    }
                    if (string.startsWith("LogLocal=")) {
                        if (Character.toLowerCase(string.charAt(9)) != 'y') continue;
                        logLocal = true;
                        continue;
                    }
                    if (string.startsWith("LogMaxBigData=")) {
                        logMaxBigData = Integer.parseInt(string.substring(14));
                        allowBigData = true;
                        continue;
                    }
                    if (string.startsWith("LogMaxCacheSize=")) {
                        logMaxCacheSize = Long.parseLong(string.substring(16));
                        continue;
                    }
                    if (string.startsWith("LogCacheLimitAction=stop logging")) {
                        logCacheLimitAction = 1;
                        continue;
                    }
                    if (string.startsWith("LogCacheLimitAction=drop cache")) {
                        logCacheLimitAction = 2;
                        continue;
                    }
                    if (!string.startsWith("LogJavaClassPath=")) continue;
                    logJavaClassPath = string.substring(17);
                }
                bufferedReader.close();
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].startsWith("-dir:")) {
                        logCacheDir = stringArray[i].substring(5);
                        continue;
                    }
                    if (stringArray[i].startsWith("-int:")) {
                        logCheckInterval = Integer.parseInt(stringArray[i].substring(5));
                        continue;
                    }
                    if (stringArray[i].startsWith("-port:")) {
                        logCachePort = Integer.parseInt(stringArray[i].substring(6));
                        continue;
                    }
                    if (stringArray[i].startsWith("-slsport:")) {
                        logEnginePort = Integer.parseInt(stringArray[i].substring(9));
                        continue;
                    }
                    if (stringArray[i].startsWith("-n")) {
                        allowUnload = false;
                        continue;
                    }
                    if (stringArray[i].startsWith("-s")) {
                        logCacheEncrypt = true;
                        continue;
                    }
                    if (!stringArray[i].startsWith("-c")) continue;
                    logCacheEncrypt = false;
                }
            }
            Util.makePath(logCacheDir);
            return true;
        }
        catch (Exception exception) {
            Log.log("LogEventConfig", "Exception reading configuration information: " + exception.getMessage());
            return false;
        }
    }

    static {
        block16: {
            LOGEVENT_CONFIG_FILE = "/etc/logevent.conf";
            LOGEVENT_CONFIG_FILE_WINNT = "c:\\WINNT\\logevent.cfg";
            LOGEVENT_CONFIG_FILE_WINDOWS = "c:\\Windows\\logevent.cfg";
            NAUDIT_TEMP_DIR = "/var/opt/novell/naudit/jcache";
            os = System.getProperty("os.name");
            if (os.toLowerCase().indexOf("windows") != -1) {
                NAUDIT_TEMP_DIR = "/Program Files/Novell/Nsure Audit/jcache";
            } else if (os.toLowerCase().indexOf("netware") != -1) {
                NAUDIT_TEMP_DIR = "sys:/etc/jlogcache";
            } else if (os.toLowerCase().indexOf("solaris") != -1) {
                NAUDIT_TEMP_DIR = "/opt/NOVLnaudit/jcache";
            }
            if (os.toLowerCase().indexOf("windows") != -1) {
                try {
                    Process process = Runtime.getRuntime().exec("cmd /start /c set");
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String string = null;
                    String string2 = null;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        int n;
                        if (!string2.startsWith("SystemRoot") || (n = string2.indexOf("=")) == -1) continue;
                        string = string2.substring(++n).trim();
                        break;
                    }
                    LOGEVENT_CONFIG_FILE = string != null ? string + "\\logevent.cfg" : null;
                }
                catch (Exception exception) {
                    LOGEVENT_CONFIG_FILE = null;
                }
                if (LOGEVENT_CONFIG_FILE == null) {
                    try {
                        if (new File(LOGEVENT_CONFIG_FILE_WINNT).exists()) {
                            LOGEVENT_CONFIG_FILE = LOGEVENT_CONFIG_FILE_WINNT;
                            break block16;
                        }
                        if (new File(LOGEVENT_CONFIG_FILE_WINDOWS).exists()) {
                            LOGEVENT_CONFIG_FILE = LOGEVENT_CONFIG_FILE_WINDOWS;
                            break block16;
                        }
                        throw new Exception("Can't find logevent.cfg");
                    }
                    catch (Exception exception) {
                        Log.log("LogEventConfig", "Can't find logevent.cfg: " + exception.getMessage());
                    }
                }
            } else if (os.toLowerCase().indexOf("netware") != -1) {
                LOGEVENT_CONFIG_FILE = "sys:/etc/logevent.cfg";
            }
        }
        logHost = "127.0.0.1";
        logFOHost = new String[0];
        logFOCount = 0;
        logCacheDir = NAUDIT_TEMP_DIR;
        logCachePort = 1287;
        logEnginePort = 1289;
        allowUnload = true;
        allowSSL = true;
        logCacheEncrypt = false;
        allowBigData = false;
        logLocal = false;
        logCheckInterval = 120;
        logDebug = 0;
        logProtVersion = 4;
        logForceVersion = false;
        logSigned = 0;
        logMaxBigData = 0;
        defaultCacheDir = true;
        defaultCachePort = true;
        jLogDebug = null;
        dropAllEvents = false;
        logMaxCacheSize = -1L;
        logCacheLimitAction = 0;
        logJavaClassPath = null;
    }
}

