/*
 * Decompiled with CFR 0.152.
 */
package com.novell.naudit.util;

import com.novell.naudit.util.Constants;
import com.novell.naudit.util.Log;
import com.novell.naudit.util.LogEventConfig;
import com.novell.naudit.util.SLSException;
import com.novell.naudit.util.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SLSConnection
implements Constants {
    private final String m_appName;
    private final byte[] m_utf8AppName;
    private SSLSocket sslSocket = null;
    private Socket socket = null;
    private DataOutputStream sslout;
    private DataInputStream sslin;
    private DataOutputStream out;
    private DataInputStream in;
    private DataOutputStream tempout;
    private DataInputStream tempin;
    SSLSocketFactory factory;
    String host;
    int port;
    private boolean sslAlways = false;

    public SLSConnection(String string, X509Certificate[] x509CertificateArray, PrivateKey privateKey, String string2, int n) throws SLSException {
        this.m_appName = string != null && string.isEmpty() ? null : string;
        this.m_utf8AppName = (byte[])(this.getAppName() != null ? this.getAppName().getBytes(Constants.UTF_8) : null);
        try {
            String string3 = "novell";
            this.host = string2;
            this.port = n;
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, string3.toCharArray());
            keyStore.setKeyEntry("sls", privateKey, string3.toCharArray(), x509CertificateArray);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, string3.toCharArray());
            TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                public boolean isClientTrusted(X509Certificate[] x509CertificateArray) {
                    return true;
                }

                public boolean isServerTrusted(X509Certificate[] x509CertificateArray) {
                    return true;
                }
            }};
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerArray, null);
            this.factory = sSLContext.getSocketFactory();
            LogEventConfig.readConfiguration(null);
        }
        catch (Exception exception) {
            SLSException sLSException = new SLSException(exception.getMessage());
            sLSException.setErrorCode(9);
            throw sLSException;
        }
    }

    protected String getAppName() {
        return this.m_appName;
    }

    protected byte[] getUtf8AppName() {
        return this.m_utf8AppName;
    }

    public void openConnection() throws Exception {
        this.socket = new Socket(this.host, this.port);
        this.sslSocket = (SSLSocket)this.factory.createSocket(this.socket, this.host, this.port, false);
        String[] stringArray = this.sslSocket.getEnabledProtocols();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("SSLv3") || string.equals("SSLv2Hello")) continue;
            arrayList.add(string);
        }
        this.sslSocket.setEnabledProtocols(arrayList.toArray(new String[arrayList.size()]));
        this.socket.setKeepAlive(true);
        this.socket.setSoTimeout(180000);
        this.openStreams();
    }

    public byte authenticate() throws SLSException, Exception {
        try {
            this.openConnection();
        }
        catch (Exception exception) {
            SLSException sLSException = new SLSException(exception.getMessage());
            sLSException.setErrorCode(6);
            throw sLSException;
        }
        int n = this.in.readByte();
        if (!LogEventConfig.logForceVersion) {
            LogEventConfig.logProtVersion = n;
            Log.log("SLSConnection.authenticate()", "[INFO] SLS reports logging protocol version (" + LogEventConfig.logProtVersion + ")");
            if (LogEventConfig.logProtVersion < 5) {
                Log.log("SLSConnection.authenticate()", "[WARN] SLS is using an older version of lengine and should be upgraded for full functionality");
                if (LogEventConfig.logProtVersion < 2) {
                    Log.log("SLSConnection.authenticate()", "[ERROR] ForceServerVersionNumber has not been enabled in the logevent config file.  When working with log servers from previous versions of audit, ForceServerVersionNumber must be enabled in the logevent config file.");
                    SLSException sLSException = new SLSException("Wrong server version");
                    sLSException.setErrorCode(4);
                    throw sLSException;
                }
                if (LogEventConfig.logProtVersion == 3) {
                    Log.log("SLSConnection.authenticate()", "[WARN] detected Nsure Audit 1.0.3 log server; reverting to 1.0.3 protocol");
                }
            }
        } else {
            n = LogEventConfig.logProtVersion;
        }
        byte by = this.in.readByte();
        byte[] byArray = new byte[by];
        this.in.readFully(byArray);
        int n2 = Util.getLEInt(Util.getLocalIPAddress(this));
        this.out.writeByte(73);
        this.out.writeInt(n2);
        this.out.flush();
        byte by2 = this.in.readByte();
        if ((by2 & 1) == 0) {
            SLSException sLSException = new SLSException("Can't send IP address to sls");
            sLSException.setErrorCode(5);
            throw sLSException;
        }
        if (n >= 5 && this.getAppName() != null) {
            Log.log("SLSConnection.authenticate()", "[INFO] sending application name " + this.getAppName());
            this.out.writeByte(80);
            this.out.writeByte(this.getUtf8AppName().length);
            this.out.write(this.getUtf8AppName());
            this.out.flush();
        }
        this.out.writeByte(84);
        this.out.flush();
        byte by3 = this.in.readByte();
        if ((by3 & 1) == 0) {
            SLSException sLSException = new SLSException("Can't start SSL Session with SLS");
            sLSException.setErrorCode(19);
            throw sLSException;
        }
        byte by4 = this.sslin.readByte();
        if ((by4 & 1) == 0) {
            SLSException sLSException = new SLSException("Authentication failed");
            sLSException.setErrorCode(5);
            throw sLSException;
        }
        if ((by4 & 4) != 0) {
            this.sslAlways = true;
        }
        if (!this.sslAlways) {
            this.sslout.writeInt(Util.getLEInt(78));
            this.sslout.writeInt(0);
            this.sslout.flush();
            byte by5 = this.in.readByte();
            if ((by5 & 1) == 0) {
                SLSException sLSException = new SLSException("Can't stop TLS session with server.");
                sLSException.setErrorCode(18);
                throw sLSException;
            }
        } else {
            this.enableSSLAlways();
        }
        return by4;
    }

    public void sendEventData(byte[] byArray, int n) throws Exception {
        this.out.writeInt(Util.getLEInt(69));
        this.out.writeInt(Util.getLEInt(n));
        this.out.write(byArray);
        this.out.flush();
    }

    public void sendData(byte[] byArray) throws Exception {
        this.out.write(byArray);
    }

    public void sendData(byte[] byArray, int n, int n2) throws Exception {
        this.out.write(byArray, n, n2);
    }

    public void sendData(int n) throws Exception {
        this.out.writeInt(n);
    }

    public void flushData() throws Exception {
        this.out.flush();
    }

    public byte getByte() throws Exception {
        return this.in.readByte();
    }

    public byte[] getBytes(int n) throws Exception {
        byte[] byArray = new byte[n];
        this.in.readFully(byArray);
        return byArray;
    }

    public int getInt() throws Exception {
        return Util.getBEInt(this.in.readInt());
    }

    public void enableSSLAlways() {
        this.tempin = this.in;
        this.tempout = this.out;
        this.in = this.sslin;
        this.out = this.sslout;
    }

    public void disableSSLAlways() {
        this.tempin = this.in;
        this.tempout = this.out;
        this.in = this.tempin;
        this.out = this.tempout;
    }

    public void openStreams() throws IOException {
        this.out = new DataOutputStream(this.socket.getOutputStream());
        this.in = new DataInputStream(this.socket.getInputStream());
        this.sslin = new DataInputStream(this.sslSocket.getInputStream());
        this.sslout = new DataOutputStream(this.sslSocket.getOutputStream());
    }

    public void closeStreams() throws IOException {
        if (this.sslout != null) {
            this.sslout.close();
            this.sslout = null;
        }
        if (this.sslin != null) {
            this.sslin.close();
            this.sslin = null;
        }
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
    }

    public void closeSSL() throws Exception {
        if (this.sslout != null) {
            this.sslout.close();
            this.sslout = null;
        }
        if (this.sslin != null) {
            this.sslin.close();
            this.sslin = null;
        }
        if (this.sslSocket != null) {
            if (!this.sslSocket.isClosed()) {
                this.sslSocket.close();
            }
            this.sslSocket = null;
        }
    }

    public boolean closeConnection() {
        try {
            if (this.socket != null) {
                if (!this.socket.isClosed()) {
                    this.socket.close();
                }
                this.socket = null;
            }
            if (this.sslSocket != null) {
                if (!this.sslSocket.isClosed()) {
                    this.sslSocket.close();
                }
                this.sslSocket = null;
            }
            this.closeStreams();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public Socket getSocket() {
        return this.socket;
    }
}

