/*
 * Decompiled with CFR 0.152.
 */
package com.novell.naudit.util;

import com.novell.naudit.util.Constants;
import com.novell.naudit.util.SLSConnection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.spec.PKCS8EncodedKeySpec;
import org.bouncycastlerelo.asn1.ASN1EncodableVector;
import org.bouncycastlerelo.asn1.ASN1InputStream;
import org.bouncycastlerelo.asn1.ASN1Integer;
import org.bouncycastlerelo.asn1.ASN1OutputStream;
import org.bouncycastlerelo.asn1.ASN1Sequence;
import org.bouncycastlerelo.asn1.DERInteger;
import org.bouncycastlerelo.asn1.DERObject;
import org.bouncycastlerelo.asn1.DERObjectIdentifier;
import org.bouncycastlerelo.asn1.DEROctetString;
import org.bouncycastlerelo.asn1.DERSequence;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Util {
    private static String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    private static String END_CERTIFICATE = "-----END CERTIFICATE-----";
    private static String PKCS1_PK_HEADER = "-----BEGIN RSA PRIVATE KEY-----";
    private static String PKCS1_PK_FOOTER = "-----END RSA PRIVATE KEY-----";
    private static String PKCS8_PK_HEADER = "-----BEGIN PRIVATE KEY-----";
    private static String PKCS8_PK_FOOTER = "-----END PRIVATE KEY-----";
    public static String NEW_LINE = "\r\n";
    private static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String byteToHex(byte by) {
        int n = by & 0xFF;
        int n2 = n & 0xF;
        int n3 = n >>> 4 & 0xF;
        char[] cArray = new char[]{hexChars[n3], hexChars[n2]};
        return String.valueOf(cArray);
    }

    public static void printByteArray(byte[] byArray) {
        int n = byArray.length;
        for (int i = 0; i < n; i += 16) {
            int n2;
            for (n2 = 0; n2 < 16; ++n2) {
                if (i + n2 >= n) {
                    System.out.print("   ");
                    continue;
                }
                System.out.print(Util.byteToHex(byArray[i + n2]) + " ");
            }
            System.out.print("\t");
            for (n2 = 0; n2 < 16 && i + n2 < n; ++n2) {
                byte by = byArray[i + n2];
                if (by >= 33 && by <= 187) {
                    System.out.print((char)by);
                    continue;
                }
                System.out.print(".");
            }
            System.out.println();
        }
    }

    public static void printByteArray(byte[] byArray, int n) {
        for (int i = 0; i < n; i += 16) {
            int n2;
            for (n2 = 0; n2 < 16; ++n2) {
                if (i + n2 >= n) {
                    System.out.print("   ");
                    continue;
                }
                System.out.print(Util.byteToHex(byArray[i + n2]) + " ");
            }
            System.out.print("\t");
            for (n2 = 0; n2 < 16 && i + n2 < n; ++n2) {
                byte by = byArray[i + n2];
                if (by >= 33 && by <= 187) {
                    System.out.print((char)by);
                    continue;
                }
                System.out.print(".");
            }
            System.out.println();
        }
    }

    public static byte[] getIntBytes(int n) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer = byteBuffer.putInt(n);
        byte[] byArray = new byte[4];
        byteBuffer = (ByteBuffer)byteBuffer.position(0);
        byteBuffer.get(byArray);
        return byArray;
    }

    public static int getLEInt(int n) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer = byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer.getInt(0);
    }

    public static int getNativeInt(int n) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.getInt(0);
    }

    public static long getLELong(long l) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.putLong(l);
        byteBuffer = byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer.getLong(0);
    }

    public static byte[] getLEBytes(int n) throws Exception {
        return Util.getIntBytes(Util.getLEInt(n));
    }

    public static int getBEInt(int n) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer = byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(n);
        byteBuffer = byteBuffer.order(ByteOrder.BIG_ENDIAN);
        return byteBuffer.getInt(0);
    }

    public static int getBEInt(byte[] byArray, int n) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.put(0, byArray[n + 3]);
        byteBuffer.put(1, byArray[n + 2]);
        byteBuffer.put(2, byArray[n + 1]);
        byteBuffer.put(3, byArray[n]);
        return byteBuffer.getInt(0);
    }

    public static int getBEIntFromNative(int n) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.putInt(n);
        byteBuffer = byteBuffer.order(ByteOrder.BIG_ENDIAN);
        return byteBuffer.getInt(0);
    }

    public static int getByteOffset(byte by, byte[] byArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (byArray[i] != by) continue;
            return i;
        }
        return -1;
    }

    public static String parseString(int n, int n2, byte[] byArray) {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = byArray.length;
        if (n2 != -1) {
            n3 = n + n2;
        }
        for (int i = n; i < n3 && (c = (char)byArray[i]) != '\u0000'; ++i) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String parseCertificate(String string) {
        int n = string.indexOf(BEGIN_CERTIFICATE);
        if (n == -1) {
            throw new IllegalArgumentException("Invalid PEM-encoded certificate data.");
        }
        int n2 = string.indexOf(END_CERTIFICATE);
        if (n2 == -1) {
            throw new IllegalArgumentException("Invalid PEM-encoded certificate data.");
        }
        return string.substring(n, n2 + END_CERTIFICATE.length());
    }

    public static String pemEncodeCertificate(String string) throws Exception {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(BEGIN_CERTIFICATE + NEW_LINE);
        StringBuilder stringBuilder2 = new StringBuilder(bASE64Encoder.encode(string.getBytes("UTF-8")));
        for (int i = 64; stringBuilder2.length() < i; i += 64 + NEW_LINE.length()) {
            stringBuilder2.insert(i, NEW_LINE);
        }
        stringBuilder.append(NEW_LINE + END_CERTIFICATE + NEW_LINE);
        return stringBuilder.toString();
    }

    public static String pemEncodePrivateKey(String string) throws Exception {
        return Util.pemEncodePrivateKey(string.getBytes(Constants.UTF_8));
    }

    public static String pemEncodePrivateKey(byte[] byArray) throws Exception {
        Object object;
        String string = PKCS1_PK_HEADER;
        String string2 = PKCS1_PK_FOOTER;
        if (byArray.length > 0) {
            object = new ByteArrayInputStream(byArray);
            try (ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)object);){
                ASN1Sequence aSN1Sequence;
                DERObject dERObject = aSN1InputStream.readObject();
                if (dERObject instanceof ASN1Sequence && (aSN1Sequence = (ASN1Sequence)dERObject).size() > 2 && aSN1Sequence.getObjectAt(0) instanceof ASN1Integer && aSN1Sequence.getObjectAt(1) instanceof ASN1Sequence) {
                    string = PKCS8_PK_HEADER;
                    string2 = PKCS8_PK_FOOTER;
                }
            }
        }
        object = new StringBuilder();
        ((StringBuilder)object).append(string + NEW_LINE);
        ((StringBuilder)object).append(new BASE64Encoder().encode(byArray));
        ((StringBuilder)object).append(NEW_LINE + string2 + NEW_LINE);
        return ((StringBuilder)object).toString();
    }

    public static String removeNewLine(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\n' || string.charAt(i) == '\r') continue;
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    public static PKCS8EncodedKeySpec getPrivateKeySpec(String string) throws IllegalArgumentException {
        byte[] byArray;
        String string2 = null;
        int n = string.indexOf(PKCS1_PK_HEADER);
        int n2 = -1;
        if (n > -1) {
            string2 = PKCS1_PK_HEADER;
            n2 = string.indexOf(PKCS1_PK_FOOTER);
        } else {
            n = string.indexOf(PKCS8_PK_HEADER);
            if (n > -1) {
                string2 = PKCS8_PK_HEADER;
                n2 = string.indexOf(PKCS8_PK_FOOTER);
            }
        }
        if (n < 0 || n2 < n) {
            throw new IllegalArgumentException("Invalid PEM private key specification.");
        }
        String string3 = string.substring(n + string2.length(), n2);
        try {
            byArray = new BASE64Decoder().decodeBuffer(string3);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Invalid PEM private key data (invalid Base64)", iOException);
        }
        if (PKCS1_PK_HEADER.equals(string2)) {
            byArray = Util.PKCS1toPKCS8(byArray);
        }
        return new PKCS8EncodedKeySpec(byArray);
    }

    private static byte[] PKCS1toPKCS8(byte[] byArray) {
        DERInteger dERInteger = new DERInteger(0);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERObjectIdentifier("1.2.840.113549.1.1.1"));
        DERSequence dERSequence = new DERSequence(aSN1EncodableVector);
        DEROctetString dEROctetString = new DEROctetString(byArray);
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add(dERInteger);
        aSN1EncodableVector2.add(dERSequence);
        aSN1EncodableVector2.add(dEROctetString);
        DERSequence dERSequence2 = new DERSequence(aSN1EncodableVector2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);){
            aSN1OutputStream.writeObject(dERSequence2);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unexpected error writing ASN.1 data.", iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void makePath(String string) throws Exception {
        File file = new File(string);
        file.mkdirs();
    }

    public static int getLocalIPAddress(SLSConnection sLSConnection) {
        if (sLSConnection != null) {
            try {
                Socket socket = sLSConnection.getSocket();
                InetAddress inetAddress = socket.getLocalAddress();
                return inetAddress.hashCode();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.hashCode();
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

