/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastlerelo.asn1;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastlerelo.asn1.ASN1Object;
import org.bouncycastlerelo.asn1.ASN1SequenceParser;
import org.bouncycastlerelo.asn1.ASN1Set;
import org.bouncycastlerelo.asn1.ASN1TaggedObject;
import org.bouncycastlerelo.asn1.BERSequence;
import org.bouncycastlerelo.asn1.BERTaggedObject;
import org.bouncycastlerelo.asn1.DEREncodable;
import org.bouncycastlerelo.asn1.DERNull;
import org.bouncycastlerelo.asn1.DERObject;
import org.bouncycastlerelo.asn1.DEROutputStream;
import org.bouncycastlerelo.asn1.DERSequence;

public abstract class ASN1Sequence
extends ASN1Object {
    private Vector seq = new Vector();

    public static ASN1Sequence getInstance(Object object) {
        if (object == null || object instanceof ASN1Sequence) {
            return (ASN1Sequence)object;
        }
        if (object instanceof byte[]) {
            try {
                return ASN1Sequence.getInstance(ASN1Object.fromByteArray((byte[])object));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct sequence from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
    }

    public static ASN1Sequence getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        if (bl) {
            if (!aSN1TaggedObject.isExplicit()) {
                throw new IllegalArgumentException("object implicit - explicit expected.");
            }
            return (ASN1Sequence)aSN1TaggedObject.getObject();
        }
        if (aSN1TaggedObject.isExplicit()) {
            if (aSN1TaggedObject instanceof BERTaggedObject) {
                return new BERSequence(aSN1TaggedObject.getObject());
            }
            return new DERSequence(aSN1TaggedObject.getObject());
        }
        if (aSN1TaggedObject.getObject() instanceof ASN1Sequence) {
            return (ASN1Sequence)aSN1TaggedObject.getObject();
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + aSN1TaggedObject.getClass().getName());
    }

    public Enumeration getObjects() {
        return this.seq.elements();
    }

    public ASN1SequenceParser parser() {
        final ASN1Sequence aSN1Sequence = this;
        return new ASN1SequenceParser(){
            private final int max;
            private int index;
            {
                this.max = ASN1Sequence.this.size();
            }

            public DEREncodable readObject() throws IOException {
                DEREncodable dEREncodable;
                if (this.index == this.max) {
                    return null;
                }
                if ((dEREncodable = ASN1Sequence.this.getObjectAt(this.index++)) instanceof ASN1Sequence) {
                    return ((ASN1Sequence)dEREncodable).parser();
                }
                if (dEREncodable instanceof ASN1Set) {
                    return ((ASN1Set)dEREncodable).parser();
                }
                return dEREncodable;
            }

            public DERObject getLoadedObject() {
                return aSN1Sequence;
            }

            public DERObject getDERObject() {
                return aSN1Sequence;
            }
        };
    }

    public DEREncodable getObjectAt(int n) {
        return (DEREncodable)this.seq.elementAt(n);
    }

    public int size() {
        return this.seq.size();
    }

    public int hashCode() {
        Enumeration enumeration = this.getObjects();
        int n = this.size();
        while (enumeration.hasMoreElements()) {
            DEREncodable dEREncodable = this.getNext(enumeration);
            n *= 17;
            n ^= dEREncodable.hashCode();
        }
        return n;
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof ASN1Sequence)) {
            return false;
        }
        ASN1Sequence aSN1Sequence = (ASN1Sequence)dERObject;
        if (this.size() != aSN1Sequence.size()) {
            return false;
        }
        Enumeration enumeration = this.getObjects();
        Enumeration enumeration2 = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            DERObject dERObject2;
            DEREncodable dEREncodable = this.getNext(enumeration);
            DEREncodable dEREncodable2 = this.getNext(enumeration2);
            DERObject dERObject3 = dEREncodable.getDERObject();
            if (dERObject3 == (dERObject2 = dEREncodable2.getDERObject()) || dERObject3.equals(dERObject2)) continue;
            return false;
        }
        return true;
    }

    private DEREncodable getNext(Enumeration enumeration) {
        DEREncodable dEREncodable = (DEREncodable)enumeration.nextElement();
        if (dEREncodable == null) {
            return DERNull.INSTANCE;
        }
        return dEREncodable;
    }

    protected void addObject(DEREncodable dEREncodable) {
        this.seq.addElement(dEREncodable);
    }

    abstract void encode(DEROutputStream var1) throws IOException;

    public String toString() {
        return this.seq.toString();
    }
}

