/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastlerelo.asn1;

import java.io.IOException;
import org.bouncycastlerelo.asn1.ASN1Choice;
import org.bouncycastlerelo.asn1.ASN1Object;
import org.bouncycastlerelo.asn1.ASN1OctetString;
import org.bouncycastlerelo.asn1.ASN1Sequence;
import org.bouncycastlerelo.asn1.ASN1Set;
import org.bouncycastlerelo.asn1.ASN1TaggedObjectParser;
import org.bouncycastlerelo.asn1.DEREncodable;
import org.bouncycastlerelo.asn1.DERObject;
import org.bouncycastlerelo.asn1.DEROutputStream;

public abstract class ASN1TaggedObject
extends ASN1Object
implements ASN1TaggedObjectParser {
    int tagNo;
    boolean empty = false;
    boolean explicit = true;
    DEREncodable obj = null;

    public static ASN1TaggedObject getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        if (bl) {
            return (ASN1TaggedObject)aSN1TaggedObject.getObject();
        }
        throw new IllegalArgumentException("implicitly tagged tagged object");
    }

    public static ASN1TaggedObject getInstance(Object object) {
        if (object == null || object instanceof ASN1TaggedObject) {
            return (ASN1TaggedObject)object;
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
    }

    public ASN1TaggedObject(int n, DEREncodable dEREncodable) {
        this.explicit = true;
        this.tagNo = n;
        this.obj = dEREncodable;
    }

    public ASN1TaggedObject(boolean bl, int n, DEREncodable dEREncodable) {
        this.explicit = dEREncodable instanceof ASN1Choice ? true : bl;
        this.tagNo = n;
        this.obj = dEREncodable;
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof ASN1TaggedObject)) {
            return false;
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)dERObject;
        if (this.tagNo != aSN1TaggedObject.tagNo || this.empty != aSN1TaggedObject.empty || this.explicit != aSN1TaggedObject.explicit) {
            return false;
        }
        return !(this.obj == null ? aSN1TaggedObject.obj != null : !this.obj.getDERObject().equals(aSN1TaggedObject.obj.getDERObject()));
    }

    public int hashCode() {
        int n = this.tagNo;
        if (this.obj != null) {
            n ^= this.obj.hashCode();
        }
        return n;
    }

    public int getTagNo() {
        return this.tagNo;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public DERObject getObject() {
        if (this.obj != null) {
            return this.obj.getDERObject();
        }
        return null;
    }

    public DEREncodable getObjectParser(int n, boolean bl) {
        switch (n) {
            case 17: {
                return ASN1Set.getInstance(this, bl).parser();
            }
            case 16: {
                return ASN1Sequence.getInstance(this, bl).parser();
            }
            case 4: {
                return ASN1OctetString.getInstance(this, bl).parser();
            }
        }
        if (bl) {
            return this.getObject();
        }
        throw new RuntimeException("implicit tagging not implemented for tag: " + n);
    }

    public DERObject getLoadedObject() {
        return this.getDERObject();
    }

    abstract void encode(DEROutputStream var1) throws IOException;

    public String toString() {
        return "[" + this.tagNo + "]" + this.obj;
    }
}

