/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastlerelo.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastlerelo.asn1.ASN1OutputStream;
import org.bouncycastlerelo.asn1.ASN1Sequence;
import org.bouncycastlerelo.asn1.BEROutputStream;
import org.bouncycastlerelo.asn1.DEREncodable;
import org.bouncycastlerelo.asn1.DERObject;
import org.bouncycastlerelo.asn1.DEROctetString;
import org.bouncycastlerelo.asn1.DEROutputStream;

public class BERConstructedOctetString
extends DEROctetString {
    private static final int MAX_LENGTH = 1000;
    private Vector octs;

    private static byte[] toBytes(Vector vector) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i != vector.size(); ++i) {
            try {
                DEROctetString dEROctetString = (DEROctetString)vector.elementAt(i);
                byteArrayOutputStream.write(dEROctetString.getOctets());
                continue;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(vector.elementAt(i).getClass().getName() + " found in input should only contain DEROctetString");
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("exception converting octets " + iOException.toString());
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public BERConstructedOctetString(byte[] byArray) {
        super(byArray);
    }

    public BERConstructedOctetString(Vector vector) {
        super(BERConstructedOctetString.toBytes(vector));
        this.octs = vector;
    }

    public BERConstructedOctetString(DERObject dERObject) {
        super(dERObject);
    }

    public BERConstructedOctetString(DEREncodable dEREncodable) {
        super(dEREncodable.getDERObject());
    }

    public byte[] getOctets() {
        return this.string;
    }

    public Enumeration getObjects() {
        if (this.octs == null) {
            return this.generateOcts().elements();
        }
        return this.octs.elements();
    }

    private Vector generateOcts() {
        Vector<DEROctetString> vector = new Vector<DEROctetString>();
        for (int i = 0; i < this.string.length; i += 1000) {
            int n = i + 1000 > this.string.length ? this.string.length : i + 1000;
            byte[] byArray = new byte[n - i];
            System.arraycopy(this.string, i, byArray, 0, byArray.length);
            vector.addElement(new DEROctetString(byArray));
        }
        return vector;
    }

    public void encode(DEROutputStream dEROutputStream) throws IOException {
        if (dEROutputStream instanceof ASN1OutputStream || dEROutputStream instanceof BEROutputStream) {
            dEROutputStream.write(36);
            dEROutputStream.write(128);
            Enumeration enumeration = this.getObjects();
            while (enumeration.hasMoreElements()) {
                dEROutputStream.writeObject(enumeration.nextElement());
            }
            dEROutputStream.write(0);
            dEROutputStream.write(0);
        } else {
            super.encode(dEROutputStream);
        }
    }

    public static BERConstructedOctetString fromSequence(ASN1Sequence aSN1Sequence) {
        Vector vector = new Vector();
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return new BERConstructedOctetString(vector);
    }
}

