/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastlerelo.asn1;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastlerelo.asn1.ASN1ParsingException;
import org.bouncycastlerelo.asn1.ASN1StreamParser;
import org.bouncycastlerelo.asn1.ASN1TaggedObjectParser;
import org.bouncycastlerelo.asn1.DEREncodable;
import org.bouncycastlerelo.asn1.DERObject;

public class BERTaggedObjectParser
implements ASN1TaggedObjectParser {
    private boolean _constructed;
    private int _tagNumber;
    private ASN1StreamParser _parser;

    protected BERTaggedObjectParser(int n, int n2, InputStream inputStream) {
        this((n & 0x20) != 0, n2, new ASN1StreamParser(inputStream));
    }

    BERTaggedObjectParser(boolean bl, int n, ASN1StreamParser aSN1StreamParser) {
        this._constructed = bl;
        this._tagNumber = n;
        this._parser = aSN1StreamParser;
    }

    public boolean isConstructed() {
        return this._constructed;
    }

    public int getTagNo() {
        return this._tagNumber;
    }

    public DEREncodable getObjectParser(int n, boolean bl) throws IOException {
        if (bl) {
            if (!this._constructed) {
                throw new IOException("Explicit tags must be constructed (see X.690 8.14.2)");
            }
            return this._parser.readObject();
        }
        return this._parser.readImplicit(this._constructed, n);
    }

    public DERObject getLoadedObject() throws IOException {
        return this._parser.readTaggedObject(this._constructed, this._tagNumber);
    }

    public DERObject getDERObject() {
        try {
            return this.getLoadedObject();
        }
        catch (IOException iOException) {
            throw new ASN1ParsingException(iOException.getMessage());
        }
    }
}

