/*
 * Decompiled with CFR 0.152.
 */
package novell.jclient;

import novell.jclient.JCException;
import novell.jclient.JCValue;
import novell.jclient.JCValueIterator;
import novell.jclient.JClient;

public class JCEntry {
    private volatile transient byte[] rawBuffer = null;
    private int valueCount = 0;

    private final void setRawBufferAndCount(byte[] byArray, int n) {
        this.rawBuffer = byArray;
        this.valueCount = n;
    }

    private final byte[] getRawBuffer() {
        return this.rawBuffer;
    }

    private final int getValueCount() {
        return this.valueCount;
    }

    public JCValueIterator findValue(String string) throws JCException {
        int n = this.findValueCursor(string);
        return new JCValueIteratorImpl(n);
    }

    private native int findValueCursor(String var1) throws JCException;

    private native JCValue getValueAtCursor(int var1) throws JCException;

    public JCValueIterator createIterator() {
        return new JCValueIteratorImpl();
    }

    public native void cleanup();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            this.cleanup();
        }
        finally {
            JClient.cleanup();
        }
    }

    public String toString() {
        return "rawBuffer " + new String(this.rawBuffer);
    }

    static {
        JClient.loadLibrary();
    }

    protected class JCValueIteratorImpl
    implements JCValueIterator {
        protected int current;

        public JCValueIteratorImpl() {
            this.goFirst();
        }

        public JCValueIteratorImpl(int n) {
            this.current = n;
        }

        @Override
        public void goFirst() {
            this.current = 1;
        }

        @Override
        public void goLast() {
            this.current = JCEntry.this.valueCount;
        }

        @Override
        public void next() {
            if (this.current > 0 && this.current <= JCEntry.this.valueCount) {
                ++this.current;
            }
        }

        @Override
        public void previous() {
            if (this.current > 0 && this.current <= JCEntry.this.valueCount) {
                --this.current;
            }
        }

        @Override
        public boolean isValid() {
            return this.current > 0 && this.current <= JCEntry.this.valueCount;
        }

        @Override
        public JCValue current() throws JCException {
            if (this.current > 0 && this.current <= JCEntry.this.valueCount) {
                return JCEntry.this.getValueAtCursor(this.current);
            }
            return null;
        }

        public Object clone() {
            return new JCValueIteratorImpl(this.current);
        }
    }
}

