/*
 * Decompiled with CFR 0.152.
 */
package novell.jclient;

import novell.jclient.JCCIstringValue;
import novell.jclient.JCClassnameValue;
import novell.jclient.JCContext;
import novell.jclient.JCEntryData;
import novell.jclient.JCEntryIterator;
import novell.jclient.JCEntryIteratorSortKey;
import novell.jclient.JCException;
import novell.jclient.JCLong;
import novell.jclient.JCReadFilter;
import novell.jclient.JCSearchExp;
import novell.jclient.JCSearchFilter;
import novell.jclient.JCSearchSubExp;
import novell.jclient.JCTimestamp;
import novell.jclient.JClient;

class JCEntryVList
implements JCEntryIterator {
    protected long nativeHandle;
    protected JCContext context;
    protected JCSearchFilter searchFilter;
    protected JCEntryIteratorSortKey sortKey;

    private JCEntryVList(JCContext jCContext, long l, JCSearchFilter jCSearchFilter, JCEntryIteratorSortKey jCEntryIteratorSortKey) throws JCException {
        JClient.initialize();
        this.context = jCContext.duplicate();
        this.searchFilter = jCSearchFilter;
        this.nativeHandle = l;
        this.sortKey = this.sortKey;
    }

    JCEntryVList(JCContext jCContext, String[] stringArray, String[] stringArray2, int n, JCEntryIteratorSortKey jCEntryIteratorSortKey) throws JCException {
        JClient.initialize();
        JCReadFilter jCReadFilter = new JCReadFilter(false, null, stringArray2);
        JCSearchExp jCSearchExp = null;
        if (stringArray == null || stringArray.length == 0) {
            jCSearchExp = new JCSearchExp(new JCClassnameValue("Object Class", 17, 0L, new JCTimestamp(), "*"));
        } else {
            JCSearchExp[] jCSearchExpArray = new JCSearchExp[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                jCSearchExpArray[i] = new JCSearchExp(new JCCIstringValue(stringArray[i], 15, 0L, new JCTimestamp(), stringArray[i]));
            }
            JCSearchSubExp jCSearchSubExp = new JCSearchSubExp(jCSearchExpArray);
            jCSearchExp = new JCSearchExp(1, jCSearchSubExp);
        }
        this.searchFilter = new JCSearchFilter((long)n, false, 2L, -1L, 1048575L, 1L, jCReadFilter, jCSearchExp);
        this.context = jCContext.duplicate();
        this.sortKey = jCEntryIteratorSortKey;
        this.nativeHandle = this.initVlistIterator(this.context, this.searchFilter, jCEntryIteratorSortKey);
    }

    JCEntryVList(JCContext jCContext, JCSearchFilter jCSearchFilter, JCEntryIteratorSortKey jCEntryIteratorSortKey) throws JCException {
        JClient.initialize();
        this.context = jCContext.duplicate();
        this.searchFilter = jCSearchFilter;
        jCSearchFilter.entryFlags |= 1L;
        this.sortKey = jCEntryIteratorSortKey;
        this.nativeHandle = this.initVlistIterator(this.context, jCSearchFilter, jCEntryIteratorSortKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
            this.close();
        }
        finally {
            JClient.cleanup();
        }
    }

    @Override
    public int getPosition(int n) throws JCException {
        return this.getVlistPosition(this.nativeHandle, n);
    }

    @Override
    public void setPosition(int n, int n2) throws JCException {
        this.setVlistPosition(this.nativeHandle, n, n2);
    }

    @Override
    public void setPosition(JCEntryIterator jCEntryIterator, int n) throws JCException {
        JCEntryVList jCEntryVList = (JCEntryVList)jCEntryIterator;
        this.setVlistPositionFromIterator(this.nativeHandle, jCEntryVList.nativeHandle, n);
    }

    @Override
    public void setPosition(String string, String string2, int n) throws JCException {
        this.typedownVList(this.nativeHandle, 0, string, string2, n);
    }

    @Override
    public void setPosition(int n, String string, int n2) throws JCException {
        this.typedownVList(this.nativeHandle, n, null, string, n2);
    }

    @Override
    public void setSortKey(JCEntryIteratorSortKey jCEntryIteratorSortKey) throws JCException {
        this.setVlistIndex(this.nativeHandle, jCEntryIteratorSortKey);
    }

    @Override
    public long skip(long l, int n) throws JCException {
        return this.skipVlist(this.nativeHandle, l, n);
    }

    @Override
    public JCEntryData first(int n) throws JCException {
        JCEntryData[] jCEntryDataArray = this.getVlistItem(this.nativeHandle, this.context, 3, 1L, n);
        if (jCEntryDataArray.length != 1) {
            return null;
        }
        return jCEntryDataArray[0];
    }

    @Override
    public JCEntryData last(int n) throws JCException {
        JCEntryData[] jCEntryDataArray = this.getVlistItem(this.nativeHandle, this.context, 4, 1L, n);
        if (jCEntryDataArray.length != 1) {
            return null;
        }
        return jCEntryDataArray[0];
    }

    @Override
    public JCEntryData next(int n) throws JCException {
        JCEntryData[] jCEntryDataArray = this.getVlistItem(this.nativeHandle, this.context, 1, 1L, n);
        if (jCEntryDataArray.length != 1) {
            return null;
        }
        return jCEntryDataArray[0];
    }

    @Override
    public JCEntryData[] next(int n, int n2) throws JCException {
        if (n < 0) {
            n = 0;
        }
        return this.getVlistItem(this.nativeHandle, this.context, 1, n, n2);
    }

    @Override
    public JCEntryData previous(int n) throws JCException {
        JCEntryData[] jCEntryDataArray = this.getVlistItem(this.nativeHandle, this.context, 2, 1L, n);
        if (jCEntryDataArray.length != 1) {
            return null;
        }
        return jCEntryDataArray[0];
    }

    @Override
    public JCEntryData[] previous(int n, int n2) throws JCException {
        if (n < 0) {
            n = 0;
        }
        return this.getVlistItem(this.nativeHandle, this.context, 2, n, n2);
    }

    @Override
    public JCEntryData current() throws JCException {
        JCEntryData[] jCEntryDataArray = this.getVlistItem(this.nativeHandle, this.context, 0, 1L, 0);
        if (jCEntryDataArray.length != 1) {
            return null;
        }
        return jCEntryDataArray[0];
    }

    @Override
    public boolean atEof() throws JCException {
        return this.isVlistIteratorAtEof(this.nativeHandle);
    }

    @Override
    public boolean atBof() throws JCException {
        return this.isVlistIteratorAtBof(this.nativeHandle);
    }

    @Override
    public boolean atLast() throws JCException {
        return this.isVlistIteratorAtLast(this.nativeHandle);
    }

    @Override
    public boolean atFirst() throws JCException {
        return this.isVlistIteratorAtFirst(this.nativeHandle);
    }

    @Override
    public long count(int n) throws JCException {
        return this.getVlistCount(this.nativeHandle, 0L, n);
    }

    @Override
    public long count(long l, int n) throws JCException {
        return this.getVlistCount(this.nativeHandle, l, n);
    }

    @Override
    public synchronized void close() {
        if (this.nativeHandle != 0L) {
            this.termVlistIterator(this.nativeHandle);
            this.nativeHandle = 0L;
        }
        if (this.context != null) {
            this.context.free();
            this.context = null;
        }
        this.searchFilter = null;
        this.sortKey = null;
    }

    @Override
    public boolean isPositionable() {
        if (this.nativeHandle == 0L) {
            return false;
        }
        return this.isVlistIteratorPositionable(this.nativeHandle);
    }

    @Override
    public boolean isScalable() {
        try {
            JCLong jCLong = new JCLong();
            this.context.getCompatInfo(jCLong);
            if (jCLong.longValue() >= 800L) {
                return true;
            }
        }
        catch (JCException jCException) {
            // empty catch block
        }
        return false;
    }

    private native long initVlistIterator(JCContext var1, JCSearchFilter var2, JCEntryIteratorSortKey var3);

    private native void termVlistIterator(long var1);

    private native boolean isVlistIteratorPositionable(long var1);

    private native int getVlistPosition(long var1, int var3) throws JCException;

    private native void setVlistPosition(long var1, int var3, int var4) throws JCException;

    private native void setVlistPositionFromIterator(long var1, long var3, int var5) throws JCException;

    private native void setVlistIndex(long var1, JCEntryIteratorSortKey var3) throws JCException;

    private native long getVlistCount(long var1, long var3, int var5) throws JCException;

    private native long skipVlist(long var1, long var3, int var5) throws JCException;

    private native boolean isVlistIteratorAtEof(long var1);

    private native boolean isVlistIteratorAtFirst(long var1);

    private native boolean isVlistIteratorAtBof(long var1);

    private native boolean isVlistIteratorAtLast(long var1);

    private native long copyVlistIterator(long var1, JCSearchFilter var3);

    private native void typedownVList(long var1, int var3, String var4, String var5, int var6) throws JCException;

    private native JCEntryData[] getVlistItem(long var1, JCContext var3, int var4, long var5, int var7) throws JCException;
}

