/*
 * Decompiled with CFR 0.152.
 */
package novell.jclient;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import novell.jclient.JCContext;
import novell.jclient.JCEntryInfo;
import novell.jclient.JCException;
import novell.jclient.JCListFilter;
import novell.jclient.JClient;

public class JCListEnumerator
implements Enumeration {
    private JCContext context;
    private JCListFilter filter;
    private int infoFlags;
    JCEntryInfo[] listElements;
    private int listElementsIdx;

    public JCListEnumerator(JCContext jCContext, int n) throws JCException {
        try {
            this.context = jCContext.duplicate();
            this.filter = new JCListFilter();
            this.infoFlags = n;
            this.listElements = new JCEntryInfo[0];
            this.listElementsIdx = 0;
        }
        catch (JCException jCException) {
            throw new JCException("JCListEnumerator", jCException);
        }
    }

    public JCListEnumerator(JCContext jCContext, int n, JCListFilter jCListFilter) throws JCException {
        try {
            this.context = jCContext.duplicate();
            this.filter = jCListFilter;
            this.infoFlags = n;
            this.listElements = new JCEntryInfo[0];
            this.listElementsIdx = 0;
        }
        catch (JCException jCException) {
            throw new JCException("JCListEnumerator", jCException);
        }
    }

    @Override
    public boolean hasMoreElements() {
        if (this.listElementsIdx < this.listElements.length) {
            return true;
        }
        try {
            if (JClient.listToJCListEnumerator(this.context, this.filter, this.infoFlags, this) > 0) {
                this.listElementsIdx = 0;
                return true;
            }
        }
        catch (JCException jCException) {
            // empty catch block
        }
        return false;
    }

    public Object nextElement() throws NoSuchElementException {
        if (this.listElementsIdx < this.listElements.length) {
            return this.listElements[this.listElementsIdx++];
        }
        try {
            if (JClient.listToJCListEnumerator(this.context, this.filter, this.infoFlags, this) > 0) {
                this.listElementsIdx = 0;
                return this.listElements[this.listElementsIdx++];
            }
        }
        catch (JCException jCException) {
            // empty catch block
        }
        throw new NoSuchElementException();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("context               : " + this.context + "\n" + "filter                : " + this.filter + "\n" + "infoFlags             : " + Integer.toHexString(this.infoFlags) + " (hex)\n" + "listElementsIdx       : " + this.listElementsIdx + "\n" + "listElements.length   : " + this.listElements.length);
        return stringBuffer.toString();
    }
}

