/*
 * Decompiled with CFR 0.152.
 */
package novell.jclient;

import java.net.InetAddress;

public class JCNetworkAddress {
    private int type;
    private byte[] address;

    public JCNetworkAddress() {
        this.type = 0;
        this.address = new byte[0];
    }

    public JCNetworkAddress(int n, byte[] byArray) {
        this.setAddress(n, byArray);
    }

    public JCNetworkAddress(long l, long l2, long l3) {
        this.setIPXAddress(l, l2, l3);
    }

    public JCNetworkAddress(int n, int n2, int n3, int n4, int n5, long l) {
        this.setInetAddress(n2, n3, n4, n5, l, n);
    }

    public JCNetworkAddress(int n, String string, long l) {
        this.setInetAddress(string, l, n);
    }

    public JCNetworkAddress(int n, InetAddress inetAddress, long l) {
        this.setInetAddress(inetAddress, l, n);
    }

    public int toNumber() {
        return this.type;
    }

    public String toString() {
        StringBuffer stringBuffer;
        String string;
        int n = 1;
        switch (this.type) {
            case 0: {
                string = "IPX";
                break;
            }
            case 1: {
                string = "IP";
                break;
            }
            case 2: {
                string = "SDLC";
                break;
            }
            case 3: {
                string = "TOKENRING";
                break;
            }
            case 4: {
                string = "OSI";
                break;
            }
            case 5: {
                string = "APPLETALK";
                break;
            }
            case 6: {
                string = "NETBEUI";
                break;
            }
            case 7: {
                string = "SOCKADDR";
                break;
            }
            case 8: {
                string = "UDP";
                break;
            }
            case 9: {
                string = "TCP";
                break;
            }
            case 10: {
                string = "UDP6";
                break;
            }
            case 11: {
                string = "TCP6";
                break;
            }
            case 12: {
                string = "INTERNAL";
                break;
            }
            case 13: {
                string = "URL";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        if (this.address != null) {
            stringBuffer = new StringBuffer();
            for (int i = 0; i < this.address.length; ++i) {
                int n2;
                if (this.type == 0 && (i == 4 || i == 10)) {
                    stringBuffer.append(":");
                }
                if (!(this.type != 9 && this.type != 8 || i != 2 && i != 3 && i != 4 && i != 5)) {
                    stringBuffer.append(":");
                }
                if ((this.type == 11 || this.type == 10) && i == 2 * n) {
                    ++n;
                    stringBuffer.append(":");
                }
                if ((n2 = this.address[i] & 0xFF) <= 15) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(Integer.toHexString(n2));
            }
        } else {
            stringBuffer = new StringBuffer("null");
        }
        return "Network Address Type=" + this.type + " (" + string + "), Address=" + stringBuffer;
    }

    public int getType() {
        return this.type;
    }

    public int getLength() {
        return this.address.length;
    }

    public byte[] getAddress() {
        return this.address;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setAddress(byte[] byArray) {
        this.address = byArray;
    }

    public void setAddress(int n, byte[] byArray) {
        this.type = n;
        this.address = byArray;
    }

    public void setIPXAddress(long l, long l2, long l3) {
        this.type = 0;
        this.address = new byte[12];
        this.address[0] = (byte)((l >>> 24) % 256L);
        this.address[1] = (byte)((l >>> 16) % 256L);
        this.address[2] = (byte)((l >>> 8) % 256L);
        this.address[3] = (byte)(l % 256L);
        this.address[4] = (byte)((l2 >>> 40) % 256L);
        this.address[5] = (byte)((l2 >>> 32) % 256L);
        this.address[6] = (byte)((l2 >>> 24) % 256L);
        this.address[7] = (byte)((l2 >>> 16) % 256L);
        this.address[8] = (byte)((l2 >>> 8) % 256L);
        this.address[9] = (byte)(l2 % 256L);
        this.address[10] = (byte)((l3 >>> 8) % 256L);
        this.address[11] = (byte)(l3 % 256L);
    }

    private void setInetAddress(String string, long l, int n) {
        this.type = n;
        this.address = n == 11 || n == 10 ? new byte[18] : new byte[6];
        this.address[0] = (byte)((l >>> 8) % 256L);
        this.address[1] = (byte)(l % 256L);
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            byte[] byArray = inetAddress.getAddress();
            for (int i = 0; i < byArray.length; ++i) {
                this.address[i + 2] = byArray[i];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setInetAddress(InetAddress inetAddress, long l, int n) {
        this.type = n;
        this.address = n == 11 || n == 10 ? new byte[18] : new byte[6];
        this.address[0] = (byte)((l >>> 8) % 256L);
        this.address[1] = (byte)(l % 256L);
        byte[] byArray = inetAddress.getAddress();
        for (int i = 0; i < byArray.length; ++i) {
            this.address[i + 2] = byArray[i];
        }
    }

    private void setInetAddress(int n, int n2, int n3, int n4, long l, int n5) {
        this.type = n5;
        this.address = new byte[6];
        this.address[0] = (byte)((l >>> 8) % 256L);
        this.address[1] = (byte)(l % 256L);
        this.address[2] = (byte)(n % 256);
        this.address[3] = (byte)(n2 % 256);
        this.address[4] = (byte)(n3 % 256);
        this.address[5] = (byte)(n4 % 256);
    }

    public void setTCPAddress(String string, long l) {
        this.setInetAddress(string, l, 9);
    }

    public void setTCPAddress(InetAddress inetAddress, long l) {
        this.setInetAddress(inetAddress, l, 9);
    }

    public void setTCPAddress(int n, int n2, int n3, int n4, long l) {
        this.setInetAddress(n, n2, n3, n4, l, 9);
    }

    public void setTCPAddress(long l, long l2) {
        this.setInetAddress((int)((l >>> 24) % 256L), (int)((l >>> 16) % 256L), (int)((l >>> 8) % 256L), (int)(l % 256L), l2, 9);
    }

    public void setUDPAddress(String string, long l) {
        this.setInetAddress(string, l, 8);
    }

    public void setUDPAddress(InetAddress inetAddress, long l) {
        this.setInetAddress(inetAddress, l, 8);
    }

    public void setUDPAddress(int n, int n2, int n3, int n4, long l) {
        this.setInetAddress(n, n2, n3, n4, l, 8);
    }

    public void setUDPAddress(long l, long l2) {
        this.setInetAddress((int)((l >>> 24) % 256L), (int)((l >>> 16) % 256L), (int)((l >>> 8) % 256L), (int)(l % 256L), l2, 8);
    }
}

