/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.base.DGUtilities;
import com.novell.emframe.base.NGUtilities;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.JobData;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eDirAccessService;
import com.novell.emframe.dev.rights.eDirRightsObject;
import com.novell.emframe.fw.EdasRightsData;
import com.novell.emframe.fw.FakeRightsCache;
import com.novell.emframe.fw.RightsCache;
import com.novell.nps.gadgetManager.GadgetInstance;
import com.novell.webaccess.common.I18NServletRequest;
import java.util.Properties;

public class DGCreateTask
extends Task {
    public static final String NESTED_GROUP_CLASS_NAME = "nestedGroupAux";
    private static final String DYNAMIC_GROUP_CLASS_NAME = "dynamicGroupAux";

    public boolean execute(TaskContext context, Properties resultStrings) {
        I18NServletRequest req = (I18NServletRequest)context.getRequest();
        String eDirCommand = req.getParameter("eDirCommand");
        String nextState = req.getParameter("nextState");
        String selectedClass = req.getParameter("SelectedClass");
        String sAction = req.getParameter("NPAction");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            req.setParameter("merge", "base/DGCreateGroup");
            req.setParameter("SelectedClass", selectedClass);
            req.setAttribute("edasRights", (Object)new EdasRightsData((RightsCache)new FakeRightsCache()));
            resultStrings.put("OS.TypeFilter", this.getOSFilters(context));
            DGUtilities.outputCanChangeDynamicSetting((MContext)context, req);
            NGUtilities.outputCanChangeNestedSetting((MContext)context, (I18NServletRequest)req);
        } else if (nextState.equalsIgnoreCase("eDasServiceAccess") || eDirCommand != null && eDirCommand.equalsIgnoreCase("create")) {
            AuthenticationBroker broker = context.getAuthenticationBroker();
            ObjectEntry oeRoot = (ObjectEntry)broker.getAPIObject("NDSNamespace");
            NDSNamespace ndsNamespace = (NDSNamespace)oeRoot.getNamespace();
            eDirAccessService edas = new eDirAccessService();
            boolean edasFlag = edas.execute(context, resultStrings);
            resultStrings.put("dev.refreshOV", "true");
            String groupDN = req.getParameter("eDir$target") + "." + req.getParameter("eDir$target$createContext");
            JobData data = JobData.getJobData((GadgetInstance)this);
            if (null != data) {
                data.setObjectNames(new String[]{groupDN});
            }
            if (edasFlag) {
                ObjectEntry oe = null;
                try {
                    ObjectAttribute oa;
                    AttributeDefinition attrDef;
                    SchemaDefinition sd = ndsNamespace.getSchemaDefinition(oeRoot);
                    oe = ndsNamespace.getObjectEntry(oeRoot, groupDN);
                    String setOwnerFlag = req.getParameter("setOwner");
                    if (setOwnerFlag != null && setOwnerFlag.equals("on")) {
                        ObjectEntry ownerOE = ndsNamespace.getAuthenticatedIdentity(oeRoot);
                        String ownerName = ndsNamespace.getUnrootedName(ownerOE);
                        StringValue vc = new StringValue((Syntax)NDSSyntax.SYN_DIST_NAME, ownerName);
                        AttributeDefinition attrDef2 = sd.getAttributeDefinition("Owner");
                        ObjectAttribute oa2 = new ObjectAttribute(attrDef2);
                        oa2.addComponent((ValueComponent)vc);
                        ndsNamespace.setAttribute(oe, oa2);
                    }
                    String nestedFlag = req.getParameter("makeNestedGroup");
                    String dynamicFlag = req.getParameter("makeDynamicGroup");
                    if (nestedFlag != null && nestedFlag.equals("on") && dynamicFlag != null && dynamicFlag.equals("on")) {
                        sd = ndsNamespace.getSchemaDefinition(oe);
                        attrDef = sd.getAttributeDefinition("Object Class");
                        oa = new ObjectAttribute(attrDef);
                        StringValue vcN = new StringValue((Syntax)NDSSyntax.SYN_CLASS_NAME, NESTED_GROUP_CLASS_NAME);
                        oa.addComponent((ValueComponent)vcN);
                        StringValue vcD = new StringValue((Syntax)NDSSyntax.SYN_CLASS_NAME, DYNAMIC_GROUP_CLASS_NAME);
                        oa.addComponent((ValueComponent)vcD);
                        ndsNamespace.setAttribute(oe, oa);
                    }
                    if (nestedFlag != null && nestedFlag.equals("on") && (dynamicFlag == null || !dynamicFlag.equals("on"))) {
                        sd = ndsNamespace.getSchemaDefinition(oe);
                        attrDef = sd.getAttributeDefinition("Object Class");
                        oa = new ObjectAttribute(attrDef);
                        StringValue vc = new StringValue((Syntax)NDSSyntax.SYN_CLASS_NAME, NESTED_GROUP_CLASS_NAME);
                        oa.addComponent((ValueComponent)vc);
                        ndsNamespace.setAttribute(oe, oa);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    if (oe == null) {
                        oe = ndsNamespace.getObjectEntry(oeRoot, groupDN);
                    }
                    this.setGroupTrusteeRights(ndsNamespace.getDetails(oe));
                }
                catch (SPIException sPIException) {
                    // empty catch block
                }
            }
            return edasFlag;
        }
        return true;
    }

    private String getOSFilters(TaskContext context) {
        String containerTypes = "Organization,Organizational Unit,domain";
        AuthenticationBroker broker = context.getAuthenticationBroker();
        ObjectEntry oeRoot = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace ndsNamespace = (NDSNamespace)oeRoot.getNamespace();
        try {
            ClassDefinition classDefinition = ndsNamespace.getClassDefinition(oeRoot, "container");
        }
        catch (Exception e) {
            return containerTypes;
        }
        return containerTypes + ",container";
    }

    private void setGroupTrusteeRights(NSObject newObj) {
        eDirRightsObject rObj = new eDirRightsObject(newObj);
        rObj.setPropertyRights("Member", "[Root]", 2, 2);
        rObj.updateData();
    }
}

