/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;

public class DGExtendTask
extends Task {
    ResourceBundle m_res = null;
    TaskContext context;

    public boolean execute(TaskContext context, Properties resultStrings) {
        if (context.getRequest() == null) {
            return true;
        }
        HttpServletRequest req = context.getRequest();
        if (this.m_res == null) {
            this.m_res = ResourceBundle.getBundle("BaseResources", context.getLocale());
        }
        String nextState = req.getParameter("nextState");
        String targetName = eMFrameUtils.getSingleTarget((HttpServletRequest)req);
        if (targetName.length() > 0) {
            nextState = "extendObject";
        }
        if (nextState == null || nextState.equals("initialState")) {
            this.setUIPage("base/DGExtendTask.jsp");
        } else if (nextState.equalsIgnoreCase("extendObject")) {
            if (targetName.length() == 0) {
                targetName = req.getParameter("objectName");
            }
            this.doExtend(targetName, resultStrings);
        }
        return true;
    }

    private void doExtend(String object, Properties resultStrings) {
        block9: {
            String sTitle = null;
            String sMsg = null;
            try {
                Enumeration myenum;
                AuthenticationBroker broker = this.context.getAuthenticationBroker();
                ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
                NDSNamespace namespace = (NDSNamespace)treeOE.getNamespace();
                NSObject nsObj = namespace.getDetails(namespace.getObjectEntry(treeOE, object));
                ObjectAttribute oa = nsObj.getAttribute("Object Class");
                boolean found = false;
                if (oa != null && (myenum = oa.getValueComponents()) != null) {
                    while (myenum.hasMoreElements()) {
                        String value = myenum.nextElement().toString();
                        if (!value.equals("dynamicGroupAux") && !value.equals("dynamicGroup")) continue;
                        found = true;
                        break;
                    }
                }
                if (found) {
                    sTitle = this.m_res.getString("DynamicGroup.ObjectAlreadyExtendedTitle");
                    sMsg = this.m_res.getString("DynamicGroup.ObjectAlreadyExtendedMsg");
                    eMFrameUtils.setMessage((String)"error", (String)sTitle, (String)sMsg, (String)object, (MContext)this.context);
                    break block9;
                }
                try {
                    SchemaDefinition sd = namespace.getSchemaDefinition(nsObj.getObjectEntry());
                    ClassDefinition cd = sd.getClassDefinition("dynamicGroupAux");
                    ObjectAttribute[] oaa = new ObjectAttribute[1];
                    nsObj.addAuxiliaryClassDefinition(cd, oaa);
                    namespace.update(nsObj);
                    String strTitle = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"DynamicGroup.CreateExtendedObjectSuccessTitle", (MContext)this.context);
                    String strBody = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"DynamicGroup.CreateExtendedObjectSuccessTitle", (MContext)this.context);
                    eMFrameUtils.setMessage((String)"success", (String)strTitle, (String)eMFrameUtils.formatMessage((String)strBody, (Object[])new String[]{object}), (MContext)this.context);
                    resultStrings.put("GeneralMsg.ShowModifyObject", "true");
                    resultStrings.put("GeneralMsg.ModifyObjectName", eMFrameUtils.pack((String[])new String[]{object}, (MContext)this.context));
                    try {
                        ObjectEntry oe = nsObj.getObjectEntry();
                        this.context.addToHistory("dynamicGroupAux", namespace.getUnrootedName(oe));
                    }
                    catch (Exception e) {
                        D.log((Throwable)e);
                    }
                }
                catch (Exception e) {
                    eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
                }
            }
            catch (SPIException e) {
                sTitle = this.m_res.getString("DynamicGroup.CreateExtendedFailure");
                sMsg = this.m_res.getString("Common.ObjectNotFound");
                eMFrameUtils.setMessage((String)"error", (String)sTitle, (String)sMsg, (String)object, (MContext)this.context);
            }
        }
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun((HttpServletRequest)req, (String)sServiceName);
    }
}

