/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.emframe.base.DGMembersPage;
import com.novell.emframe.base.DGUtilities;
import com.novell.emframe.base.NGUtilities;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirPropertyBook;
import com.novell.emframe.dev.DirPropertyBookPage;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.PageException;
import com.novell.emframe.dev.PropertyPageContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.eMFrameUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public final class DGSettingsPage
extends DirPropertyBookPage {
    public static final String JSP_IDENTITY = "identityControl";
    public static final String JSP_TIMEOUT = "timeoutControl";
    public static final String JSP_ALLOWDUPLICATES = "duplicatesControl";
    public static final String JSP_ALLOWUNKNOWN = "unknownControl";
    private static final String ALL_MEMBERS_LIST = "ALL_MEMBERS_LIST";
    private static final String UNIQUE_MEMBERS_LIST = "UNIQUE_MEMBERS_LIST";
    private static final String EXCLUDE_MEMBERS_LIST = "EXCLUDE_MEMBERS_LIST";
    private static final String DT = "DGSettingsPage";
    private String m_identity = null;

    public void show(PropertyPageContext context) throws PageException {
        this.read(context, this.getDirPropertyBook().getNSObject());
    }

    public void cache(PropertyPageContext context) throws PageException {
        this.write(context, false, this.getDirPropertyBook().getNSObject());
        this.m_IsDirty = false;
    }

    public void commit(PropertyPageContext context) throws PageException {
        this.write(context, true, this.getDirPropertyBook().getNSObject());
    }

    private void read(PropertyPageContext context, NSObject nsObj) {
        Enumeration enumUnknown;
        ObjectAttribute oaUnknown;
        Enumeration enumDuplicates;
        ObjectAttribute oaDuplicates;
        Enumeration enumTimeout;
        ObjectAttribute oaTimeout;
        Enumeration enumIdentity;
        context.getResultStrings().put("IdentityParam", "");
        context.getResultStrings().put("TimeoutParam", "");
        context.getResultStrings().put("DuplicatesParam", "");
        context.getResultStrings().put("UnknownParam", "");
        context.getResultStrings().put("IsDynamicParam", new Boolean(DGUtilities.isGroupDynamic(this.getDirPropertyBook(), nsObj, context)).toString());
        String identity = null;
        ObjectAttribute oaIdentity = nsObj.getAttribute("dgIdentity");
        if (oaIdentity != null) {
            enumIdentity = oaIdentity.getValueComponents();
            if (enumIdentity != null && oaIdentity.getComponentCount() > 0) {
                identity = new String(enumIdentity.nextElement().toString());
                context.getResultStrings().put("IdentityParam", identity);
            }
        } else {
            this.setDefaultIdentity(context, nsObj);
            oaIdentity = nsObj.getAttribute("dgIdentity");
            if (oaIdentity != null) {
                enumIdentity = oaIdentity.getValueComponents();
                if (enumIdentity != null) {
                    identity = new String(enumIdentity.nextElement().toString());
                    context.getResultStrings().put("IdentityParam", identity);
                }
            } else {
                identity = new String("[Public]");
                context.getResultStrings().put("IdentityParam", identity);
            }
        }
        if (this.m_identity == null) {
            this.m_identity = identity;
        }
        if ((oaTimeout = nsObj.getAttribute("dgTimeOut")) != null && (enumTimeout = oaTimeout.getValueComponents()) != null) {
            context.getResultStrings().put("TimeoutParam", enumTimeout.nextElement().toString());
        }
        if ((oaDuplicates = nsObj.getAttribute("dgAllowDuplicates")) != null && (enumDuplicates = oaDuplicates.getValueComponents()) != null) {
            context.getResultStrings().put("DuplicatesParam", enumDuplicates.nextElement().toString());
        }
        if ((oaUnknown = nsObj.getAttribute("dgAllowUnknown")) != null && (enumUnknown = oaUnknown.getValueComponents()) != null) {
            context.getResultStrings().put("UnknownParam", enumUnknown.nextElement().toString());
        }
        boolean isDynamicGroup = DGUtilities.isGroupDynamic(this.getDirPropertyBook(), this.getDirPropertyBook().getNSObject(), context);
        DGSettingsPage.readMembers(context, nsObj, this.getDirPropertyBook(), null, isDynamicGroup);
    }

    private static void readMembers(PropertyPageContext context, NSObject nsObj, DirPropertyBook propertyBook, DGMembersPage membersPage, boolean bIsDynamic) {
        Vector<String> vUnique;
        Vector<String> vExclude;
        Vector<String> vAll;
        block16: {
            Enumeration enumMember;
            vAll = new Vector<String>();
            vExclude = new Vector<String>();
            vUnique = new Vector<String>();
            AuthenticationBroker broker = context.getAuthenticationBroker();
            ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
            NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
            if (bIsDynamic) {
                try {
                    NSObject nsObj2;
                    nsObj = nsObj2 = ns.getDetails(nsObj.getObjectEntry());
                }
                catch (SPIException nsObj2) {
                    // empty catch block
                }
            }
            ObjectAttribute oaMember = nsObj.getAttribute("Member");
            ArrayList<String> arrayListAll = new ArrayList<String>();
            if (oaMember != null && (enumMember = oaMember.getValueComponents()) != null) {
                while (enumMember.hasMoreElements()) {
                    String s = enumMember.nextElement().toString();
                    vAll.add(s);
                    arrayListAll.add(s);
                }
            }
            if (membersPage != null) {
                membersPage.m_initialValues = (ArrayList)arrayListAll.clone();
                membersPage.m_currentValues = (ArrayList)arrayListAll.clone();
            }
            if (bIsDynamic) {
                Enumeration enumEMember;
                ObjectAttribute oaEMember = nsObj.getAttribute("excludedMember");
                if (oaEMember != null && (enumEMember = oaEMember.getValueComponents()) != null) {
                    while (enumEMember.hasMoreElements()) {
                        vExclude.add(enumEMember.nextElement().toString());
                    }
                }
                try {
                    Enumeration enumUMember;
                    String[] attrs = new String[]{"Member"};
                    ObjectAttribute[] oas = ns.getAttributes(nsObj.getObjectEntry(), attrs, 1, null);
                    ObjectAttribute oaUMember = oas[0];
                    if (oaUMember != null && (enumUMember = oaUMember.getValueComponents()) != null) {
                        while (enumUMember.hasMoreElements()) {
                            vUnique.add(enumUMember.nextElement().toString());
                        }
                    }
                }
                catch (Exception e) {
                    if (!(e instanceof UniqueSPIException) || ((UniqueSPIException)e).getErrorCode() != -6016) break block16;
                    ResourceBundle m_res = ResourceBundle.getBundle("BaseResources", context.getLocale());
                    String sTitle = m_res.getString("DynamicGroup.PartialResultTitle");
                    String sMsg = m_res.getString("DynamicGroup.PartialResultMsg");
                    eMFrameUtils.setMessage((String)"error", (String)sTitle, (String)sMsg, (MContext)context);
                    try {
                        ObjectAttribute oa = nsObj.getAttribute("dgTimeOut");
                        if (oa != null) {
                            oa.removeAllComponents();
                            ValueComponent vc = NDSSyntax.SYN_INTEGER.createValueComponent((Object)Integer.valueOf("60000"));
                            oa.addComponent(vc);
                            ns.update(nsObj);
                        }
                    }
                    catch (Exception e1) {
                        D.log((Throwable)e1);
                    }
                }
            }
        }
        propertyBook.getCache().put(ALL_MEMBERS_LIST, vAll);
        propertyBook.getCache().put(UNIQUE_MEMBERS_LIST, vUnique);
        propertyBook.getCache().put(EXCLUDE_MEMBERS_LIST, vExclude);
        DGSettingsPage.outputMemberData(context, propertyBook, vAll, vUnique, vExclude, bIsDynamic);
    }

    private static void outputMemberData(PropertyPageContext context, DirPropertyBook propertyBook, Vector vAll, Vector vUnique, Vector vExclude, boolean bIsDynamic) {
        int i;
        Properties results = context.getResultStrings();
        results.put("AllMembersParam", "");
        results.put("ExcludedMembersParam", "");
        results.put("UniqueMembersParam", "");
        results.put("DynamicMembersParam", "");
        results.put("AllMembersParamCount", "0");
        results.put("ExcludedMembersParamCount", "0");
        results.put("UniqueMembersParamCount", "0");
        results.put("DynamicMembersParamCount", "0");
        ArrayList<String> arrayListAll = new ArrayList<String>();
        Object[] oa = new Object[vAll.size()];
        String[] array = new String[vAll.size()];
        oa = vAll.toArray();
        for (i = 0; i < oa.length; ++i) {
            arrayListAll.add((String)oa[i]);
            array[i] = (String)oa[i];
        }
        results.put("AllMembersParam", arrayListAll);
        results.put("AllMembersParamCount", new Integer(arrayListAll.size()).toString());
        if (!bIsDynamic) {
            results.put("UniqueMembersParam", eMFrameUtils.pack((String[])array, (MContext)context));
            results.put("UniqueMembersParamCount", new Integer(arrayListAll.size()).toString());
        } else {
            oa = new Object[vExclude.size()];
            array = new String[vExclude.size()];
            oa = vExclude.toArray();
            for (i = 0; i < oa.length; ++i) {
                array[i] = (String)oa[i];
            }
            results.put("ExcludedMembersParam", eMFrameUtils.pack((String[])array, (MContext)context));
            results.put("ExcludedMembersParamCount", new Integer(array.length).toString());
            oa = new Object[vUnique.size()];
            array = new String[vUnique.size()];
            oa = vUnique.toArray();
            for (i = 0; i < oa.length; ++i) {
                array[i] = (String)oa[i];
            }
            results.put("UniqueMembersParam", eMFrameUtils.pack((String[])array, (MContext)context));
            results.put("UniqueMembersParamCount", new Integer(array.length).toString());
        }
        DGMembersPage.outputDynamicMembers(context, propertyBook, bIsDynamic, NGUtilities.isGroupNested((DirPropertyBook)propertyBook, (PropertyPageContext)context), false);
    }

    private void validateIdentity(PropertyPageContext context, String identity) throws PageException {
        AuthenticationBroker broker = context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
        NSObject nsObj = null;
        if (identity.equalsIgnoreCase("[Public]")) {
            return;
        }
        try {
            nsObj = ns.getDetails(ns.getObjectEntry(treeOE, identity));
        }
        catch (SPIException e) {
            throw new PageException((Exception)((Object)e));
        }
        DirUtils dirUtils = context.getDirUtils();
        if (!DirUtils.isOfType((ObjectType)nsObj.getObjectEntry().getObjectType(), (String)"ndsLoginProperties", (boolean)true)) {
            String header = eMFrameUtils.getLocalizedString((String)"DevResources", (String)"GeneralMsg.Error", (MContext)context);
            String pattern = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"MultiDNPage.incorrectObjectType", (MContext)context);
            String body = eMFrameUtils.formatMessage((String)pattern, (Object[])new String[]{identity, "ndsLoginProperties"});
            throw new PageException(header, body);
        }
    }

    private void write(PropertyPageContext context, boolean applyPressed, NSObject nsObj) throws PageException {
        if (DGUtilities.isGroupDynamic(this.getDirPropertyBook(), nsObj, context)) {
            HttpServletRequest req = context.getRequest();
            String identity = req.getParameter(JSP_IDENTITY);
            String timeout = req.getParameter(JSP_TIMEOUT);
            String duplicates = req.getParameter(JSP_ALLOWDUPLICATES);
            String unknown = req.getParameter(JSP_ALLOWUNKNOWN);
            if (identity != null && identity.length() > 0) {
                this.validateIdentity(context, identity);
            } else {
                identity = new String("[Public]");
            }
            this.addValue(context, nsObj, identity, "dgIdentity");
            this.addValue(context, nsObj, timeout, "dgTimeOut");
            this.addValue(context, nsObj, duplicates, "dgAllowDuplicates");
            this.addValue(context, nsObj, unknown, "dgAllowUnknown");
            if (applyPressed && !identity.equals(this.m_identity)) {
                this.m_identity = null;
                DGMembersPage.resetMemberList(this.getDirPropertyBook(), context);
            }
        }
    }

    private void setDefaultIdentity(PropertyPageContext context, NSObject nsObj) {
        AuthenticationBroker broker = context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
        ObjectAttribute oa = nsObj.getAttribute("dgIdentity");
        try {
            if (oa == null) {
                NDSAttributeDefinition def = (NDSAttributeDefinition)ns.getAttributeDefinition(treeOE, "dgIdentity");
                oa = new ObjectAttribute((AttributeDefinition)def);
                ObjectAttribute pk = nsObj.getAttribute("Public Key");
                ObjectEntry oe = pk != null ? nsObj.getObjectEntry() : null;
                if (oe != null) {
                    ValueComponent vc = NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)ns.getUnrootedName(oe));
                    oa.addComponent(vc);
                    nsObj.addAttribute(oa);
                }
            }
        }
        catch (Exception e) {
            D.log((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addValue(PropertyPageContext context, NSObject nsObj, String newValue, String attribute) {
        ObjectAttribute oa;
        boolean addAttribute;
        block16: {
            addAttribute = false;
            AuthenticationBroker broker = context.getAuthenticationBroker();
            ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
            NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
            oa = nsObj.getAttribute(attribute);
            if (oa == null) {
                try {
                    NDSAttributeDefinition def = (NDSAttributeDefinition)ns.getAttributeDefinition(treeOE, attribute);
                    oa = new ObjectAttribute((AttributeDefinition)def);
                    addAttribute = true;
                }
                catch (Exception e) {
                    eMFrameUtils.setErrorMessage((Throwable)e, (MContext)context);
                    return;
                }
            } else {
                oa.removeAllComponents();
            }
            try {
                if (attribute.equals("dgIdentity")) {
                    if (!newValue.equals("[Public]")) {
                        ObjectEntry valueOE = ns.getObjectEntry(treeOE, newValue);
                        ValueComponent vc = NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)ns.getUnrootedName(valueOE));
                        oa.addComponent(vc);
                        context.addToHistory(valueOE);
                    }
                    break block16;
                }
                if (attribute.equals("dgTimeOut")) {
                    if (newValue != null && !newValue.equals("")) {
                        ValueComponent vc = NDSSyntax.SYN_INTEGER.createValueComponent((Object)Integer.valueOf(newValue));
                        oa.addComponent(vc);
                    }
                    break block16;
                }
                newValue = newValue == null ? "false" : "true";
                ValueComponent vc = NDSSyntax.SYN_BOOLEAN.createValueComponent((Object)Boolean.valueOf(newValue));
                oa.addComponent(vc);
            }
            catch (SPIException e) {
                if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -606) {
                    // empty if block
                }
            }
            catch (ComponentCreationException e) {
                eMFrameUtils.setErrorMessage((Throwable)e, (MContext)context);
                return;
            }
            catch (NamespaceException e) {
                eMFrameUtils.setErrorMessage((Throwable)e, (MContext)context);
                return;
            }
            catch (NumberFormatException e) {
                eMFrameUtils.setErrorMessage((Throwable)e, (MContext)context);
                return;
            }
        }
        if (!addAttribute) return;
        if (oa.getComponentCount() <= 0) return;
        try {
            nsObj.addAttribute(oa);
            return;
        }
        catch (Exception e) {
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)context);
        }
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun((HttpServletRequest)req, (String)sServiceName);
    }
}

