/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.mozilla.IIDStore;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIInputStream;
import org.eclipse.swt.internal.mozilla.nsISupports;

class InputStream {
    XPCOMObject inputStream;
    int refCount = 0;
    byte[] buffer;
    int index = 0;

    InputStream(byte[] buffer) {
        this.buffer = buffer;
        this.index = 0;
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.inputStream = new XPCOMObject(new int[]{2, 0, 0, 0, 1, 3, 4, 1}){

            public long method0(long[] args) {
                return InputStream.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return InputStream.this.AddRef();
            }

            public long method2(long[] args) {
                return InputStream.this.Release();
            }

            public long method3(long[] args) {
                return InputStream.this.Close();
            }

            public long method4(long[] args) {
                return InputStream.this.Available(args[0]);
            }

            public long method5(long[] args) {
                return InputStream.this.Read(args[0], (int)args[1], args[2]);
            }

            public long method6(long[] args) {
                return InputStream.this.ReadSegments(args[0], args[1], (int)args[2], args[3]);
            }

            public long method7(long[] args) {
                return InputStream.this.IsNonBlocking(args[0]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.inputStream != null) {
            this.inputStream.dispose();
            this.inputStream = null;
        }
    }

    long getAddress() {
        return this.inputStream.getAddress();
    }

    int QueryInterface(long riid, long ppvObject) {
        if (riid == 0L || ppvObject == 0L) {
            return -2147467262;
        }
        nsID guid = new nsID();
        XPCOM.memmove(guid, riid, 16);
        if (guid.Equals(IIDStore.GetIID(nsISupports.class))) {
            XPCOM.memmove(ppvObject, new long[]{this.inputStream.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(IIDStore.GetIID(nsIInputStream.class))) {
            XPCOM.memmove(ppvObject, new long[]{this.inputStream.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(ppvObject, new long[]{0L}, (long)C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int Close() {
        this.buffer = null;
        this.index = 0;
        return 0;
    }

    int Available(long _retval) {
        int available = this.buffer == null ? 0 : this.buffer.length - this.index;
        XPCOM.memmove(_retval, new int[]{available}, 4L);
        return 0;
    }

    int Read(long aBuf, int aCount, long _retval) {
        int max = Math.min(aCount, this.buffer == null ? 0 : this.buffer.length - this.index);
        if (max > 0) {
            byte[] src = new byte[max];
            System.arraycopy(this.buffer, this.index, src, 0, max);
            XPCOM.memmove(aBuf, src, (long)max);
            this.index += max;
        }
        XPCOM.memmove(_retval, new int[]{max}, 4L);
        return 0;
    }

    int ReadSegments(long aWriter, long aClosure, int aCount, long _retval) {
        int cnt;
        int[] aWriteCount;
        int max;
        int n = max = this.buffer == null ? 0 : this.buffer.length - this.index;
        if (aCount != -1) {
            max = Math.min(max, aCount);
        }
        for (cnt = max; cnt > 0; cnt -= aWriteCount[0]) {
            aWriteCount = new int[1];
            long rc = XPCOM.Call(aWriter, this.getAddress(), aClosure, this.buffer, this.index, cnt, aWriteCount);
            if (rc != 0L) break;
            this.index += aWriteCount[0];
        }
        XPCOM.memmove(_retval, new int[]{max - cnt}, 4L);
        return 0;
    }

    int IsNonBlocking(long _retval) {
        XPCOM.memmove(_retval, new boolean[]{false});
        return 0;
    }
}

